/*
        File:           ENV.HPP
        
        Revision:       2.0 Release
        
        Date:           14-Mar-94

        Author:         Dale Hunscher
        
        Description:
        
        This file describes the interface to the environment class. It
        provides a functional interface to the ODBC environment for
        connections, statements, and other entities in the library.

        Engineers:
        DAH             Dale A. Hunscher
        
        Revision History
        ================
        Date            Who     Did What
        -------------------------------------------------------------
        04-Mar-94       DAH     Added support for ODBC Cursor Library.

        15-May-94       DAH     Added new functions Drivers(), FirstDriver(),
                                and NextDriver(), and new data members szDriver
                                and szDriverAttributes.
                                
        28-May-94       DAH     Corrected udTimeout on AllocConnect;
                                default value of 5 was causing Btrieve 
                                connection attempts during construction
                                to fail.
		  10-Nov-94       DAH     Added virtual destructor for odbcCONNELEM.

		  07-Dec-94			DAH	  Removed default from first argument of
										  one of the two forms of AllocConnect,
										  to avoid getting 'ambiguous overload'
										  messages when users call with all
										  default values.

        /////////////////////////////////////////////////////////////
        ///////////////////// NOTICE ////////////////////////////////
        /////////////////////////////////////////////////////////////
                                                                             
        Copyright (c) 1993-1995 by INTERSOLV, Inc. All rights reserved.

        Information in this document is subject to change without
        notice and does not represent a commitment on the part of
        INTERSOLV, Inc. This software is provided under
        a license agreement or non-disclosure agreement. The software
        may be used and/or copied only in accordance with the terms
        of the governing agreement. It is against the law to copy
        the software on any medium except as specifically allowed
        in the governing agreement. No part of this software may be 
        reproduced or transmitted in any form or by any means, 
        electronic or mechanical, including photocopying, recording,
        or information storage and retrieval systems, for any purpose
        other than the licensee's personal use, without the express
        written permission of INTERSOLV, Inc.
        
        /////////////////////////////////////////////////////////////
*/

#if !defined(_ENV_HPP)
#define _ENV_HPP

///////////////////////////////////////////////////////////
////////////////// list of connections ////////////////////
///////////////////////////////////////////////////////////

/*
        These two classes provide a very limited linked-list
        of ODBC connections (pointers to objects of class
        odbcCONNECT). This is used to keep track
        of existing connections associated with a given
        odbcENV object.
*/

// list element class
class odbcEXPORTED odbcCONNELEM {
public:
		MSVC_BUGFIX_DCL		// macro definition in sqldefs.hpp

/**********************************************************
        pItem
        
        pointer to instance of class odbcCONNECT.                            
**********************************************************/

        podbcCONNECT pItem;
        
/**********************************************************
        pNext
        
        pointer to next item in the list.                            
**********************************************************/

        podbcCONNELEM pNext;
        
/**********************************************************
        odbcCONNELEM
        
        The class's only constructor.                            
**********************************************************/

        odbcCONNELEM(podbcCONNECT p)
                {
                pItem = p;
                pNext = NULL;
                };
                
/**********************************************************
        ~odbcCONNELEM
        
        The class's destructor.                            
**********************************************************/

        virtual ~odbcCONNELEM(void ) ;
};                      

// list class

class odbcEXPORTED odbcCONNLIST {
public:
		MSVC_BUGFIX_DCL		// macro definition in sqldefs.hpp
private:
/**********************************************************
        fDestroyElems
        
        flag that says whether delete should be invoked when
        an item is removed from the list.                            
**********************************************************/

int fDestroyElems;

/**********************************************************
        pBegin
        
        pointer to first list element.                            
**********************************************************/

podbcCONNELEM pBegin;

/**********************************************************
        pEnd
        
        pointer to last list element.                            
**********************************************************/

podbcCONNELEM pEnd;

public:

/**********************************************************
        odbcCONNLIST
        
        The class's only constructor. Flag argument determines
        whether we automatically invoke delete on the pItem
        member of the list element; default is to delete.                            
**********************************************************/

odbcCONNLIST(int DestroyElems = FALSE);

/**********************************************************
        ~odbcCONNLIST
        
        The class's destructor.                            
**********************************************************/

virtual ~odbcCONNLIST();

/**********************************************************
        Add
        
        Add a new item to the list.                            
**********************************************************/

virtual void Add(podbcCONNECT pItem);

/**********************************************************
        Remove
        
        Remove a given item from the list. Invoke delete on the
        pItem member of the list element if the DestroyElems
        flag is set.
**********************************************************/

virtual void Remove(podbcCONNECT pItem);
};

///////////////////////////////////////////////////////////
//////////////////////// environment
///////////////////////////////////////////////////////////

class odbcEXPORTED odbcENV : public odbcBASE {

/**********************************************************
        friend classes
        
        Connection must be friend class so it
        can call RegisterConnection() to register its instances.
**********************************************************/

friend class odbcEXPORTED odbcCONNECT;

private:
/**********************************************************
    henv
    
    ODBC environment handle.
**********************************************************/

        HENV henv;
        
/**********************************************************
    pConnList
    
    list of odbcCONNECT connection objects.
**********************************************************/

        odbcCONNLIST *pConnList;
        
/**********************************************************
        RegisterConnection
        
        Register an odbcCONNECT object.
**********************************************************/

        virtual void RegisterConnection(podbcCONNECT pConnection);
                
/**********************************************************
        UnregisterConnection
        
        Unregister an odbcCONNECT object.
**********************************************************/

        virtual void UnregisterConnection(podbcCONNECT pConnection);
                
/**********************************************************
    szDSN
    
    Data source name returned from FirstDataSource or
    NextDataSource.
**********************************************************/

        LPSTR szDSN;

/**********************************************************
    szDescription
    
    Data source description returned from FirstDataSource or
    NextDataSource.
**********************************************************/

        LPSTR szDescription;

#if (ODBCVER >= 0x0200)
/**********************************************************
    szDriver
    
    Data source name returned from FirstDriver or
    NextDriver.
**********************************************************/

        LPSTR szDriver;

/**********************************************************
    szDriverAttributes
    
    Driver attributes returned from FirstDriver or
    NextDriver.
**********************************************************/

        LPSTR szDriverAttributes;

#endif // if (ODBCVER >= 0x0200)

public:

/**********************************************************
    nCursorLibUsage
    
    Constant to define cursor library usage; can be one of
    
    SQL_CUR_USE_IF_NEEDED Use if needed
    SQL_CUR_USE_ODBC      Use cursor library always
    SQL_CUR_USE_DRIVER    Never use cursor library
    SQL_CUR_DEFAULT       Default is never use cursor library

**********************************************************/

        int nCursorLibUsage;

/**********************************************************

        odbcENV()
        
        default constructor. Allocates an ODBC environment
        handle.
**********************************************************/

        odbcENV();
           
           
/**********************************************************

        ~odbcENV()
        
        destructor. De-allocates ODBC environment handle.
**********************************************************/

        virtual ~odbcENV();

/**********************************************************

        GetHenv()
        
        Returns ODBC environment handle.
**********************************************************/

        virtual HENV    GetHenv(void) { return henv;};
        ////////////////////////////////////////////////////////
        ////////////////////// core functions //////////////////
        ////////////////////////////////////////////////////////


/**********************************************************

        AllocConnect
        
        Allocates and optionally opens a connection on an
        odbcCONNECT object.
        
        Connections should always be allocated this way and 
        deallocated using DeAllocConnect.
        
        If the return value is NULL, call lastRC() to determine
        the return code from the ODBC function that failed.
**********************************************************/

        virtual podbcCONNECT 
                AllocConnect(
                        LPUSTR szDSN,
                        LPUSTR szUID       = NULL,
                        LPUSTR szAuthStr   = NULL,
                        UDWORD udTimeout   = 0
                        );
                                                       
                                                       
        virtual podbcCONNECT 
                AllocConnect(
                        LPSTR  szDSN       = NULL,
                        LPSTR  szUID       = NULL,
                        LPSTR  szAuthStr   = NULL,
                        UDWORD udTimeout   = 0
                        )
                        {
                        return
                                AllocConnect(
                                        (LPUSTR)szDSN,
                                        (LPUSTR)szUID,
                                        (LPUSTR)szAuthStr,
                                        udTimeout
                        );
                        };                             
                                                       
/**********************************************************

        DeAllocConnect
        
        Deallocates an odbcCONNECT object.
        
**********************************************************/

        virtual void DeAllocConnect(
                        podbcCONNECT pConn
                        );
                                                       
                                                       
/**********************************************************

        RegisterError
        
        Get more information on the most recent error code
        from an ODBC operation. Results can be retrieved using
        member functions in the parent odbcBASE class.
        
        This function calls the base class member function Error()
        with arguments appropriate for this object type.
**********************************************************/

        virtual RETCODE RegisterError(void);

/**********************************************************
    Commit
    
    Call to SQLTransact to commit a transaction across multiple 
    connections.
**********************************************************/

        virtual RETCODE Commit(void);

/**********************************************************
    RollBack
    
    Call to SQLTransact to roll back a transaction across multiple 
    connections.
**********************************************************/

        virtual RETCODE RollBack(void);

        ////////////////////////////////////////////////////////
        ////////////////////// level 1 functions ///////////////
        ////////////////////////////////////////////////////////

        ////////////////////////////////////////////////////////
        ////////////////////// level 2 functions ///////////////
        ////////////////////////////////////////////////////////
        
/**********************************************************

        DataSources
        
        Translates into direct call to SQLDataSources.
**********************************************************/

        virtual RETCODE DataSources(
                                        UWORD           fDirection,
                                        LPUSTR          szDSN,
                                        WORD            cbDSNMax,
                                        SWORD      *pcbDSN,
                                        LPUSTR          szDescription,
                                        SWORD           cbDescriptionMax,
                                        SWORD      *pcbDescription);
    
        virtual RETCODE DataSources(
                                        UWORD           fDirection,
                                        LPSTR           szDSN,
                                        WORD            cbDSNMax,
                                        SWORD      *pcbDSN,
                                        LPSTR           szDescription,
                                        SWORD           cbDescriptionMax,
                                        SWORD      *pcbDescription)
                                        {
                                        return
                                                DataSources(
                                                        fDirection,
                                                        (LPUSTR)szDSN,
                                                        cbDSNMax,
                                                        pcbDSN,
                                                        (LPUSTR)szDescription,
                                                        cbDescriptionMax,
                                                        pcbDescription);
                                        };
    
/***************************************************

    FirstDataSource
    
    Invokes DataSources member function to get the first
    data source name and description.  These can be accessed
    via the DSN() and DSNDesc() member functions.
***************************************************/

        virtual RETCODE FirstDataSource(void);

/***************************************************

    NextDataSource
    
    Invokes DataSources member function to get the next
    data source name and description.  These can be accessed
    via the DSN() and DSNDesc() member functions.
***************************************************/

        virtual RETCODE NextDataSource(void);
    
    /***************************************************

    DSN
    
    Pointer to data source name returned by FirstDataSource
    and NextDataSource.  NULL if these have never been invoked
    or did not succeed!
    ***************************************************/
    virtual LPCSTR DSN(void) 
                {
                return szDSN;
                };
                
    /***************************************************

    Description
    
    Pointer to data source description returned by FirstDataSource
    and NextDataSource.  NULL if these have never been invoked
    or did not succeed!
    ***************************************************/
    virtual LPCSTR Description(void) 
                {
                return szDescription;
                };

// new in v2.0

#if (ODBCVER >= 0x0200)
/**********************************************************

        Drivers
        
        Translates into direct call to SQLDrivers.
**********************************************************/

        virtual RETCODE Drivers(
                                        UWORD           fDirection,
                                        LPUSTR          szDriver,
                                        WORD            cbDriverMax,
                                        SWORD      *pcbDriver,
                                        LPUSTR          szDriverAttributes,
                                        SWORD           cbDriverAttributesMax,
                                        SWORD      *pcbDriverAttributes);
    
        virtual RETCODE Drivers(
                                        UWORD           fDirection,
                                        LPSTR           szDriver,
                                        WORD            cbDriverMax,
                                        SWORD      *pcbDriver,
                                        LPSTR           szDriverAttributes,
                                        SWORD           cbDriverAttributesMax,
                                        SWORD      *pcbDriverAttributes)
                                        {
                                        return
                                                Drivers(
                                                        fDirection,
                                                        (LPUSTR)szDriver,
                                                        cbDriverMax,
                                                        pcbDriver,
                                                        (LPUSTR)szDriverAttributes,
                                                        cbDriverAttributesMax,
                                                        pcbDriverAttributes);
                                        };
    
/***************************************************

    FirstDriver
    
    Invokes Drivers member function to get the first
    data source name and description.  These can be accessed
    via the Driver() and DriverAttributes() member functions.
***************************************************/

        virtual RETCODE FirstDriver(void);

/***************************************************

    NextDriver
    
    Invokes Drivers member function to get the next
    data source name and attributes.  These can be accessed
    via the Driver() and DriverAttributes() member functions.
***************************************************/

        virtual RETCODE NextDriver(void);
    
    /***************************************************

    Driver
    
    Pointer to data source name returned by FirstDriver
    and NextDriver.  NULL if these have never been invoked
    or did not succeed!
    ***************************************************/
    virtual LPCSTR Driver(void)
                {
                return szDriver;
                };
                
    /***************************************************

    DriverAttributes
    
    Pointer to driver attributes returned by FirstDriver
    and NextDriver.  NULL if these have never been invoked
    or did not succeed!
    ***************************************************/
    virtual LPCSTR DriverAttributes(void)
                {
                return szDriverAttributes;
                };

#endif // if (ODBCVER >= 0x0200)

// end new in v2.0

};


#endif // if !defined(_ENV_HPP)

