/*
        File:           ENV.CPP
        
        Revision:       2.0 Release
        
        Date:           14-Mar-94

        Author:         Dale Hunscher
        
        Description:
        
        This file gives the implementation of the environment class. It
        provides a functional interface to the ODBC environment for
        connections, statements, and other entities in the library.
        
    Engineers:
        DAH             Dale A. Hunscher
        
        Revision History
        ================
        Date            Who             Did What
        --------------- --------------- -----------------------------
    15-May-94       DAH             Added Drivers(), FirstDriver(),
                                    NextDriver(); modified constructor
                                    and destructor to reflect new
                                    data members.
                                       
        /////////////////////////////////////////////////////////////
        ///////////////////// NOTICE ////////////////////////////////
        /////////////////////////////////////////////////////////////
                                                                             
        Copyright (c) 1993-1995 by INTERSOLV, Inc. All rights reserved.
        
        Information in this document is subject to change without
        notice and does not represent a commitment on the part of
        INTERSOLV, Inc. This software is provided under
        a license agreement or non-disclosure agreement. The software
        may be used and/or copied only in accordance with the terms
        of the governing agreement. It is against the law to copy
        the software on any medium except as specifically allowed
        in the governing agreement. No part of this software may be 
        reproduced or transmitted in any form or by any means, 
        electronic or mechanical, including photocopying, recording,
        or information storage and retrieval systems, for any purpose
        other than the licensee's personal use, without the express
        written permission of INTERSOLV, Inc.
        
        /////////////////////////////////////////////////////////////
*/

#include <sql.hpp>

///////////////////////////////////////////////////////////
//////////////////////// environment
///////////////////////////////////////////////////////////


/**********************************************************

        odbcENV()
        
        default constructor. Allocates an ODBC environment
        handle.
**********************************************************/

        odbcENV::odbcENV() : odbcBASE()
        {
        AutoRetrieve(odbcREPERRS);
        SetRC(SQLAllocEnv(
                        &henv));
        pConnList = 0;
        AutoRetrieve(odbcNOREPORT);
        szDSN = NULL;
        szDescription = NULL;
    nCursorLibUsage = SQL_CUR_DEFAULT;
#if (ODBCVER >= 0x0200)
    szDriver = NULL;
    szDriverAttributes = NULL;
#endif // if (ODBCVER >= 0x0200)
        };

/**********************************************************

        ~odbcENV()
        
        destructor. De-allocates ODBC environment handle.
**********************************************************/

        odbcENV::~odbcENV()
        {
        // drop all connections
        if (pConnList)
            {
            delete pConnList;
            pConnList = NULL;
            }

        // free environment handle
        if (henv)
            {
                    SQLFreeEnv(henv);
            henv = NULL;
            }

        // free locally allocated memroy
                if (szDSN)
            {
                        delete[] szDSN;
            szDSN = NULL;
            }

                if (szDescription)
            {
                        delete[] szDescription;
            szDescription = NULL;
            }


#if (ODBCVER >= 0x0200)
                if (szDriver)
            {
                        delete[] szDriver;
            szDriver = NULL;
            }

                if (szDriverAttributes)
            {
                        delete[] szDriverAttributes;
            szDriverAttributes = NULL;
            }
            
#endif // if (ODBCVER >= 0x0200)
        };

/**********************************************************

        AllocConnect
        
        Allocates and optionally opens a connection on an
        odbcCONNECT object.
        
        Connections should always be allocated this way and 
        deallocated using DeAllocConnect.
        
        If the return value is NULL, call lastRC() to determine
        the return code from the ODBC function that failed.
**********************************************************/

podbcCONNECT odbcENV::AllocConnect(
                        LPUSTR szDSN,
                        LPUSTR szUID,
                        LPUSTR szAuthStr,
                                UDWORD      udTimeout
                        )
                {
                podbcCONNECT pC = new odbcCONNECT(
                                        this, 
                                        szDSN,
                                        szUID,
                                        szAuthStr,
                                        udTimeout);

                if (!pC)
            {
            SetRC(SQL_ALLOC_FAILED);
                        return NULL;
                        }

                return pC;
                };

/**********************************************************

        AllocConnect
        
        Deallocates an odbcCONNECT object.
        
**********************************************************/

void odbcENV::DeAllocConnect(
                        podbcCONNECT pC
                        )
                {
        if (pC)
                    delete pC;
                };

/**********************************************************
        RegisterConnection
        
        Register an odbcSTMT object.
**********************************************************/

void odbcENV::RegisterConnection(podbcCONNECT pConnection)
        {
        if (!pConnList)
                pConnList = new odbcCONNLIST;
        if (!pConnList)
           {
           SetRC(SQL_ALLOC_FAILED);
           }
        else
            pConnList->Add(pConnection);
        
        }
                

/**********************************************************
        UnregisterConnection
        
        Unregister an odbcSTMT object.
**********************************************************/

void odbcENV::UnregisterConnection(podbcCONNECT pConnection)
        {
        if (pConnList)
                pConnList->Remove(pConnection);
        }
                

/**********************************************************

        RegisterError
        
        Get more information on the most recent error code
        from an ODBC operation. Results can be retrieved using
        member functions in the parent odbcBASE class.
**********************************************************/

RETCODE odbcENV::RegisterError(void)
                {
                return Error(
                        henv,
                        SQL_NULL_HDBC,
                        SQL_NULL_HSTMT);
                };

/**********************************************************
    Commit
    
    Call to SQLTransact to commit a transaction across multiple 
    connections.
**********************************************************/

RETCODE odbcENV::Commit(void)
                {
                SetRC(SQLTransact(
                        henv,
                        SQL_NULL_HDBC,
                        SQL_COMMIT
                        ));

                return lastRC();
                };

/**********************************************************
    RollBack
    
    Call to SQLTransact to roll back a transaction across multiple 
    connections.
**********************************************************/

RETCODE odbcENV::RollBack(void)
                {
                SetRC(SQLTransact(
                        henv,
                        SQL_NULL_HDBC,
                        SQL_ROLLBACK
                        ));

                return lastRC();
                };

/**********************************************************

        DataSources
        
        Translates into direct call to SQLDataSources.
**********************************************************/

RETCODE odbcENV::DataSources(
                                        UWORD           fDirection,
                                        LPUSTR          szDSN,
                                        WORD            cbDSNMax,
                                        SWORD      *pcbDSN,
                                        LPUSTR          szDescription,
                                        SWORD           cbDescriptionMax,
                                        SWORD      *pcbDescription)
    {
    SetRC(
        SQLDataSources(
                henv,
                fDirection,
                szDSN,
                cbDSNMax,
                pcbDSN,
                szDescription,
                cbDescriptionMax,
                pcbDescription));
                
    return lastRC();
    }

/***************************************************

    FirstDataSource
    
    Invokes DataSources member function to get the first
    data source name and description.  These can be accessed
    via the DSN() and DSNDesc() member functions.
***************************************************/

RETCODE odbcENV::FirstDataSource(void)
    {
    SWORD cbDSN, cbDescription;
    
    if (!szDSN)
        {
        szDSN = (LPSTR)new UCHAR[SQL_MAX_DSN_LENGTH];
        if (!szDSN)
           {
           SetRC(SQL_ALLOC_FAILED);
           return lastRC();
           }
        }
        
    if (!szDescription)
        {
        szDescription = (LPSTR)new UCHAR[DSN_DESC_MAX];
        if (!szDescription)
           {
           SetRC(SQL_ALLOC_FAILED);
           return lastRC();
           }
        }
        
    return
        DataSources(
                SQL_FETCH_FIRST,
                (LPUSTR )szDSN,
                SQL_MAX_DSN_LENGTH,
                &cbDSN,
                (LPUSTR )szDescription,
                DSN_DESC_MAX,
                &cbDescription);
    }

/***************************************************

    NextDataSource
    
    Invokes DataSources member function to get the next
    data source name and description.  These can be accessed
    via the DSN() and DSNDesc() member functions.
***************************************************/

RETCODE odbcENV::NextDataSource(void)
    {
    SWORD cbDSN, cbDescription;
    
    if (!szDSN)
        {
        szDSN = (LPSTR)new UCHAR[SQL_MAX_DSN_LENGTH];
        if (!szDSN)
           {
           SetRC(SQL_ALLOC_FAILED);
           return lastRC();
           }
        }
        
    if (!szDescription)
        {
        szDescription = (LPSTR)new UCHAR[DSN_DESC_MAX];
        if (!szDescription)
           {
           SetRC(SQL_ALLOC_FAILED);
           return lastRC();
           }
        }
        
    return
        DataSources(
                SQL_FETCH_NEXT,
                (LPUSTR )szDSN,
                SQL_MAX_DSN_LENGTH,
                &cbDSN,
                (LPUSTR )szDescription,
                DSN_DESC_MAX,
                &cbDescription);
    }

#if (ODBCVER >= 0x0200)
/**********************************************************

        Drivers
        
        Translates into direct call to SQLDrivers.
**********************************************************/

RETCODE odbcENV::Drivers(
                                        UWORD           fDirection,
                                        LPUSTR          szDriver,
                                        WORD            cbDriverMax,
                                        SWORD      *pcbDriver,
                                        LPUSTR          szDriverAttributes,
                                        SWORD           cbDriverAttributesMax,
                                        SWORD      *pcbDriverAttributes)
    {
    SetRC(
        SQLDrivers(
                henv,
                fDirection,
                szDriver,
                cbDriverMax,
                pcbDriver,
                szDriverAttributes,
                cbDriverAttributesMax,
                pcbDriverAttributes));
                
    return lastRC();
    }

/***************************************************

    FirstDriver
    
    Invokes Drivers member function to get the first
    data source name and driver attributes.  These can be accessed
    via the Driver() and DriverDesc() member functions.
***************************************************/

RETCODE odbcENV::FirstDriver(void)
    {
    SWORD cbDriver, cbDriverAttributes;
    
    if (!szDriver)
        {
        szDriver = (LPSTR)new UCHAR[DRIVER_MAX];
        if (!szDriver)
           {
           SetRC(SQL_ALLOC_FAILED);
           return lastRC();
           }
        }
        
    if (!szDriverAttributes)
        {
        szDriverAttributes = (LPSTR)new UCHAR[DRIVER_ATTRIBS_MAX];
        if (!szDriverAttributes)
           {
           SetRC(SQL_ALLOC_FAILED);
           return lastRC();
           }
        }
        
    return
        Drivers(
                SQL_FETCH_FIRST,
                (LPUSTR )szDriver,
                DRIVER_MAX,
                &cbDriver,
                (LPUSTR )szDriverAttributes,
                DRIVER_ATTRIBS_MAX,
                &cbDriverAttributes);
    }

/***************************************************

    NextDriver
    
    Invokes Drivers member function to get the next
    data source name and driver attributes.  These can be accessed
    via the Driver() and DSNDesc() member functions.
***************************************************/

RETCODE odbcENV::NextDriver(void)
    {
    SWORD cbDriver, cbDriverAttributes;
    
    if (!szDriver)
        {
        szDriver = (LPSTR)new UCHAR[DRIVER_MAX];
        if (!szDriver)
           {
           SetRC(SQL_ALLOC_FAILED);
           return lastRC();
           }
        }
        
    if (!szDriverAttributes)
        {
        szDriverAttributes = (LPSTR)new UCHAR[DRIVER_ATTRIBS_MAX];
        if (!szDriverAttributes)
           {
           SetRC(SQL_ALLOC_FAILED);
           return lastRC();
           }
        }
        
    return
        Drivers(
                SQL_FETCH_NEXT,
                (LPUSTR )szDriver,
                DRIVER_MAX,
                &cbDriver,
                (LPUSTR )szDriverAttributes,
                DRIVER_ATTRIBS_MAX,
                &cbDriverAttributes);
    }

#endif // if (ODBCVER >= 0x0200)
