/*----------------------------------------------------------------------------

    File: WDCAPI.H
    Word C-API header file

----------------------------------------------------------------------------*/

#ifndef WDCAPI
#define WDCAPI

typedef unsigned char  uchar;
typedef uchar far *LPUCHAR;
typedef unsigned short ushort;

typedef struct
{
    short cArrayDimensions;
    short ArrayDimensions[];
} ARRAY_DEF;

typedef struct
{
    union
        {
        short   Short;
        long    Long;
        double  Double;
        LPUCHAR String;
        struct
            {
            ARRAY_DEF far *  ArrayDef;
            union
                {
                double  far * DoubleArray;
                LPUCHAR far * StringArray;
                };
            };
        };

    ushort BufferSize;        /* number of bytes allocated for return values */

    ushort Type           :4; /* the type of this argument                   */
    ushort IsArray        :1; /* is the argument an array                    */
    ushort ForInput       :1; /* is the argument to be used as input         */
    ushort ForOutput      :1; /* is the argument to be used to store output  */
    ushort BufferTooSmall :1; /* buffer too small to write data              */
    ushort                :8;

    ushort FieldId;           /* identifier for named fields                 */

} WDOPR, far * LPWDOPR;

short WINAPI wdCommandDispatch(short CommandID, short DlgOptions, short cArgs,
                                    LPWDOPR lpwdoprArgs, LPWDOPR lpwdoprReturn);

#define elkNil          0
#define lpwdoprNil    ((LPWDOPR)(0))
#define MaxArgs         34 // MaxArgs based on largest dialog

typedef struct
{
    short cArgs;
    WDOPR  wdoprReturn;
    WDOPR  wdoprArgs[MaxArgs];
} WCB;

/* WDOPR Type constants */  
#define TypeVoid           0x0000
#define TypeShort          0x0001
#define TypeLong           0x0002
#define TypeDouble         0x0003
#define TypeString         0x0004

/* DlgOption constants */
#define CommandDefaults    0x0000
#define CommandDialog      0x0001
#define CommandAction      0x0002

#endif
// WDCAPI
