/*************************************************************************
*
*	wdobdc.c	    6/10/93
*
*	This file is about main routine for WinWord ODBC
*
*       8/23/95 - moved error messages into code (out of resource strings)
*
*************************************************************************/

#include "wbodbc.h"
#include "wdcmds.h"
#include "wdfid.h"

HANDLE		hInst;
DLLLIST		*dll_list;
HENV		henv;
SQLERROR	*pFirstError;
SWORD		firstErrorFlag;
UCHAR		szResource[256];
SWORD		matchType[TOTALTYPE] = 
{
	SQL_BIGINT,SQL_BINARY,SQL_BIT,
    SQL_CHAR,SQL_DATE,SQL_DECIMAL,SQL_DOUBLE,SQL_FLOAT,SQL_INTEGER,
    SQL_LONGVARBINARY,SQL_LONGVARCHAR,SQL_NUMERIC,SQL_REAL,SQL_SMALLINT,
    SQL_TIME,SQL_TIMESTAMP,SQL_TINYINT,SQL_VARBINARY,SQL_VARCHAR
};

UCHAR		wordTitle[256] = kWordTitle;
UCHAR		*errMsgs[] = {kOutOfMemory};


/******************************************************************
*
*	LibMain -- entrice of dll
*
*******************************************************************/
SWORD WINAPI _loadds LibMain(HANDLE h, SWORD w, SWORD c, LPSTR l)
{

    if (c != 0)
#ifndef WIN32
	UnlockData(0);
#endif
    hInst = h;
    pFirstError = NULL;
    dll_list = NULL;
    henv = NULL;
    return 1;
}/* LibMain() */

/******************************************************************
*
*	WEP -- DLL needs
*
*******************************************************************/
SWORD WINAPI _loadds WEP (SWORD b)
{
	return 1;
} /* WEP() */

/*
* wdAutoOpen -- called when user load this WLL to WinWord
*/
short WINAPI _loadds wdAutoOpen(short docID)
{
	return 1;
}

/*
* wdAutoOpen -- called when user load this WLL to WinWord
*/
void WINAPI _loadds wdAutoRemove()
{
    wdFreeAll();
}

void wdFreeAll()
{
	HINSTANCE hCurrInst;
	ODBCHNDL  *hODBC, *hTemp;
	DLLLIST   *pCurrItem, *pPrevItem;
	
	hCurrInst = wdGetCurrInst();
	pCurrItem = dll_list;
	pPrevItem = NULL;
	
	while(pCurrItem)
		{
		if(pCurrItem->hInst==hCurrInst)
			break;
		pPrevItem = pCurrItem;
		pCurrItem = pCurrItem -> next;
		}
		
	if(pCurrItem == NULL)
		return;
		
	if(pPrevItem)
		pPrevItem->next = pCurrItem -> next;
	else
		dll_list = pCurrItem -> next;
		
	hODBC = pCurrItem -> hODBC;
	while(hODBC)
		{
		hTemp = hODBC->next;
		if(hODBC->hstmt)
			SQLFreeStmt(hODBC->hstmt, SQL_DROP);
		wdFreeSyn(hODBC);
		SQLDisconnect(hODBC->hdbc);
		SQLFreeConnect(hODBC->hdbc);
		if(hODBC->lpDBList)
			wdFreeDBList(hODBC->lpDBList);
		free((PTR)hODBC);
		hODBC = hTemp;
		}
	
	wdFreeError(pCurrItem->sqlerror);
	free((PTR)pCurrItem);
	
	if(dll_list == NULL)
		SQLFreeEnv(henv);
	
	return;
}

HINSTANCE   wdGetCurrInst()
{
    WCB wcb;

    InitWcbFields(&wcb, TypeLong);
    wdCommandDispatch(wdGetInst, 0, wcb.cArgs, wcb.wdoprArgs, &(wcb.wdoprReturn));
#ifdef WIN32
    return (HINSTANCE) (wcb.wdoprReturn.Long);
#endif
#ifndef WIN32
    return(wcb.wdoprReturn.Short);
#endif
}

/*************************************************************************
*
*	sql_synchronize -- the entrance of SQLSynchronize function
*
*************************************************************************/
SWORD WINAPI _loadds SQLSynchronize(SWORD flag)
{
	ODBCHNDL *htemp;
	DLLLIST	 *dlllist_temp;
	
	dlllist_temp = wdGetVBlock(FALSE);
	if (dlllist_temp == NULL)
		{
		if(henv)
			return(SQL_OutOfMemory);
		else
			return(0);
		}
	
	if(flag)
		{
		if(dlllist_temp->synFlag==0)
			return(1);
		for(htemp=dlllist_temp->hODBC; htemp; htemp=htemp->next)
			{
			if(htemp->synchronize_flag)
				return(SQL_SynchronizeError);
			}
		}
	else
		dlllist_temp->synFlag = 1;
		
	return(1);
}

