#include <string.h>
#include "wbodbc.h"

static char buffer[256];

void InitWcbFields(WCB far *lpwcb, short retType)
{
	lpwcb->cArgs = 0;
	lpwcb->wdoprReturn.Type = retType;
	if (retType == TypeString)
		{
		lpwcb->wdoprReturn.String = buffer;
		lpwcb->wdoprReturn.BufferSize = 256;
		}
}

void AddShortField(lpwcb, ShortVal, FieldId)
WCB far *lpwcb;
short ShortVal;
short FieldId;
{
	short cArgs;

	cArgs = lpwcb->cArgs;
	lpwcb->wdoprArgs[cArgs].Short	 = ShortVal;
	lpwcb->wdoprArgs[cArgs].Type	  = TypeShort;
	lpwcb->wdoprArgs[cArgs].ForInput  = 1;
	lpwcb->wdoprArgs[cArgs].ForOutput = 0;
	lpwcb->wdoprArgs[cArgs].FieldId	 = FieldId;
	lpwcb->wdoprArgs[cArgs].BufferSize = 0;
	lpwcb->cArgs++;
}

void AddStringField (lpwcb, lpStr, FieldId)
WCB far *lpwcb;
LPSTR lpStr;
short FieldId;
{
	short cArgs;

	cArgs = lpwcb->cArgs;
	lpwcb->wdoprArgs[cArgs].String	 = lpStr;
	lpwcb->wdoprArgs[cArgs].Type	 = TypeString;
	lpwcb->wdoprArgs[cArgs].ForInput  = 1;
	lpwcb->wdoprArgs[cArgs].ForOutput = 0;
	lpwcb->wdoprArgs[cArgs].FieldId	 = FieldId;
	lpwcb->wdoprArgs[cArgs].BufferSize = lstrlen(lpStr);
	lpwcb->cArgs++;
}

#ifdef WIN32
static unsigned short (*pfn_wdCommandDispatch) ();
short WINAPI wdCommandDispatch(short CommandID, // fci
						short DlgOptions, // grfDlg
						short cArgs,
						LPWDOPR lpwdoprArgs,
						LPWDOPR lpwdoprReturn)
{
	if (pfn_wdCommandDispatch == NULL)
		(FARPROC) pfn_wdCommandDispatch = GetProcAddress(GetModuleHandle(NULL), "wdCommandDispatch");
	return ((*pfn_wdCommandDispatch)(CommandID, DlgOptions, cArgs, lpwdoprArgs, lpwdoprReturn));
}

#endif
