/*************************************************************************
*
*	rountine.c		6/10/93
*
*	This file is about all subroutines for WinWord ODBC
*
*       8/23/95 - added GetColSize for use by SQLExecQuery
*
*************************************************************************/

#include	"wbodbc.h"

/*********************************************************
*
*	wdGetVBlock() - to get a point of the variable block
*
**********************************************************/
DLLLIST * wdGetVBlock(BOOL cleanError)
{
	DLLLIST		*dlllist_temp;
	HINSTANCE	hCurrInst;
	
	hCurrInst = wdGetCurrInst();
	if (dll_list == NULL) 
		{
		if (SQLAllocEnv(&henv) != SQL_SUCCESS) 
			{
			wdSQLError(NULL, NULL, NULL);
			return(NULL);
			}
		
		if (henv == NULL) 
			return(NULL);
		
		dll_list = (DLLLIST *) malloc(sizeof(DLLLIST));
		if (dll_list == NULL) 
			{
			wdMessageBox(OUTOFMEMORY);
			return(NULL);
			}
			
		dll_list->hODBC = NULL;
		dll_list->hInst = hCurrInst;
		dll_list->synFlag = 0;
		dll_list->error_flag = 0;
		dll_list->sqlerror = NULL;
		dll_list->next = NULL;
		return(dll_list);
		} 
	else 
		{
		dlllist_temp = dll_list;
		while (dlllist_temp) 
			{
			if (dlllist_temp->hInst == hCurrInst) 
				{
				if(cleanError)
					{
					dlllist_temp->error_flag = 0;
					wdFreeError(dlllist_temp->sqlerror);
					dlllist_temp->sqlerror = NULL;
					}
				return(dlllist_temp);
				}
			dlllist_temp = dlllist_temp ->next;
			}
			
		dlllist_temp = dll_list;
		while(dlllist_temp->next) 
			dlllist_temp = dlllist_temp->next;
			
		dlllist_temp->next = (DLLLIST *) malloc(sizeof(DLLLIST));
		if (dlllist_temp->next == NULL) 
			{
			wdMessageBox(OUTOFMEMORY);
			return(NULL);
			}
			
		dlllist_temp->next->hODBC = NULL;
		dlllist_temp->next->hInst = hCurrInst;
		dlllist_temp->next->synFlag = 0;
		dlllist_temp->next->error_flag = 0;
		dlllist_temp->next->sqlerror = NULL;
		dlllist_temp->next->next = NULL;
		return(dlllist_temp->next);
		}
}

void wdMessageBox(SWORD error_id)
{
    /* may change to call WORD API */
    _fstrcpy(szResource+200, wdGetResString(WORDTITLE));
    MessageBox(NULL, wdGetResString(error_id), (LPSTR)(szResource+200), MB_OK|MB_ICONEXCLAMATION);
}

LPSTR	wdGetResString(SWORD string_id)
{
    szResource[0] = 0;
    LoadString(hInst, string_id, (LPSTR)szResource, 256);
    return((LPSTR)szResource);
}

/*************************************************************************
*
*	wdCheckConnect -- to check the connection number is vaild
*
*************************************************************************/
ODBCHNDL * wdCheckConnect(ODBCHNDL * hODBC,SWORD connection_num)
{
	ODBCHNDL *htemp;
	
	htemp = hODBC;
	while (htemp) 
		{
		if (htemp->connect_id == connection_num) 
			return(htemp);
		htemp = htemp->next;
		}
	return(NULL);
}

/* Peek message and let user abort the query */
/* return 1 means abort, 0 means nothing */
SWORD wdPeekMessage()
{
    return(0);
}

/* return a empty string */
LPSTR wdNullString()
{
    *szResource = 0;
    return((LPSTR)szResource);
}



/*************************************************************************
*
*       GetColSize -- returns the size of the data in column icol of the
*						current result set. The size is the number of bytes
*						transfered on a SQLGetData or SQLFetch if
*						SET_C_CHAR is specified.
*
*					  returns 0 if the size cannot be determined
*
*************************************************************************/
SDWORD GetColSize(ODBCHNDL	*hConnect,UWORD icol)
{
	RETCODE retcode;
	SDWORD colLength;  // size of column when converted to default C data type


	if (hConnect==NULL)
		return (0);

	while((retcode = SQLColAttributes(hConnect->hstmt,icol,SQL_COLUMN_DISPLAY_SIZE,
				NULL,0,NULL,&colLength))==SQL_STILL_EXECUTING)
		NULL;

	if (retcode!=SQL_SUCCESS) {
		wdSQLError(henv,hConnect->hdbc,hConnect->hstmt);
		return(0); 
	}

	return (colLength);
} /* GetColSize() */


int SupportsScrollableCursors(ODBCHNDL *hConnect)
/* returns 1 if the ODBC driver supports scrollable cursors,
	returns 0 if the driver does not */
{
	RETCODE retcode;
	UWORD	exists=0;

	retcode = SQLGetFunctions(hConnect->hdbc,SQL_API_SQLSETPOS,&exists);
	if (retcode != SQL_SUCCESS)
		return (0);

	if (!exists)
		return (0);
	else {
		retcode = SQLGetFunctions(hConnect->hdbc,SQL_API_SQLEXTENDEDFETCH,&exists);
		if (retcode != SQL_SUCCESS)
			return (0);

		return (exists);
	}
} /* SupportsScrollableCursors() */
