/* The contents of mapinit.c and mapinit.h are modified versions of
 * the same files found in the MAPIAPP sample code.
 */

#define SZ_MAPILOGON "MAPILogon"
#define SZ_MAPILOGOFF "MAPILogoff"
#define SZ_MAPISENDMAIL "MAPISendMail"
#define SZ_MAPISENDDOC "MAPISendDocuments"
#define SZ_MAPIFINDNEXT "MAPIFindNext"
#define SZ_MAPIREADMAIL "MAPIReadMail"
#define SZ_MAPISAVEMAIL "MAPISaveMail"
#define SZ_MAPIDELMAIL "MAPIDeleteMail"
#define SZ_MAPIFREEBUFFER "MAPIFreeBuffer"
#define SZ_MAPIADDRESS "MAPIAddress"
#define SZ_MAPIDETAILS "MAPIDetails"
#define SZ_MAPIRESOLVENAME "MAPIResolveName"
#define MAPIDLL "MAPI32.DLL"

#define ERR_LOAD_LIB  0x02
#define ERR_LOAD_FUNC 0x04

typedef ULONG (WINAPI *PFNMAPILOGON)(HWND, LPSTR, LPSTR, FLAGS, ULONG, LPLHANDLE);

typedef ULONG (WINAPI *PFNMAPILOGOFF)(LHANDLE, HWND, FLAGS,ULONG);

typedef ULONG (WINAPI *PFNMAPISENDMAIL)(LHANDLE, HWND, lpMapiMessage, FLAGS,
                                     ULONG);

typedef ULONG (WINAPI *PFNMAPISENDDOCUMENTS)(HWND, LPSTR, LPSTR, LPSTR, ULONG);

typedef ULONG (WINAPI *PFNMAPIFINDNEXT)(LHANDLE, HWND, LPSTR, LPSTR, FLAGS,
                                     ULONG, LPSTR);

typedef ULONG (WINAPI *PFNMAPIREADMAIL)(LHANDLE, HWND, LPSTR, FLAGS, ULONG,
                                     lpMapiMessage FAR *);

typedef ULONG (WINAPI *PFNMAPISAVEMAIL)(LHANDLE, HWND, lpMapiMessage, FLAGS,
                                     ULONG, LPSTR);

typedef ULONG (WINAPI *PFNMAPIDELETEMAIL)(LHANDLE, HWND, LPSTR, FLAGS, ULONG);

typedef ULONG (WINAPI *PFNMAPIFREEBUFFER)(LPVOID);

typedef ULONG (WINAPI *PFNMAPIADDRESS)(LHANDLE, HWND, LPSTR, ULONG, LPSTR,
					                ULONG, lpMapiRecipDesc, FLAGS, ULONG,
                                    LPULONG, lpMapiRecipDesc FAR *);

typedef ULONG (WINAPI *PFNMAPIDETAILS)(LHANDLE, HWND,lpMapiRecipDesc, FLAGS,
                                    ULONG);

typedef ULONG (WINAPI *PFNMAPIRESOLVENAME)(LHANDLE, HWND, LPSTR, FLAGS,
						                ULONG, lpMapiRecipDesc FAR *);

extern HANDLE hLibrary;

extern PFNMAPILOGON sysLogon;
extern PFNMAPILOGOFF sysLogoff;
extern PFNMAPISENDMAIL sysSendMail;
extern PFNMAPISENDDOCUMENTS sysSendDocuments;
extern PFNMAPIFINDNEXT sysFindNext;
extern PFNMAPIREADMAIL sysReadMail;
extern PFNMAPISAVEMAIL sysSaveMail;
extern PFNMAPIDELETEMAIL sysDeleteMail;
extern PFNMAPIFREEBUFFER sysFreeBuffer;
extern PFNMAPIADDRESS sysAddress;
extern PFNMAPIDETAILS sysDetails;
extern PFNMAPIRESOLVENAME sysResolveName;

short WINAPI InitMAPI(void);
short WINAPI DeInitMAPI(void);
