/* The contents of mapinit.c and mapinit.h are modified versions of
 * the same files found in the MAPIAPP sample code.
 */

#include <windows.h>
#include "mapi.h"
#include "mapinit.h"

short WINAPI InitMAPI()
{

  if ((hLibrary = LoadLibrary(MAPIDLL)) < (HANDLE)32)
    return(ERR_LOAD_LIB);

  if ((sysLogon = (PFNMAPILOGON)GetProcAddress(hLibrary,SZ_MAPILOGON)) == NULL)
    return(ERR_LOAD_FUNC);

  if ((sysLogoff= (PFNMAPILOGOFF)GetProcAddress(hLibrary,SZ_MAPILOGOFF)) == NULL)
    return(ERR_LOAD_FUNC);

  if ((sysSendMail= (PFNMAPISENDMAIL)GetProcAddress(hLibrary,SZ_MAPISENDMAIL)) == NULL)
    return(ERR_LOAD_FUNC);

  if ((sysSendDocuments= (PFNMAPISENDDOCUMENTS)GetProcAddress(hLibrary,SZ_MAPISENDDOC)) == NULL)
    return(ERR_LOAD_FUNC);

  if ((sysFindNext= (PFNMAPIFINDNEXT)GetProcAddress(hLibrary,SZ_MAPIFINDNEXT)) == NULL)
    return(ERR_LOAD_FUNC);

  if ((sysReadMail= (PFNMAPIREADMAIL)GetProcAddress(hLibrary,SZ_MAPIREADMAIL)) == NULL)
    return(ERR_LOAD_FUNC);

  if ((sysSaveMail= (PFNMAPISAVEMAIL)GetProcAddress(hLibrary,SZ_MAPISAVEMAIL)) == NULL)
    return(ERR_LOAD_FUNC);

  if ((sysDeleteMail= (PFNMAPIDELETEMAIL)GetProcAddress(hLibrary,SZ_MAPIDELMAIL)) == NULL)
    return(ERR_LOAD_FUNC);

  if ((sysFreeBuffer= (PFNMAPIFREEBUFFER)GetProcAddress(hLibrary,SZ_MAPIFREEBUFFER)) == NULL)
    return(ERR_LOAD_FUNC);

  if ((sysAddress= (PFNMAPIADDRESS)GetProcAddress(hLibrary,SZ_MAPIADDRESS)) == NULL)
    return(ERR_LOAD_FUNC);

  if ((sysDetails= (PFNMAPIDETAILS)GetProcAddress(hLibrary,SZ_MAPIDETAILS)) == NULL)
    return(ERR_LOAD_FUNC);

  if ((sysResolveName= (PFNMAPIRESOLVENAME)GetProcAddress(hLibrary,SZ_MAPIRESOLVENAME)) == NULL)
    return(ERR_LOAD_FUNC);

  return(0);
}


short WINAPI DeInitMAPI()
{

  sysLogon = NULL;
  sysLogoff= NULL;
  sysSendMail= NULL;
  sysSendDocuments= NULL;
  sysFindNext= NULL;
  sysReadMail= NULL;
  sysSaveMail= NULL;
  sysDeleteMail= NULL;
  sysFreeBuffer = NULL;
  sysAddress= NULL;
  sysDetails = NULL;
  sysResolveName;

  FreeLibrary(hLibrary);

  return(0);
}
