/*************************************************************************
*
*       error.c         6/10/93
*
*       This file is about SQLError for WinWord ODBC
*
*************************************************************************/

#include "wbodbc.h"

/*************************************************************************
*
*       sql_error -- the entrance of SQLError function
*
*************************************************************************/
SWORD WINAPI _loadds SQLGetError()
{
	DLLLIST	*dlllist_temp;
	
	dlllist_temp = wdGetVBlock(FALSE);
	if (dlllist_temp == NULL)
		{
		if(henv)
			return(SQL_OutOfMemory);
		else
			return(0);
		}
	return(dlllist_temp->error_flag);
}

/*************************************************************************
*
*       sql_error_flush -- the entrance of SQLErrorFlush function
*
*************************************************************************/
SWORD WINAPI _loadds SQLErrorFlush()
{
	DLLLIST	*dlllist_temp;
	
	dlllist_temp = wdGetVBlock(TRUE);
	if (dlllist_temp == NULL)
		{
		if(henv)
			return(SQL_OutOfMemory);
		else
			return(0);
		}
	return(1);
}

/*************************************************************************
*
*       sql_error_text -- the entrance of SQLErrorText function
*
*************************************************************************/
LPSTR WINAPI _loadds SQLErrorText$(SWORD error_num)
{
	DLLLIST		*dlllist_temp;
	SQLERROR	*lperr;
		
	if(error_num<=0)
		return(wdNullString());
		
	dlllist_temp = wdGetVBlock(FALSE);
	if (dlllist_temp == NULL) 
		return(wdNullString());
		
	lperr = dlllist_temp->sqlerror;
	while(--error_num)
		{
		if(lperr)
			lperr = lperr->next;
		else
			break;
		}
		
	if(lperr&&lperr->error_msg)
		return(lperr->error_msg);
	return(wdNullString());
}

/*************************************************************************
*
*       sql_error_class -- the entrance of SQLErrorClass function
*
*************************************************************************/
LPSTR WINAPI _loadds SQLErrorClass$(SWORD error_num)
{
	DLLLIST		*dlllist_temp;
	SQLERROR	*lperr;
	
	if(error_num<=0)
		return(wdNullString());
		
	dlllist_temp = wdGetVBlock(FALSE);
	if (dlllist_temp == NULL) 
		return(wdNullString());
		
	lperr = dlllist_temp->sqlerror;
	while(--error_num)
		{
		if(lperr)
			lperr = lperr->next;
		else
			break;
		}
		
	if(lperr&&lperr->sql_state)
		return((LPSTR)lperr->sql_state);
	return(wdNullString());
}

/*************************************************************************
*
*       sql_error_code -- the entrance of SQLErrorCode function
*
*************************************************************************/
SDWORD WINAPI _loadds SQLErrorCode(SWORD error_num)
{
	DLLLIST		*dlllist_temp;
	SQLERROR	*lperr;
	
	if(error_num<=0)
		return(0);
		
	dlllist_temp = wdGetVBlock(FALSE);
	if (dlllist_temp == NULL) 
		return(0);
		
	lperr = dlllist_temp->sqlerror;
	while(--error_num)
		{
		if(lperr)
			lperr = lperr->next;
		else
			break;
		}
		
	if(lperr)
		return(lperr->N_code);
	return(0);
}

/*********************************************************
*
*       wdFreeError() - to free the error chain
*
**********************************************************/
void wdFreeError(SQLERROR *lperror)
{
    SQLERROR	*lperrnext;

    while (lperror) 
    	{
		lperrnext = lperror->next;
		free((PTR) lperror);
		lperror = lperrnext;
	    }
}

/*********************************************************
*
*       wdSQLError() - to define the Sql_error_info on the Macro sheet
*
**********************************************************/
void wdSQLError(HENV henv, HDBC hdbc, HSTMT hstmt)
{
	DLLLIST		*dlllist_temp;
	SWORD		length, count;
	RETCODE		retcode;
	SQLERROR	*lperr,*lptail;
	
	if(dll_list == NULL)
		dlllist_temp = NULL;
	else
		dlllist_temp = wdGetVBlock(FALSE);
		
	count = 0;
	lptail = NULL;
	
	while(TRUE)
		{
		lperr = (SQLERROR *) malloc(sizeof(SQLERROR));
		if(lperr)
			lperr->next = NULL;
		else
			{
			wdMessageBox(OUTOFMEMORY);
			break;
			}
			
		retcode = SQLError((henv)?henv:SQL_NULL_HENV,
					(hdbc)?hdbc:SQL_NULL_HDBC,
					(hstmt)?hstmt:SQL_NULL_HSTMT,
					lperr->sql_state,
					&(lperr->N_code),
					lperr->error_msg,
					256, &length);
					
		if (retcode == SQL_SUCCESS || retcode == SQL_SUCCESS_WITH_INFO) 
			{
			if (lptail == NULL) 
				{
				if(dlllist_temp)
					{
					wdFreeError(dlllist_temp->sqlerror);
					dlllist_temp->sqlerror = lperr;
					}
				else
					{
					wdFreeError(pFirstError);
					pFirstError = lperr;
					}
				}
			else
				lptail->next = lperr;
				
			lptail = lperr;
			count++;
			}
		else
			{
			free(lperr);
			break;
			}
		}
	
	if(dlllist_temp)
		dlllist_temp->error_flag = (UCHAR) count;
	else
		firstErrorFlag = (UCHAR) count;
}
