/*----------------------------------------------------------------------------

	File: CONFIG.H
	Environment configuration header file
 
	The only configuration parameters 
	that are needed are _WIN32 and _WIN16
 
	This file assumes that the 'C' compiler
	defines _WIN32 on 32 bit platforms.
	If this assumption is not valid,
	then _WIN32 will have to be defined by hand.
 
----------------------------------------------------------------------------*/

#if defined(_WIN32) || defined(WIN32)

	#ifndef _WIN32
		#define _WIN32
	#endif

	#ifndef WIN32
		#define WIN32
	#endif

	#ifndef _loadds
		#define _loadds
	#endif

	#ifndef _fmemset
		#define _fmemset memset
	#endif

	#ifndef _fstrcat
		#define _fstrcat strcat
	#endif

	#ifndef _fstrlen
		#define _fstrlen strlen
	#endif

	#ifndef _fstrcpy
		#define _fstrcpy strcpy
	#endif

	#ifndef _fstrchr
		#define _fstrchr strchr
	#endif

	#ifndef _fstricmp
		#define _fstricmp _stricmp
	#endif

	#ifndef _fstrnicmp
		#define _fstrnicmp _strnicmp
	#endif

	#ifndef _fstrncmp
		#define _fstrncmp strncmp
	#endif

	#ifndef _fstrstr
		#define _fstrstr strstr
	#endif

	#ifndef _fstrncmp
		#define _fstrncmp strncmp
	#endif

	#ifndef _fmalloc
		#define _fmalloc malloc
	#endif

	#ifndef _ffree
		#define _ffree free
	#endif

	#ifndef HWND32SPECIFIC
		#define HWND32SPECIFIC (HWND)
	#endif

#else
	
	#ifndef _WIN16
		#define _WIN16
	#endif

	#ifndef WIN16
		#define WIN16
	#endif

	#ifndef HWND32SPECIFIC
		#define HWND32SPECIFIC
	#endif

#endif

