/*-----------------------------------------------------------------------

    File: CAPILIB.H
    Header file for CAPILIB.C

------------------------------------------------------------------------*/
#include "wdcapi.h" 

// Input and ouput constans for dialog commands
#define INPUT   1
#define OUTPUT  2
#define IN_OUT  3

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

/**** Word Command Buffer Manipulation Routines ****/
// Initialization
void InitWCB( WCB far *lpwcb,       // far pointer to the wcb
              ushort  retType,      // return type of the command 
              LPUCHAR lpBuffer,     // pointer to the return string (if any) 
              ushort  cBufferSize );// size of return buffer


// Dialog command arguments
void AddShortDlgField( WCB far  *lpwcb,     // far pointer to wcb
                       short    ShortVal,   // value of short field
                       ushort   FieldId,    // dialog field ID
                       ushort   fMode );    // for input, output or both

void AddLongDlgField( WCB far *lpwcb,  // far pointer to wcb
                      long    LongVal, // value of long field
                      ushort  FieldId, // dialog field ID
                      ushort  fMode ); // for input, output or both

void AddDoubleDlgField( WCB far *lpwcb,    // far pointer to wcb
                        double  DoubleVal, // value of double field
                        ushort  FieldId,   // dialog field ID
                        ushort  fMode );   // for input, output or both

void AddStringDlgField( WCB far *lpwcb,       // far pointer to Word Command Buffer
                        LPUCHAR lpStr,        // Pointer to the string to be passed
                        ushort  FieldId,      // Dialog Field ID
                        ushort  fMode,        // For input, output or both
                        ushort  cBufferSize );// Size of buffer pointed by lpStr


// Function and statement arguments
void AddShortParam( WCB far *lpwcb,    // Pointer to Word Command Buffer
                    short   ShortVal );// short parameter

void AddLongParam( WCB far *lpwcb,    // Pointer to Word Command Buffer
                   long    LongVal ); // long parameter

void AddDoubleParam( WCB far *lpwcb,      // Pointer to Word Command Buffer
                     double   DoubleVal );// double parameter

void AddStringParam( WCB far *lpwcb,  // Pointer to Word Command Buffer
                     LPUCHAR lpStr ); // string parameter

short CallCapi( WCB far *lpwcb,			// pointer to word command buffer
				short	uCmd,			// command to be called
              	ushort  retType,      	// return type of the command 
              	LPSTR	lpBuffer,		// Buffer to return return string (if any)
              	ushort	cBufferSize,	// Size of buffer pointed by lpBuffer
              	LPSTR	lpszFormat,		// Format string with argument prototype
				... );					// argument list

		
// Arrays
ARRAY_DEF far * SetArrayDef( HANDLE far *phArrDef, // Pointer to handle to memory 
                             short cDimensions,    // Number of dimensions in the array
                             ... );                // size of each dimension

void AddStringArray( WCB       far *lpwcb,        // pointer to word command buffer
                     ARRAY_DEF far *ArrayDef,     // pointer to the array definition
                     LPUCHAR   far *lpStrArray,   // pointer to array of strings
                     ushort        cBufferSize ); // size string buffer

void AddDoubleArray( WCB       far *lpwcb,        // pointer to word command buffer
                     ARRAY_DEF far *ArrayDef,     // pointer to array definition
                     double    far *lpdblArray ); // Pointer to the array


/**** Word Customization Routines ****/
short CAPIRegister( short   DocID,             // Document ID
                    LPUCHAR lpszFunctionName,  // function to be registered 
                    LPUCHAR lpszDescription ); // Description for the function

short CAPIAddToolbar( short   nContext,      // Context (0, 1, or DocID)
                      LPUCHAR lpszToolbar ); // Name of new toolbar

short CAPIAddButton( short   nContext,    // Context (0, 1, or DocID)
                     LPUCHAR lpszToolbar, // Name of the toolbar
                     short   cPosition,   // Position to insert button
                     LPUCHAR lpszMacro,   // Command to assotiate with button
                     LPUCHAR lpszFace );  // face of the button (text only)

short CAPIAddMenu( short   nContext,      // Context (0, 1, or DocID)
                   LPUCHAR lpszMenuName, // name of the menu
                   short   Position,     // position of the new menu
                   short   MenuType );   // type of menu

short CAPIAddMenuItem( short   nContext,     // Context (0, 1, or DocID)
                       LPUCHAR lpszMenu,     // name of the menu
                       LPUCHAR lpszName,     // command to add
                       LPUCHAR lpszMenuText, // menu item text
                       short   Position,     // positon in the menu
                       short   MenuType );   // type of the menu

short CAPIAddKey( short   nContext,   // Context (0, 1, or DocID)
                  short   KeyCode,    // key combination to be set
                  LPUCHAR lpszName ); // command to assign to key

#ifdef __cplusplus
}
#endif // __cplusplus
