/* F-TIMER.CMD                                                              */
/*                                                                          */
/* This is a timer to schedule virus-search on a OS/2-system using F-PROT2  */
/* Written November 1993 by Oeyvind Pedersen, Capella Ans                   */
/* This CMD-file is made for the F-PROT Professional, and are not to        */
/* to be included in any other package whitout permission from the author   */
/* If you have any questions about this program, please direct              */
/* them to:                                                                 */
/*      Capella Ans                                                         */
/*      Att: Oeyvind Pedersen                                               */
/*      Dyrborgveien 23                                                     */
/*      7018 TRONDHEIM                                                      */
/*      NORWAY                                                              */
/*      Telephone: +47-73-517063                                            */
/*      Fax:       +47-73-513282                                            */
/*      Email: oep@fiero.winix.no                                           */
/*                                                                          */
/* Modified by Mikko Hypponen, Data Fellows Ltd 10th-May-1994               */
/* Added support for /? & ? parameters, changed default paths to C:\F-PROT2 */


'@echo off'
/* debug statement */
/* trace all */

/* load functions to be used from RexxUtil */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* Global and default values */
header    = 'F-PROT for OS/2 Timer'
interval = 24
timestamp.file = "C:\F-TIMER.TSF"

/* YOU NEED TO MODIFY THE PATH TO SUIT TO YOUR SYSTEM */
batch = "C:\F-PROT2\LOCAL.CMD"

/* deffpexe  = 'C:\F-PROT2\F-PROT2.EXE' */

/* make sure that program exits if anything goes wrong */
signal on failure name CLEANUP
signal on halt name CLEANUP
signal on syntax name CLEANUP   

/* Analyse command line parameteres given */
PARSE UPPER ARG CArg.1 CArg.2 CArg.3

do I = 1 to 3
	argtype = substr(CArg.I,1,3)
	/* is this the interval argument */
	If argtype = "/I:" then do
		tmplen = length(Carg.I) - 3
		tmpinterval = right(CArg.I,tmplen)
		if datatype(tmpinterval,'N') then
			interval = tmpinterval
		else do 
			say "Error! Option " CArg.I "is not a valid interval"
                        signal CMDHELP
			end
		end
	If argtype = "/B:" then do
		tmplen = length(Carg.I) - 3
		batch = right(CArg.I,tmplen)
		end
	If argtype = "/T:" then do
		tmplen = length(Carg.I) - 3
		timestamp.file = right(CArg.I,tmplen)
		end
        If argtype = "/?" then do
                signal CMDHELP
                end
        If argtype = "?" then do
                signal CMDHELP
                end
	/* end of loop */
	end

/* Check if batch-file does exist */

rc = SysFileTree(batch,fileinfo,F)
if fileinfo.0 = 0 then do 
	Say "Error! The file " batch", given as batch-job, does not exist."
        signal CMDHELP
	end

/* just giving away some info to the user */
say "F-TIMER: "
say "Interval  	=" interval " hours"
say "Runs    	=" batch 
say "Timestampfile 	=" timestamp.file
say "You can minimize this window if you want, don't close it" 

/* Find last date/time this routine was run, and write new timestamp */
/* get current date/time */

today = DATE(Days)
so_far = TIME(minutes)
/* read first line to check if file is there */
tmpline = linein(timestamp.file,1,1)
if tmpline ="" then do
	rc = lineout(timestamp.file, today,1) 
	if rc = 1 then signal TSF_ERROR
	rc = lineout(timestamp.file, so_far)
	if rc = 1 then signal TSF_ERROR
	Sleeptime = 0
	end
else do
	timestamp.day = tmpline
	timestamp.that_far = linein(timestamp.file)
	if timestamp.day > today then 
		days_gone = 366 - timestamp.day + today
	else
		days_gone = today - timestamp.day 
		if timestamp.that_far > so_far then 
		minutes_diff = 1440 - timestamp.that_far + so_far
	else
		minutes_diff = so_far - timestamp.that_far
	minutes_gone = (days_gone * 1440) + minutes_diff
	minutes_left = interval * 60 - minutes_gone
	if minutes_left <  1 then 
		Sleeptime = 0 
	else 
		Sleeptime = minutes_left * 60 
	end     
if Sleeptime > 0 then do 
        parse var Sleeptime seconds "." tmpline
 	If seconds < 3600 then 
                Say "F-TIMER will now sleep for "(seconds/60)" minutes"
	else do
		hours_w = seconds % 3600
		minutes_w = (seconds - (hours_w *3600)) /60
 		Say "F-TIMER will now sleep for:" hours_w "hours and" minutes_w "minutes"
		end
	Call SysSleep(seconds)
	end
/* forever loop */

do forever 
	Sleeptime = interval * 3600
	today = DATE(Days)
	so_far = TIME(minutes)
	rc = lineout(timestamp.file, today,1) 
	if rc = 1 then signal TSF_ERROR
	rc = lineout(timestamp.file, so_far)
	if rc = 1 then signal TSF_ERROR

	/* Calls F-PROT to run a scan in a batch-file */

        "cmd /c"batch
	parse var Sleeptime seconds "." tmpline
	If seconds < 3600 then 
                Say "F-TIMER will now sleep for " (seconds/60) "minutes"
	else do
		hours_w = seconds % 3600
		minutes_w = (seconds - (hours_w *3600)) /60
                Say "F-TIMER will now sleep for:" hours_w "hours and" minutes_w "minutes"
		end
	call SysSleep(seconds)
	end
		
CMDHELP:
say "ͻ"
say "   F-TIMER.CMD (5/10-94)                                 "
say "   USAGE:                                                "
say "     F-TIMER [/B:<batch>] [/T:timestamp] [/I:interval]   "
say "                                                         "
say "   /B:   What batch-job to run                           "
say "   /I:   What interval to be used between each run, given"
say "         as hours. ie. '/I:0.5' is 30 minutes.           "
say "         Default value is 24 hours.                      "
say "   /T:   Alternate timestampfile                         "
say "         Default is C:\F-TIMER.TSF                       "
say "   Example:                                              "
say "     F-TIMER /I:1.5 /B:C:\OS2\CMDS\CHECK.CMD             "
say "     will run C:\OS2\CMDS\CHECK.CMD every 90. minutes    "
say "ͼ"

CLEANUP:
exit

* Error writing to the timestamp-file */
del c:\*.tsf
TSF_ERROR:
	Say "An error occured while trying to write the timestampfile:" timestamp.file
	exit
/* end of CMD file */
