// NP_WALK.C
//
// #includes and #defines
#include "np_walk.h"

#define WM_SNMPMSG WM_USER+1000
#define BLANK 32
#define IDW_EDIT 1   // edit window identifier
#define IDW_STATUS 2 // status window identifier

// Local and Extern Variables
HANDLE hInst;
HANDLE hMainWnd, hEditWnd, hStatusWnd;
LPSTR szAppName = "NP_WALK";
LPSTR szMIBVars = "MIB Variables";
LPSTR szIniFile = "NP_WSNMP.INI";
LPSTR comma=",";
HMENU hMenu;
HFILE hFile;
OPENFILENAME ofn;
char szFile[128] = "\0";
LPSTR szFilter = "NetPlus Log\0*.log\0";
LPCSTR szDefExt = "log";
GLOBALHANDLE ghEditDS;
LPSTR lpEdit;
LPSTR lpBuffer;
LPSTR lpString;
long nEndStr, nAtStr = 0;
RECT Rect;
WPARAM wFocus;
HSNMP_SESSION hSession;
HSNMP_PDU hPDU = 0;
HSNMP_VBL hVBL = 0;
smiOID dName;
smiVALUE sValue;
smiINT PduType, Err_stat, Err_index;
smiINT32 Request_id;
SNMPAPI_STATUS status;
HSNMP_ENTITY hDst, hSrc;
HSNMP_CONTEXT hContext;
smiVALUE pValue;
smiOID pName;           // Previous OID buffer
smiOID eName;           // Ending OID buffer
smiINT nCmp;            // OID comparison result
char gszOidInBuf[256];
char gszCommStr[256];
char gszNetAddrBuf[64];
char tmpBuf[256];
LPSTR communityValue = "public";
smiOCTETS communitylpString;
LRESULT nEntity = 0;
LRESULT nContext = 0;
LRESULT nOID1 = 0;
LRESULT nOID2 = 0;

// WinMain
int PASCAL WinMain (HANDLE hInstance,     // current instance
                    HANDLE hPrevInstance, // previous instance
                    LPSTR lpCmdLine,      // command line
                    int nCmdShow)         // show-window type (open/icon)
{
MSG  msg;
if (!hPrevInstance)
   if (!InitApplication(hInstance))
      return (FALSE);
if (!InitInstance(hInstance, nCmdShow))
   return (FALSE);
while (GetMessage (&msg, NULL, NULL, NULL))
   {
   TranslateMessage(&msg); // Translates virtual key codes
   DispatchMessage(&msg);  // Dispatches message to window
   }
return (msg.wParam);       // Returns the value from PostQuitMessage
} // WinMain

// InitApplication
BOOL InitApplication (HANDLE hInstance)
{
WNDCLASS  wc;
// ctl3d registration
Ctl3dRegister (hInstance);
Ctl3dAutoSubclass (hInstance);

wc.style = NULL;
wc.lpfnWndProc = MainWndProc;
wc.cbClsExtra = 0;
wc.cbWndExtra = 0;
wc.hInstance = hInstance;
wc.hbrBackground = (HBRUSH)(COLOR_BACKGROUND+1);
wc.hCursor = LoadCursor(NULL, IDC_ARROW);
wc.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_NP_WALK));
wc.lpszMenuName =  szAppName;
wc.lpszClassName = szAppName;
return (RegisterClass(&wc));
} // InitApplication

// InitInstance
BOOL InitInstance (HANDLE hInstance, int nCmdShow)
{
smiUINT32 nMajorV, nMinorV, nLevel, nTranslateMode, nReMode;
hInst = hInstance;
hMainWnd = CreateWindow (szAppName, szAppName, WS_OVERLAPPEDWINDOW,
                        CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
                        NULL, NULL, hInst, NULL);
if (!hMainWnd)
   return (FALSE);
hMenu = GetMenu (hMainWnd);
// Start WinSNMP
status = SnmpStartup (&nMajorV, &nMinorV, &nLevel, &nTranslateMode, &nReMode);
// Need better WinSNMP error processing in this small startup section
if (nTranslateMode != SNMPAPI_TRANSLATED)
   {
   if (!(status = SnmpSetTranslateMode(SNMPAPI_TRANSLATED)))
      MessageBox (GetFocus(), "SNMPAPI_FAILURE", "SnmpSetTranslateMode", MB_OK);
   }
if (!(hSession = SnmpOpen (hMainWnd, WM_SNMPMSG)))
   MessageBox (GetFocus(), "SNMPAPI_FAILURE", "SnmpOpen", MB_OK);
if (!(hSrc = SnmpStrToEntity (hSession,"MyApp")))
   MessageBox (GetFocus(), "SNMPAPI_FAILURE", "SnmpStrToEntity", MB_OK);     
ShowWindow(hMainWnd, nCmdShow);
UpdateWindow(hMainWnd);
return (TRUE);
} // InitInstance

// MainWndProc
long CALLBACK __export
   MainWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
switch (message)
   {
   case WM_CREATE:
   // Allocate space for the new DS.
   ghEditDS = GlobalAlloc(GMEM_SHARE|GMEM_MOVEABLE|GMEM_ZEROINIT, 65536L);
   if (ghEditDS == NULL)
      {
      MessageBox(hWnd, "Buffer failed!", "Edit buffer", MB_OK);
      ghEditDS = hInst;
      }
   else
      {
      // Initialize the new segment.
      lpEdit = GlobalLock(ghEditDS);
      LocalInit(HIWORD((LONG)lpEdit), 0, (WORD)(GlobalSize(ghEditDS) - 16));
      UnlockSegment(HIWORD((LONG)lpEdit));
      }
   // Create the edit control. Note that the allocated segment handle
   // is passed in the CreateWindow call as the hInstance parameter.
   GetClientRect(hWnd, (LPRECT) &Rect);
   hEditWnd = CreateWindow ("Edit", NULL,
                         WS_CHILD | WS_BORDER | WS_HSCROLL | WS_VSCROLL |
                         ES_MULTILINE | ES_READONLY,
                         0, 0,
                         (Rect.right-Rect.left), (Rect.bottom-Rect.top),
                         hWnd, IDW_EDIT, HIWORD((LONG)lpEdit), NULL);

   if (!hEditWnd)
      {
      MessageBox (GetFocus(), "FAILURE", "CreateWindow", MB_OK);
      return (NULL);
      }
   // Allow up to 64K in edit control
   SendMessage (hEditWnd, EM_LIMITTEXT, 0, 0L);
   if (!(lpBuffer = GlobalAllocPtr(GHND, 65536L)))
      {
      MessageBox (GetFocus(), "FAILURE", "GlobalAllocPtr", MB_OK);
      return (NULL);
      }
   hStatusWnd = CreateWindow ("Edit", NULL,
                         WS_CHILD | WS_BORDER,
                         0, 0, 180, 30,
                         hWnd, IDW_STATUS, hInst, NULL);
   break;

   case WM_SIZE:
   MoveWindow (hEditWnd, 0, 0, LOWORD(lParam), HIWORD(lParam), TRUE);
   break;
   
   case WM_COMMAND:
      switch (wParam)
      {
      case IDM_ABOUT:
      NPAbout (hWnd, szAppName);
      break;
      
      case IDM_HELP_CONTENTS:
      WinHelp(hWnd, "NP_WSNMP.HLP", HELP_CONTENTS, 0L);
      break;
      
      case IDM_FILE_EXIT:
      SendMessage (hWnd, WM_CLOSE, 0, 0L);
      break;
                      
      case IDM_OID:
      case IDM_PASSWD:
      case IDM_IP:
      wFocus = wParam;
      KillTimer (hMainWnd, IDT_CLOCK);
      SetWindowText (hEditWnd, "");
      ShowWindow (hEditWnd, SW_HIDE);
      SetWindowText (hStatusWnd, "");
      ShowWindow (hStatusWnd, SW_HIDE);
      DialogBox (hInst, "GETOID", hWnd, GetOid);
      break;
      
      case IDM_SAVEAS:
      // Set all structure members to zero
      memset(&ofn, 0, sizeof(OPENFILENAME));
      // Initialize the OPENFILENAME members
      szFile[0] = '\0';
      ofn.lStructSize = sizeof(OPENFILENAME);
      ofn.hwndOwner = hWnd;
      ofn.lpstrFilter = szFilter;
      ofn.lpstrFile= szFile;
      ofn.nMaxFile = sizeof(szFile);
      ofn.lpstrDefExt = szDefExt;
      ofn.Flags = OFN_SHOWHELP | OFN_OVERWRITEPROMPT;
      if (GetSaveFileName(&ofn))
         {
         hFile = _lcreat (szFile, 0);
         _lwrite (hFile, lpBuffer, (UINT)nAtStr);
         _lclose (hFile);
         // Perform file operations
         }
      else
      // ErrorHandler();
      break;
      
      case IDM_SNAPSHOT:
      if (lstrlen (lpBuffer))
         {
         SetWindowText (hEditWnd, lpBuffer);
         ShowWindow (hStatusWnd, SW_HIDE);
         ShowWindow (hEditWnd, SW_RESTORE);
         }
      else
         {
         MessageBeep (MB_OK);
         MessageBox (hWnd, "No data in buffer", "Snapshot Error", MB_OK);
         }
      break;

      default:
      break;
      }  // switch wParam
   break;

   case WM_SNMPMSG:
   KillTimer (hMainWnd, IDT_CLOCK);
   if (!(SnmpRecvMsg (hSession, NULL, NULL, NULL, &hPDU)))
      {
      wsprintf (tmpBuf, "SNMPAPI_FAILURE = %lu",
         SnmpGetLastError (hSession));
      MessageBox (GetFocus(), tmpBuf, "SnmpRecvMsg", MB_OK);
      return (NULL);
      }
   if (!(SnmpGetPduData
         (hPDU, &PduType, &Request_id, &Err_stat, &Err_index, &hVBL)))
      {
      wsprintf (tmpBuf, "SNMPAPI_FAILUE = %lu",
         SnmpGetLastError (hSession));
      MessageBox (GetFocus(), tmpBuf, "SnmpGetPduData", MB_OK);
      SnmpFreePdu (hPDU); hPDU = 0;
      return (NULL);
      }
      wsprintf (tmpBuf, "RequestID = %ld", Request_id);
      SetWindowText (hStatusWnd, tmpBuf);
   if (PduType != SNMP_PDU_RESPONSE)
      MessageBox (GetFocus(), "Not SNMP_PDU_RESPONSE", "SNMP_ERROR", MB_OK);
   if (Err_stat != SNMP_ERROR_NOERROR)
      {
      if (Err_stat != SNMP_ERROR_NOSUCHNAME)
         {
         wsprintf (tmpBuf, "Error of %ld in index %ld",
                   Err_stat, Err_index);
         MessageBox (GetFocus(), tmpBuf, "SNMP_ERROR", MB_OK);
         }
      else
         MessageBox (GetFocus(), "End of MIB View", "End of MIB Walk", MB_OK);
      goto endofwalk;
      }
   if (!(SnmpGetVb (hVBL, 1, &dName, &sValue)))
      {
      wsprintf (tmpBuf,"SNMPAPI_FAILURE = %lu", 
         SnmpGetLastError (0));
      MessageBox (GetFocus(), tmpBuf, "SnmpGetVb", MB_OK);
      goto endofwalk;
      }
   // Now we need to compare the received OID with the one
   // we sent...if it's equal or lower, terminate the process
   status = SnmpOidCompare (&dName, &pName, 0, &nCmp);
   if (nCmp <= 0)
      {
      MessageBox (GetFocus(), "Next OID <= Prev OID!", "SNMP or MIB Error", MB_OK);
      goto endofwalk;
      }
   // Now we need to compare the received OID with the ending
   // OID if one has been specified by the user...if it's equal
   // or greater, we've reached the end of the MIB, so terminate
   status = SnmpOidCompare (&dName, &eName, 0, &nCmp);
   if (nCmp > 0)
      {
      MessageBox (GetFocus(), "Next OID > End OID!", "End of MIB Walk", MB_OK);
      goto endofwalk;
      }
   goto walkmore;
// walk termination code
endofwalk:
      SnmpFreePdu (hPDU); hPDU = 0;
      SnmpFreeVbl (hVBL); hVBL = 0;
      SnmpFreeDescriptor (SNMP_SYNTAX_OID, (smiLPOPAQUE)&pName);
      PostMessage (hMainWnd, WM_COMMAND, IDM_SNAPSHOT, 0L);
      return (NULL);
// if there were no errors, keep on walking
walkmore:
   SnmpOidCopy (&dName, &pName);
   // End of compare oid section
   lpString = &lpBuffer[nAtStr];
   memset (lpString, BLANK, 256);
   status = SnmpOidToStr (&dName, 80, lpString);
   if (status)
      {
      lpString[status++] = '=';
      NPWSNMPValueToStr (&sValue, 255-status, &lpString[status]);
      }
   nEndStr = lstrlen(lpString);
   lpString[nEndStr++] = '\r';
   lpString[nEndStr++] = '\n';
   nAtStr += nEndStr;
   lpBuffer[nAtStr] = '\0';
   if (nAtStr <= 64000) // Room for one full buffer?
      {
      status = SNMP_PDU_GETNEXT;
      Request_id++;
      SnmpSetPduData (hPDU, &status, &Request_id, NULL, NULL, NULL);
      if (!(SnmpSendMsg (hSession, hSrc, hDst, hContext, hPDU)))
         { 
         wsprintf (tmpBuf, "SNMPAPI_FAILURE = %lu %u %u", 
            SnmpGetLastError (0), hSrc, hDst);
         MessageBox (GetFocus(), tmpBuf, "SnmpSendMsg (loop)", MB_OK);
         }
      // Set Timer
      SetTimer(hMainWnd, IDT_CLOCK, 5000, NULL);
      }
   else // Not enough buffer space left
      {
      wsprintf (tmpBuf, "nAtStr = %ld", nAtStr);
      MessageBox (GetFocus(), tmpBuf, "Out of memory", MB_OK);
      PostMessage (hMainWnd, WM_COMMAND, IDM_SNAPSHOT, 0L);
      }
   SnmpFreePdu(hPDU); hPDU = 0;
   SnmpFreeVbl(hVBL); hVBL = 0;
   SnmpFreeDescriptor (SNMP_SYNTAX_OID, (smiLPOPAQUE)&dName);
   SnmpFreeDescriptor (sValue.syntax, (smiLPOPAQUE)&sValue.value.string);
   break;
        
   case WM_TIMER:
   if (wParam == IDT_CLOCK)
      {
      KillTimer (hMainWnd, IDT_CLOCK);
      wsprintf (tmpBuf, "Request_id = %ld", Request_id);
      MessageBox (GetFocus(), tmpBuf, "Timer Expired", MB_OK);
      }
   break;
   
   case WM_SYSCOLORCHANGE:
   // Ctl3d needs to know
     Ctl3dColorChange();
   break;

   case WM_DESTROY:
   // WinSNMP Cleanup
   SnmpClose(hSession);
   SnmpCleanup();
   // Ctl3d cleanup
   Ctl3dUnregister (hInst);
   /* Windows cleanup */
   PostQuitMessage(0);
   break;

   default:
   return (DefWindowProc(hWnd, message, wParam, lParam));
   }  // switch message
return (NULL);
} // MainWndProc

// GetOid
BOOL __export CALLBACK
   GetOid (HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
int i;
switch (message)
   {
   case WM_INITDIALOG:
      {
      NPWSNMPINISECTION sOStruct;
      NPWSNMPINISECTION sCStruct;
      NPWSNMPINISECTION sEStruct;
      switch (wFocus)
         {
         case IDM_IP:
         SetFocus (GetDlgItem (hDlg, IDC_IP));
         break;
         
         case IDM_PASSWD:
         SetFocus (GetDlgItem (hDlg, IDC_PASSWD));
         break;
         
         case IDM_OID:
         SetFocus (GetDlgItem (hDlg, IDC_OID1));
         break;
         }
      /*Agent*/
      NPWSNMPGetIniSection ((LPCSTR)"Entities", &sEStruct);
      for (i=0; i<sEStruct.count; i++)
         SendDlgItemMessage (hDlg, IDC_IP, CB_ADDSTRING, 0, (LPARAM)(LPSTR)sEStruct.ptrs[i]);
      nEntity = SendDlgItemMessage(hDlg,IDC_IP,CB_SETCURSEL,(WPARAM)nEntity, 0);
      /*Community*/
      NPWSNMPGetIniSection ((LPCSTR)"Contexts", &sCStruct);
      for (i=0; i<sCStruct.count; i++)
         SendDlgItemMessage(hDlg, IDC_PASSWD, CB_ADDSTRING, 0, (LPARAM)(LPSTR)sCStruct.ptrs[i]);
      nContext = SendDlgItemMessage(hDlg,IDC_PASSWD,CB_SETCURSEL,(WPARAM)nContext, 0);
      /*OID*/
      NPWSNMPGetIniSection ((LPCSTR)szMIBVars, &sOStruct);
      for (i=0; i<sOStruct.count; i++)
         {
         SendDlgItemMessage(hDlg, IDC_OID1, CB_ADDSTRING, 0, (LPARAM)(LPSTR)sOStruct.ptrs[i]);
         SendDlgItemMessage(hDlg, IDC_OID2, CB_ADDSTRING, 0, (LPARAM)(LPSTR)sOStruct.ptrs[i]);
         }
      nOID1 = SendDlgItemMessage(hDlg,IDC_OID1,CB_SETCURSEL,(WPARAM)nOID1,0L);
      nOID2 = SendDlgItemMessage(hDlg,IDC_OID2,CB_SETCURSEL,(WPARAM)nOID2,0L);
      return (FALSE); // We've set the focus...tell Windows not to bother
      }
   break;
   
   case WM_COMMAND:
   switch (wParam)
      {
      case IDOK:
      nAtStr = 0; // Reset the text buffer
      SnmpFreeEntity (hDst); hDst = 0; // Clear previous one (if any)
      nEntity = SendDlgItemMessage (hDlg, IDC_IP, CB_GETCURSEL, 0, 0L);
      GetDlgItemText (hDlg, IDC_IP, gszNetAddrBuf, sizeof(gszNetAddrBuf));
      if (!(hDst = SnmpStrToEntity (hSession, gszNetAddrBuf)))
         {
         wsprintf (tmpBuf, "SNMPAPI_FAILURE = %lu",
            SnmpGetLastError (hSession));
         MessageBox (GetFocus(), tmpBuf, "SnmpStrToEntity", MB_OK);
         }
      SnmpFreeContext (hContext); hContext = 0; // Clear previous one (if any)
      nContext = SendDlgItemMessage (hDlg, IDC_PASSWD, CB_GETCURSEL, 0, 0L);
      communitylpString.len = (smiUINT32)
      GetDlgItemText (hDlg, IDC_PASSWD, gszCommStr, sizeof(gszCommStr));
      communitylpString.ptr = (smiLPBYTE)&gszCommStr;
      if (!(hContext = SnmpStrToContext (hSession, &communitylpString)))
         {
         wsprintf (tmpBuf, "SNMPAPI_FAILURE = %lu",
            SnmpGetLastError (hSession));
         MessageBox (GetFocus(), tmpBuf, "SnmpStrToContext", MB_OK);
         }
      // Initialize the starting OID
      nOID1 = SendDlgItemMessage (hDlg, IDC_OID1, CB_GETCURSEL, 0, 0L);
      GetDlgItemText (hDlg, IDC_OID1, gszOidInBuf, sizeof(gszOidInBuf));
      GetPrivateProfileString (szMIBVars, gszOidInBuf, "0.0",
                               tmpBuf, sizeof(tmpBuf), szIniFile);
      status = SnmpStrToOid (strtok(tmpBuf, comma), &pName);
      // Initialize the starting value
      pValue.syntax = SNMP_SYNTAX_NULL;
      pValue.value.empty = 0;
      if (hVBL && !(SnmpFreeVbl (hVBL))) // Clear the previous one (if any)
         {
         wsprintf (tmpBuf, "SNMPAPI_FAILURE = %lu %u",
            SnmpGetLastError (0), hVBL);
         MessageBox (GetFocus(), tmpBuf, "SnmpFreeVbl", MB_OK);
         }
      if (!(hVBL = SnmpCreateVbl (hSession, &pName, &pValue)))
         {
         wsprintf (tmpBuf, "SNMPAPI_FAILURE = %lu",
            SnmpGetLastError (hSession));
         MessageBox (GetFocus(), tmpBuf, "SnmpCreateVbl", MB_OK);
         }
      // Initialize the ending OID
      nOID2 = SendDlgItemMessage (hDlg, IDC_OID2, CB_GETCURSEL, 0, 0L);
      GetDlgItemText (hDlg, IDC_OID2, gszOidInBuf, sizeof(gszOidInBuf));
      GetPrivateProfileString (szMIBVars, gszOidInBuf, "9.9",
                               tmpBuf, sizeof(tmpBuf), szIniFile);
      status = SnmpStrToOid (strtok(tmpBuf, comma), &eName);
      status = SnmpOidCompare (&pName, &eName, 0, &nCmp);
      if (nCmp >= 0)
         {
         MessageBeep (MB_OK);
         MessageBox (GetFocus(), "Starting OID must be lower\n\rthan Ending OID",
                     "Request Error", MB_OK);
         // Need to free resources here...BobN 3/17/95
         return (FALSE);
         }
      //
      if (hPDU && !(SnmpFreePdu (hPDU))) // Clear the previous one (if any)
         {
         wsprintf (tmpBuf, "SNMPAPI_FAILURE = %lu %u",
            SnmpGetLastError (0), hPDU);
         MessageBox (GetFocus(), tmpBuf, "SnmpFreePdu", MB_OK);
         }
      if (!(hPDU = SnmpCreatePdu (hSession, SNMP_PDU_GETNEXT, 1, 0, 0, hVBL)))
         {
         wsprintf (tmpBuf, "SNMPAPI_FAILURE = %lu",
            SnmpGetLastError (hSession));
         MessageBox (GetFocus(), tmpBuf, "SnmpCreatePdu", MB_OK);
         }
      if (!(SnmpSendMsg (hSession, hSrc, hDst, hContext, hPDU)))
         { 
         wsprintf (tmpBuf, "SNMPAPI_FAILURE = %lu %u %u", 
            SnmpGetLastError (0), hSrc, hDst);
         MessageBox (GetFocus(), tmpBuf, "SnmpSendMsg", MB_OK);
         }
      // Set Timer
      SetTimer(hMainWnd, IDT_CLOCK, 5000, NULL);
      SnmpFreePdu (hPDU); hPDU = 0;
      SnmpFreeVbl (hVBL); hVBL = 0;
      EndDialog(hDlg, TRUE);
      ShowWindow (hStatusWnd, SW_RESTORE);
      return (TRUE);

      case IDCANCEL:
      EndDialog(hDlg, TRUE);
      return (TRUE);
      }
   break;

   default:
   break;
   }
return (FALSE);
} // GetOid
