// NP_TRAPS.C
// NetPlus (tm) WinSNMP Demo Trap Monitoring Application

#include "np_traps.h"

#define WM_SNMP1 WM_USER+1
#define MAXVARS 10

// Global variables
HWND hMainWnd;
HINSTANCE hInst;
BOOL fTopmost = FALSE;           // Stay on top or not
BOOL fSetLog  = FALSE;           // Log option disabled
HWND hDialog = (HWND)0;
smiUINT32 nTrapCount = 0;

// SnmpStartup variables
smiUINT32 nMajor, nMinor, nLevel, nXlMode, nReMode;
// SnmpOpen variables
HSNMP_SESSION hSession1;
// SnmpStrToEntity variables
HSNMP_ENTITY hRSrc, hRDst;
HSNMP_CONTEXT hRCtx;
smiOCTETS Context;
char szSrcEntity[64];
char szDstEntity[64];
char szContext[64];
char szhSrcEntity[16];
char szhDstEntity[16];
char szhContext[16];
char szsysUpTime[12];
char szFsysUpTime[32];
char szsnmpTrapOID[32];
char szFsnmpTrapOID[32];
char szEnterprise[32];
char szFEnterprise[80];
char trapName[MAXVARS][80];
char trapValue[MAXVARS][255];
LRESULT cCurrentTrap=0;
// Send/Receive variables
HSNMP_PDU hRPdu1;
smiUINT32 nType1;
smiINT nId1;
smiINT nStat1;
smiINT nIx1;
HSNMP_VBL hRVbl1;
smiOID dRName;
smiVALUE sRValue;
char reqid_buf[32];
// Utility variables
smiUINT32 nVars = 0, iVar;
SNMPAPI_STATUS status;
char szAppName[12];
char szAppTitle[64];
char display_buffer[256];
//Save as 
HFILE hLogFile;
LPSTR lpBuffer;
LPSTR lpString;
LPSTR lpStringPrev;
OPENFILENAME ofl;
char szLogFile[128] = "\0";
LPSTR szLogFilter = "NetPlus Log\0*.log\0";
LPCSTR szLogDefExt = "log";
//
BOOL SetLog(BOOL fSetLogT);
void SetTopmost(HWND hwnd, BOOL fTopmostT);
void SaveTrap (void);
void GetTrap (HWND hWnd);
//
// WinMain
int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpCmdLine, int nCmdShow)
{
MSG msg;
if (!hPrevInstance)
   if (!InitApplication(hInstance))
      return (FALSE);
if (!InitInstance(hInstance, nCmdShow))
   return (FALSE);
while (GetMessage (&msg, NULL, NULL, NULL))
   {
   TranslateMessage(&msg);
   DispatchMessage(&msg);
   }
return (msg.wParam);
} // end_WinMain

// InitApplication
BOOL InitApplication (HANDLE hInstance)
{
WNDCLASS  wc;
LoadString (hInstance, IDS_APPNAME, szAppName, sizeof(szAppName));
// ctl3d registration
Ctl3dRegister (hInstance);
Ctl3dAutoSubclass (hInstance);
//
wc.style = NULL;
wc.lpfnWndProc = MainWndProc;
wc.cbClsExtra = 0;
wc.cbWndExtra = 0;
wc.hInstance = hInstance;
wc.hbrBackground = (HBRUSH)(COLOR_BACKGROUND+1);
wc.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_NP_TRAPS));
wc.lpszMenuName =  szAppName;
wc.lpszClassName = szAppName;
return (RegisterClass(&wc));
} // end_InitApplication

// InitInstance
BOOL InitInstance (HANDLE hInstance, int nCmdShow)
{
hInst = hInstance;
LoadString (hInstance, IDS_APPTITLE, szAppTitle, sizeof(szAppTitle));
hMainWnd = CreateWindow (szAppName, szAppTitle,
                     WS_OVERLAPPEDWINDOW,
                     CW_USEDEFAULT, CW_USEDEFAULT,
                     CW_USEDEFAULT, CW_USEDEFAULT,
                     NULL, NULL, hInstance, NULL);
if (!hMainWnd)
   return (FALSE);
// Next section is needed only if logging is chosen...
// Reposition and conditionalize someday...BobN 3/22/95   
if (!(lpBuffer = GlobalAllocPtr(GHND, 65536L)))
  {
  MessageBox (GetFocus(), "FAILURE", "GlobalAllocPtr", MB_OK);
  return (NULL);
  }
lpStringPrev = lpString = lpBuffer;
//
ShowWindow (hMainWnd, nCmdShow);
UpdateWindow (hMainWnd);
// Start WinSNMP
if (!(SnmpStartup (&nMajor, &nMinor, &nLevel, &nXlMode, &nReMode)))
   {
   NPWINSNMPErrMessage (hMainWnd, (LPSTR)"SnmpStartup", (int)SnmpGetLastError(0));
   return (FALSE);
   }     
if (nXlMode != SNMPAPI_UNTRANSLATED_V1)
   {
   if (!(SnmpSetTranslateMode (SNMPAPI_UNTRANSLATED_V1)))
      {
      NPWINSNMPErrMessage (hMainWnd, (LPSTR)"SnmpSetTranslateMode", (int)SnmpGetLastError(0));
      return (FALSE);
      }
   }
// Open a session
if (!(hSession1 = SnmpOpen (hMainWnd, WM_SNMP1)))
   {
   NPWINSNMPErrMessage (hMainWnd, (LPSTR)"SnmpOpen", (int)SnmpGetLastError(0));
   return (FALSE);
   }
// Request all traps from all agents
if (!(SnmpRegister (hSession1, NULL, NULL, NULL, NULL, SNMPAPI_ON)))
   {
   NPWINSNMPErrMessage (hMainWnd, (LPSTR)"SnmpRegister", (int)SnmpGetLastError(hSession1));
   return (FALSE);
   }
// Wrap it up
return (TRUE);
} // end_InitInstance

// MainWndProc
long CALLBACK __export
   MainWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
switch (message)
   {
   case WM_COMMAND:
   switch (wParam)
      {
      case IDM_ABOUT:
      NPAbout (hWnd, szAppName);
      break;
      
      case IDM_HELP_CONTENTS:
      WinHelp (hWnd, "NP_WSNMP.HLP", HELP_CONTENTS, 0L);
      break;
      
      case IDM_FILE_EXIT:
      SendMessage (hWnd, WM_CLOSE, 0, 0L);
      break;
                      
      case IDM_FILE_TRAPDIALOG:
      DialogBox (hInst, "TRAP_DIALOG", hMainWnd, (FARPROC)TrapDialog);
      break;
      
      case IDM_FILE_LOG:
      SetLog (!fSetLog);
      break;
      
      case IDM_OPTIONS_KEEPONTOP:
      SetTopmost (hWnd, !fTopmost);
      break;
      
      default:
      return (DefWindowProc (hWnd, message, wParam, lParam));
      }  // end_switch wParam
   break;

   case WM_SNMP1:
   GetTrap (hWnd);
   break;
   
   case WM_SYSCOLORCHANGE:
   // Ctl3d needs to know
   Ctl3dColorChange();
   break;
   
   case WM_DESTROY:
   // WinSNMP Cleanup
   SnmpClose (hSession1);
   SnmpCleanup();
   // Ctl3d cleanup
   Ctl3dUnregister (hInst);
   // Windows cleanup 
   PostQuitMessage(0);
   break;

   case WM_INITMENU:
   CheckMenuItem (wParam, IDM_FILE_LOG, (fSetLog ? MF_CHECKED : MF_UNCHECKED));
   CheckMenuItem (wParam, IDM_OPTIONS_KEEPONTOP, (fTopmost ? MF_CHECKED : MF_UNCHECKED));
   break;

   default:
   return (DefWindowProc(hWnd, message, wParam, lParam));
   } // end_switch message
return (NULL);
} // end_MainWndProc

// SetTopmost
void SetTopmost (HWND hwnd, BOOL fTopmostT)
{
fTopmost = fTopmostT;
SetWindowPos (hwnd, (fTopmostT ? HWND_TOPMOST : HWND_NOTOPMOST),
            0, 0, 0, 0, SWP_NOACTIVATE | SWP_NOSIZE | SWP_NOMOVE);
} // end_SetTopmost

// SetLog
BOOL SetLog (BOOL fSetLogT)
{
char szExplanation[] = "NP_TRAPS Log\r\n";
if (!(fSetLog = fSetLogT))
   return FALSE;
// Set all structure members to zero
memset(&ofl, 0, sizeof(OPENFILENAME));
// Initialize the OPENFILENAME members
szLogFile[0] = '\0';
ofl.lStructSize = sizeof(OPENFILENAME);
ofl.hwndOwner = hMainWnd;
ofl.lpstrFilter = szLogFilter;
ofl.lpstrFile= szLogFile;
ofl.nMaxFile = sizeof(szLogFile);
ofl.lpstrDefExt = szLogDefExt;
ofl.Flags = OFN_SHOWHELP | OFN_OVERWRITEPROMPT;
if (GetSaveFileName(&ofl))
   {
   hLogFile = _lcreat (szLogFile, 0);
   _lwrite (hLogFile, szExplanation, lstrlen (szExplanation));
   return TRUE;
   }                                
else
   {
   _lclose (hLogFile);
   return FALSE;
   }
} // end_SetLog

// GetTrap
void GetTrap (HWND hWnd)
{
if (!(SnmpRecvMsg (hSession1, &hRSrc, &hRDst, &hRCtx, &hRPdu1)))
   {
   NPWINSNMPErrMessage (hMainWnd, (LPSTR)"SnmpRecvMsg", (int)SnmpGetLastError(hSession1));
   return;
   }
// srcEntity
wsprintf (szhSrcEntity, "%u", hRSrc);
if (hRSrc)
   {
   if (!SnmpEntityToStr (hRSrc, (smiUINT32)sizeof(szSrcEntity), (LPSTR)szSrcEntity))
      {
      NPWINSNMPErrMessage (hMainWnd,(LPSTR)"SnmpEntityToStr - Src", (int)SnmpGetLastError(hSession1));
      return;
      }
   SnmpFreeEntity (hRSrc);
   }
else
   wsprintf (szSrcEntity, "Not Available");
// dstEntity
wsprintf (szhDstEntity, "%u", hRDst);
if (hRDst)
   {
   if (!SnmpEntityToStr (hRDst, (smiUINT32)sizeof(szDstEntity), (LPSTR)szDstEntity))
      {
      NPWINSNMPErrMessage (hMainWnd, (LPSTR)"SnmpEntityToStr - Dst", (int)SnmpGetLastError(hSession1));
      return;
      }
   SnmpFreeEntity (hRDst);
   }
else
   wsprintf (szDstEntity, "Not Available");
// context
wsprintf (szhContext, "%u",hRCtx);
if (hRCtx)
   {
   if (!SnmpContextToStr (hRCtx, (smiLPOCTETS)&Context))
      {
      NPWINSNMPErrMessage (hMainWnd, (LPSTR)"SnmpContextToStr", (int)SnmpGetLastError(hSession1));
      return;
      }
   SnmpFreeContext (hRCtx);   
   memcpy (szContext, Context.ptr, (size_t)Context.len);
   szContext[Context.len] = '\0';
   SnmpFreeDescriptor (SNMP_SYNTAX_OCTETS, (smiLPOPAQUE)&Context);
   }
else
   wsprintf (szContext,  "Not Available");
//
if (!(SnmpGetPduData (hRPdu1, &nType1, &nId1, &nStat1, &nIx1, &hRVbl1)))
   {
   NPWINSNMPErrMessage (hMainWnd, (LPSTR)"SnmpGetPduData", (int)SnmpGetLastError(hSession1));
   return;
   }
if (!(SnmpFreePdu (hRPdu1)))
   {
   NPWINSNMPErrMessage (hMainWnd, (LPSTR)"SnmpFreePdu", (int)SnmpGetLastError(hSession1));
   return;
   }
wsprintf (reqid_buf, "%lu", nId1);
if (nType1 != SNMP_PDU_TRAP)
   {
   wsprintf (display_buffer, "SNMPAPI_FAILURE = %lu", nType1);
   MessageBox (hWnd, display_buffer, "SNMP PDU Type", MB_OK);
   }
if (!(nVars = SnmpCountVbl (hRVbl1)))
   {
   NPWINSNMPErrMessage (hMainWnd, (LPSTR)"SnmpCountVbl", (int)SnmpGetLastError(hSession1));
   return;
   }
nVars = min (nVars, MAXVARS);
for (iVar = 0; iVar < nVars; iVar++)
   {
   if (!(SnmpGetVb (hRVbl1, iVar+1, &dRName, &sRValue)))
      {
      NPWINSNMPErrMessage (hMainWnd, (LPSTR)"SnmpGetVb", (int)SnmpGetLastError(hSession1));
      return;
      }
   // Should be 26,13:30:15.0  format as RFC1443 suggests for dates
   if (iVar==0) 
      {
      unsigned long day = 24L*60L*60L*100L;
      unsigned long hour = 60L*60L*100L;
      unsigned long minute = 60L*100L;
      unsigned long hundred  = 100L;
      wsprintf (szsysUpTime, "%lu",  sRValue.value.uNumber );
      wsprintf (szFsysUpTime, "%lu,%lu:%lu:%lu.%lu",
         sRValue.value.uNumber/day,
         (sRValue.value.uNumber%(day))/hour,
         ((sRValue.value.uNumber%(day))%hour)/minute,
         (((sRValue.value.uNumber%(day))%hour)%minute)/hundred,
         (((sRValue.value.uNumber%(day))%hour)%minute)%hundred);
      }
   else
     if (iVar==1) 
      {
      status = SnmpOidToStr (&sRValue.value.oid, sizeof(szsnmpTrapOID), szsnmpTrapOID);
      if (sRValue.value.oid.ptr[4] == 4) //Specific Trap
         {
         _ultoa (sRValue.value.oid.ptr[6], szEnterprise, 10);
         GetPrivateProfileString ("Enterprises", szEnterprise, "0",
         szFEnterprise, sizeof(szFEnterprise), "NP_WSNMP.INI");
         SnmpOidToStr (&sRValue.value.oid, sizeof(szsnmpTrapOID), szsnmpTrapOID);
         lstrcpy (szFsnmpTrapOID, "enterpriseSpecific");
         }
      else
         {
         lstrcpy (szFsnmpTrapOID, "unKnown"); // initialize for default case
         szEnterprise[0] = '\0';
         szFEnterprise[0] = '\0';
         switch(sRValue.value.oid.ptr[9]) // Generic Trap
            { // This can be greatly reduced...BobN 3/21/95
            case 1:
            lstrcpy (szFsnmpTrapOID, "coldStart");
            break;
            case 2:
            lstrcpy (szFsnmpTrapOID, "warmStart");
            break;
            case 3:
            lstrcpy (szFsnmpTrapOID, "linkDown");
            break;
            case 4:
            lstrcpy (szFsnmpTrapOID, "linkUp");
            break;
            case 5:
            lstrcpy (szFsnmpTrapOID, "authenticationFailure");
            break;
            case 6:
            lstrcpy (szFsnmpTrapOID, "egpNeighborLoss");
            break;
            default:
            break;
            } // end_switch
         } // end_else
      } // end_if (iVar == 1)
   else
      if (iVar!=nVars-1) 
         {
         status = SnmpOidToStr (&dRName, sizeof(trapName[iVar-2]), &trapName[iVar-2][0]);
         NPWSNMPValueToStr (&sRValue, sizeof(trapValue[iVar-2]), &trapValue[iVar-2][0]);
         }
   if (!(SnmpFreeDescriptor (SNMP_SYNTAX_OID, (smiLPOPAQUE)&dRName)))
         {
         wsprintf (display_buffer, "SNMPAPI_FAILURE = %lu", SnmpGetLastError (hSession1));
         MessageBox (hWnd, display_buffer, "SnmpFreeDesriptor - dRName", MB_OK);
         }
   if (sRValue.syntax == SNMP_SYNTAX_OCTETS || sRValue.syntax == SNMP_SYNTAX_OID)
      {
      if (!(SnmpFreeDescriptor (sRValue.syntax, (smiLPOPAQUE)&sRValue.value.oid)))
         {
         wsprintf (display_buffer, "SNMPAPI_FAILURE = %lu", SnmpGetLastError (hSession1));
         MessageBox (hWnd, display_buffer, "SnmpFreeDesriptor - sRValue", MB_OK);
         }
      }
   } // end_for
if(!(SnmpFreeVbl (hRVbl1)))
   {
   NPWINSNMPErrMessage (hMainWnd, (LPSTR)"SnmpFreeVbl", (int)SnmpGetLastError(hSession1));
   return;
   }
ShowTrap();
if (fSetLog)
   SaveTrap();
InvalidateRect (hWnd, NULL, TRUE);
UpdateWindow (hWnd);
} // end_GetTrap

// ShowTrap
void ShowTrap (void)
{
UINT i;
nTrapCount++;
SendDlgItemMessage(hDialog,IDC_EDIT_REQUEST,WM_SETTEXT,0,(LPARAM)((LPSTR)reqid_buf));
SendDlgItemMessage(hDialog,IDC_EDIT_SRCENTYTY_VALUE,WM_SETTEXT,0,(LPARAM)((LPSTR)szhSrcEntity));
SendDlgItemMessage(hDialog,IDC_EDIT_SRCENTYTY_TRANSLATION,WM_SETTEXT,0,(LPARAM)((LPSTR)szSrcEntity));
SendDlgItemMessage(hDialog,IDC_EDIT_DSTENTYTY_VALUE,WM_SETTEXT,0,(LPARAM)((LPSTR)szhDstEntity));
SendDlgItemMessage(hDialog,IDC_EDIT_DSTENTYTY_TRANSLATION,WM_SETTEXT,0,(LPARAM)((LPSTR)szDstEntity));
SendDlgItemMessage(hDialog,IDC_EDIT_COMMUNITY_VALUE,WM_SETTEXT,0,(LPARAM)((LPSTR)szhContext));
SendDlgItemMessage(hDialog,IDC_EDIT_COMMUNITY_TRANLATION,WM_SETTEXT,0,(LPARAM)((LPSTR)szContext));
SendDlgItemMessage(hDialog,IDC_EDIT_SYSUPTIME_VALUE,WM_SETTEXT,0,(LPARAM)((LPSTR)szsysUpTime));
SendDlgItemMessage(hDialog,IDC_EDIT_SYSUPTIME_TRANSLATION,WM_SETTEXT,0,(LPARAM)((LPSTR)szFsysUpTime));
SendDlgItemMessage(hDialog,IDC_EDIT_TRAPOID_VALUE,WM_SETTEXT,0,(LPARAM)((LPSTR)szsnmpTrapOID));
SendDlgItemMessage(hDialog,IDC_EDIT_TRAPOID_TRANSLATION,WM_SETTEXT,0,(LPARAM)((LPSTR)szFsnmpTrapOID));
SendDlgItemMessage(hDialog,IDC_EDIT_ENTERPRISE_VALUE,WM_SETTEXT,0,(LPARAM)((LPSTR)szEnterprise));
SendDlgItemMessage(hDialog,IDC_EDIT_ENTERPRISE_TRANSLATION,WM_SETTEXT,0,(LPARAM)((LPSTR)szFEnterprise));
SendDlgItemMessage(hDialog, IDC_COMBO_VARBIND_OID, CB_RESETCONTENT, 0, 0);
for (i=0; i<nVars-3; i++)
   SendDlgItemMessage (hDialog, IDC_COMBO_VARBIND_OID, CB_ADDSTRING, 0, (LPARAM)((LPSTR)&trapName[i][0]));
if (nVars > 3)
   {
   cCurrentTrap = SendDlgItemMessage (hDialog,IDC_COMBO_VARBIND_OID, CB_SETCURSEL, (WPARAM)cCurrentTrap, 0);
   SendDlgItemMessage (hDialog,IDC_EDIT_VARBIND_VALUE, WM_SETTEXT, 0, (LPARAM)((LPSTR)&trapValue[cCurrentTrap][0]));
   }
else
   SendDlgItemMessage (hDialog, IDC_EDIT_VARBIND_VALUE, WM_SETTEXT, 0, (LPARAM)((LPSTR)""));
SetDlgItemInt (hDialog, IDC_EDIT_TRAPCOUNT, (UINT)nTrapCount, FALSE);
return;
} // end_ShowTrap

// TrapDialog
BOOL __export CALLBACK
   TrapDialog (HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
switch (message)
   {
   case WM_INITDIALOG:
      {
      hDialog = hDlg;
      if (fSetLog)
         CheckDlgButton (hDlg, IDC_SET_LOG, 1);
      if (fTopmost)
         CheckDlgButton (hDlg, IDC_KEEP_ON_TOP, 1);
      }
   break;
   case WM_COMMAND:
   switch (wParam)
      {
      case IDC_SET_LOG:
      if (!(SetLog  (!fSetLog)))
         {
         fSetLog = FALSE;
         CheckDlgButton (hDlg, IDC_SET_LOG, 0);
         }
      break;

      case IDC_KEEP_ON_TOP:
      SetTopmost (hMainWnd, !fTopmost);
      break;
     
      case IDCANCEL:
      EndDialog (hDialog, TRUE);
      break;
      
      default:
      break;
      } // end_switch (wParam)
   default:
   break;
   } // end_switch (message)
return (FALSE);
} // end_TrapDialog

// SaveTrap
void SaveTrap (void)
{
UINT i;
char szRow[80];
char szDate[9];
char szTime[9];
if (lpBuffer == lpString)
   memset (lpBuffer, ' ', 65535L);
//  else to write a round robin throu 64k limit

/*Format Title's ******************* line */
wsprintf (szRow, "\r\n%s\r\n\r\n",
"*****************************************************************************");
lstrcpy (lpString, szRow);
lpString+= lstrlen(szRow);

/*Format Title */
wsprintf (szRow, "%s %s %s",
                 "               Trap received: ", _strdate(szDate), _strtime(szTime));
lstrcpy (lpString, szRow);
lpString+= lstrlen(szRow);

/*Format Title */
wsprintf (szRow, "\r\n\r\n\r\n\r\n%10.10s%15.15s%34.34s\r\n",
                 "FIELD", "VALUE", "TRANSLATED VALUE");           
lstrcpy (lpString, szRow);
lpString+= lstrlen(szRow);

/*Format Title's underline */
wsprintf (szRow, "%10.10s%15.15s%34.34s\r\n\r\n\r\n", "=====", "=====", "================");
lstrcpy (lpString, szRow);
lpString+= lstrlen(szRow);

/*Format RequestID line */
wsprintf (szRow, "%-19.19s %-21.21s \r\n", "Request ID:", reqid_buf);
lstrcpy (lpString, szRow);
lpString+= lstrlen(szRow);

/*Format Source Entity line*/
wsprintf (szRow, "%-19.19s %-21.21s %-33.33s \r\n",
                 "Source Entity:", szhSrcEntity, szSrcEntity);
lstrcpy (lpString, szRow);
lpString+= lstrlen(szRow);

/*Format Destination Entity line*/
wsprintf (szRow, "%-19.19s %-21.21s %-33.33s \r\n",
                 "Destination Entity:", szhDstEntity, szDstEntity);
lstrcpy (lpString, szRow);
lpString+= lstrlen(szRow);

/*Format Community line*/
wsprintf (szRow, "%-19.19s %-21.21s %-33.33s \r\n", "Community:", szhContext, szContext);
lstrcpy (lpString, szRow);
lpString+= lstrlen(szRow);

/*Format sysUpTime line*/
wsprintf (szRow, "%-19.19s %-21.21s %-33.33s \r\n", "sysUpTime:", szsysUpTime, szFsysUpTime);
lstrcpy (lpString, szRow);
lpString+= lstrlen(szRow);

/*Format TrapOID line*/
wsprintf (szRow, "%-19.19s %-21.21s %-33.33s \r\n", "snmpTrapOID:", szsnmpTrapOID, szFsnmpTrapOID);
lstrcpy (lpString, szRow);
lpString+= lstrlen(szRow);

/*Format Enterprise line*/
wsprintf (szRow, "%-19.19s %-21.21s %-33.33s \r\n", "Enterprise:", szEnterprise, szFEnterprise);
lstrcpy (lpString, szRow);
lpString+= lstrlen(szRow);

if (lstrlen(szFEnterprise) >= 33)
   {
   wsprintf (szRow, "%42.42s%-33.33s\r\n", " ", &szFEnterprise[33]);
   lstrcpy (lpString, szRow);
   lpString+= lstrlen(szRow);
   }

if (nVars>3)
/*Format additional varbinds*/
   {
   wsprintf (szRow, "\r\n%40.40s\r\n", "ADDITIONAL VARBINDS");
   lstrcpy (lpString, szRow);
   lpString+= lstrlen(szRow);

   wsprintf (szRow, "%40.40s\r\n\r\n", "========== ========");
   lstrcpy (lpString, szRow);
   lpString+= lstrlen(szRow);

   wsprintf (szRow, "%9.9s%16.16s\r\n", "NAME", "VALUE");
   lstrcpy (lpString, szRow);
   lpString+= lstrlen(szRow);

   wsprintf (szRow, "%9.9s%16.16s\r\n\r\n", "====", "=====");
   lstrcpy (lpString, szRow);
   lpString+= lstrlen(szRow);

   for (i=0; i<nVars-3; i++)
      {
      UINT j=1;
      wsprintf (szRow, "%-20.20s%-56.56s\r\n",trapName[i], trapValue[i]);
      lstrcpy (lpString, szRow);
      lpString+= lstrlen(szRow);
      while (((UINT)lstrlen(trapValue[i]) > 56*j))
         {
         wsprintf (szRow, "%20.20s%-56.56s\r\n"," ",&trapValue[i][56*j]);
         lstrcpy (lpString, szRow);
         lpString+= lstrlen(szRow);
         j++;
         } // end_while
      } // end_for
   } // end_if
if (fSetLog)
   _lwrite (hLogFile, lpStringPrev, (UINT)(lpString - lpStringPrev));
lpStringPrev =  lpString;
} // end_SaveTrap
