// NP_SET.C
/*
 * Purpose:
 *
 * Use:
 * This is a sample application provided for illustration and
 * instructional use only.  It is not a supported product of
 * American Computer and Electronics Corp and it is not warranted
 * to perform any useful functions other than those mentioned in
 * the previous sentence.  This application code is provided only
 * as a model for didactic purposes.
 *
 */
// #includes and #defines
#include "np_set.h"
#include <windowsx.h>
#include <stdlib.h>
#include <string.h>
#include <ctl3d.h>

#define WM_SNMPMSG WM_USER + 100
#define MAXVARS 5
#define TIMER_ID        1     // Default Timer ID
#define TIMER_INTERVAL  8000  // # of ms to wait for response.

// Local and Extern Variables
HANDLE hInst;
HANDLE hMainWnd;
LPSTR szAppName = "NP_SET";
HWND hDialog, hwndButton;
BOOL fOidOutFlag = FALSE;
BOOL fTimer = FALSE;
char gszOidOutBuf[MAXVARS][256];
char gszOidInBuf[MAXVARS][256];
char gszCommStr[256];
char gszNetAddrBuf[64];
char display_buffer[256];
LRESULT cCurrentEntity=0;
LRESULT cCurrentContext=0;
LRESULT cCurrentOID=0;
HSNMP_SESSION hSession;
LPSTR communityValue = "public";
smiOCTETS communityString;
smiOCTETS outTest;
smiOID outName;
smiVALUE outValue[MAXVARS];
smiVALUE RetValue[MAXVARS];
smiUINT32 nVars;
smiUINT32 timer_interval = TIMER_INTERVAL;
LPSTR comma=",";
enum {Entity, Context, OID} focus;
// Function Prototypes
SNMPAPI_STATUS InProcessPDU (void);
SNMPAPI_STATUS OutProcessPDU (void);
SNMPAPI_STATUS NPWSNMPStrToValue (LPSTR, smiLPVALUE);

// WinMain
int PASCAL WinMain(
   HANDLE hInstance,     // current instance
   HANDLE hPrevInstance, // previous instance
   LPSTR lpCmdLine,      // command line
   int nCmdShow)         // show-window type (open/icon)
{
    MSG  msg;

   if (!hPrevInstance)
      if (!InitApplication(hInstance))
         return (FALSE);

   if (!InitInstance(hInstance, nCmdShow))
      return (FALSE);

   while (GetMessage(&msg, NULL, NULL, NULL))
   {
      TranslateMessage(&msg); // Translates virtual key codes
      DispatchMessage(&msg);  // Dispatches message to window
   }
   return (msg.wParam);       // Returns the value from PostQuitMessage
}  // WinMain

// InitApplication
BOOL InitApplication (HANDLE hInstance)
{
    WNDCLASS  wc;
// ctl3d registration
   Ctl3dRegister (hInstance);
   Ctl3dAutoSubclass (hInstance);

    wc.style = NULL;
    wc.lpfnWndProc = MainWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_NP_SET));
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)(COLOR_BACKGROUND+1);
    wc.lpszMenuName = szAppName;
    wc.lpszClassName = szAppName;

    return (RegisterClass(&wc));

} // InitApplication

// InitInstance
BOOL InitInstance (HANDLE hInstance, int nCmdShow)
{
HWND hWnd;
SNMPAPI_STATUS status;
smiUINT32 nMajorV, nMinorV, nLevel, nTranslateMode, nReMode;

hInst = hInstance;

hWnd = CreateWindow (szAppName, szAppName, WS_OVERLAPPEDWINDOW,
                     CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
                     NULL, NULL, hInstance, NULL);
if (!hWnd)
   return (FALSE);

ShowWindow(hWnd, nCmdShow);
UpdateWindow(hWnd);
hMainWnd = hWnd;
status = SnmpStartup (&nMajorV, &nMinorV, &nLevel, &nTranslateMode, &nReMode);
if (status == SNMPAPI_FAILURE)
{
   NPWINSNMPErrMessage( hMainWnd,(LPSTR)"SnmpStartup",
   (int)SnmpGetLastError(0)) ;
   return (SNMPAPI_FAILURE);
}

if (nTranslateMode != SNMPAPI_UNTRANSLATED_V1)
{
   status = SnmpSetTranslateMode(SNMPAPI_UNTRANSLATED_V1);
   if (status == SNMPAPI_FAILURE)
   {
      NPWINSNMPErrMessage( hMainWnd,(LPSTR)"SnmpSetTranslateMode",
      (int)SnmpGetLastError(0)) ;
      return (SNMPAPI_FAILURE);
   }
}
lstrcpy (gszCommStr, communityValue);     
hSession = SnmpOpen (hWnd,WM_SNMPMSG);
return (TRUE); // Returns the value from PostQuitMessage

} // InitInstance
// MainWndProc
long CALLBACK __export
   MainWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
SNMPAPI_STATUS status;
UINT i;

switch (message)
   {
   case WM_COMMAND:
      switch (wParam)
      {
      case IDM_ABOUT:
      NPAbout (hWnd, szAppName);
      break;
      
      case IDM_HELP_CONTENTS:
      WinHelp(hWnd, "NP_WSNMP.HLP", HELP_CONTENTS, 0L);
      break;
      
      case IDM_FILE_EXIT:
      SendMessage (hWnd, WM_CLOSE, 0, 0L);
      break;
                   
      case IDM_GETOID:
      focus = OID;
      DialogBox (hInst, "GETOID", hWnd, GetOid);
      break;
                  
      case IDM_PASSWD:
      focus = Context;
      DialogBox (hInst, "GETOID", hWnd, GetOid);
      break;
                  
      case IDM_IP:
      focus = Entity;
      DialogBox (hInst, "GETOID", hWnd, GetOid);
      break;
                  
      default:
      return (DefWindowProc (hWnd, message, wParam, lParam));
      }  // switch wParam
   break;

   case WM_SNMPMSG:
   if (fTimer)
    {
    KillTimer(hMainWnd,TIMER_ID);
    fTimer = FALSE;
    hwndButton = GetDlgItem (hDialog, IDOK);
    SendMessage (hwndButton, BM_SETSTATE, 0, 0L); // Set Released
    }
   else
    return TRUE;

   status = InProcessPDU ();
   if ( status == SNMPAPI_FAILURE)
     return FALSE;

   nVars = min(status, MAXVARS);

   NPWSNMPValueToStr (&RetValue, sizeof(gszOidOutBuf), gszOidOutBuf);
   fOidOutFlag = TRUE;
   focus = OID;
   SendDlgItemMessage(hDialog,IDC_RETURNED_VALUE_1,WM_SETTEXT,0,(LPARAM)((LPSTR *)gszOidOutBuf[0]));
   SendDlgItemMessage(hDialog,IDC_RETURNED_VALUE_2,WM_SETTEXT,0,(LPARAM)((LPSTR *)gszOidOutBuf[1]));
   SendDlgItemMessage(hDialog,IDC_RETURNED_VALUE_3,WM_SETTEXT,0,(LPARAM)((LPSTR *)gszOidOutBuf[2]));
   SendDlgItemMessage(hDialog,IDC_RETURNED_VALUE_4,WM_SETTEXT,0,(LPARAM)((LPSTR *)gszOidOutBuf[3]));
   SendDlgItemMessage(hDialog,IDC_RETURNED_VALUE_5,WM_SETTEXT,0,(LPARAM)((LPSTR *)gszOidOutBuf[4]));
   for (i = 0; i < nVars; i++)
      SnmpFreeDescriptor (RetValue[i].syntax, &RetValue[i].value.string);
   break;
        
   case WM_SYSCOLORCHANGE:
   // Ctl3d needs to know
     Ctl3dColorChange();
   break;

   case WM_TIMER:
     fTimer = FALSE ;
     KillTimer(hMainWnd,TIMER_ID);
     hwndButton = GetDlgItem (hDialog, IDOK);
     SendMessage (hwndButton, BM_SETSTATE, 0, 0L); // Set Relesed

     wsprintf(display_buffer,"No Response from SNMP Agent.\n%d  seconds timeout is expired.", timer_interval/1000);
     MessageBox (hMainWnd, display_buffer, "TimeOut", MB_OK);
   break;

   case WM_DESTROY:
   // WinSNMP Cleanup
   if (fTimer)
   {
     fTimer = FALSE ;
     KillTimer(hWnd,TIMER_ID);
     hwndButton = GetDlgItem (hDialog, IDOK);
     SendMessage (hwndButton, BM_SETSTATE, 0, 0L); // Set Released
   }
   status = SnmpClose(hSession);
   if (status == SNMPAPI_FAILURE)
   {
      NPWINSNMPErrMessage( hMainWnd,(LPSTR)"SnmpClose",
      (int)SnmpGetLastError(hSession)) ;
      return (SNMPAPI_FAILURE);
   }
   status = SnmpCleanup();
   if (status == SNMPAPI_FAILURE)
   {
      NPWINSNMPErrMessage( hMainWnd,(LPSTR)"SnmpCleanup",
      (int)SnmpGetLastError(0)) ;
      return (SNMPAPI_FAILURE);
   }
   // Ctl3d cleanup
   Ctl3dUnregister (hInst);
   /* Windows cleanup */
   PostQuitMessage(0);
   break;

   default:                  /* Passes it on if unproccessed    */
   return (DefWindowProc(hWnd, message, wParam, lParam));
   }  // switch message

return (NULL);
} // MainWndProc

// GetOid
BOOL __export CALLBACK
   GetOid (HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
switch (message)
   {
   case WM_INITDIALOG:
   {
      int i;
      NPWSNMPINISECTION sOStruct;
      NPWSNMPINISECTION sCStruct;
      NPWSNMPINISECTION sEStruct;
      hDialog = hDlg;
      switch (focus)
      {
         case Entity:
         SetFocus (GetDlgItem (hDlg, IDC_AGENT_ADDRESS));
         break;
         case Context:
         SetFocus (GetDlgItem (hDlg, IDC_COMMUNITY_STRING));
         break;
         case OID:
         SetFocus (GetDlgItem (hDlg, IDC_INPUT_OID_1));
         break;
      }
      /*Agent*/
      NPWSNMPGetIniSection ((LPCSTR)"Entities", &sEStruct);
      for (i=0; i<sEStruct.count; i++)
         SendDlgItemMessage (hDlg, IDC_AGENT_ADDRESS, CB_ADDSTRING, 0, (LPARAM) ((LPSTR)sEStruct.ptrs[i]));
      cCurrentEntity = SendDlgItemMessage(hDlg,IDC_AGENT_ADDRESS,CB_SETCURSEL,(WPARAM)cCurrentEntity, 0);
      /*Community*/
      NPWSNMPGetIniSection ((LPCSTR)"Contexts", &sCStruct);
      for (i=0; i<sCStruct.count; i++)
         SendDlgItemMessage(hDlg, IDC_COMMUNITY_STRING, CB_ADDSTRING, 0, (LPARAM)((LPSTR)sCStruct.ptrs[i]));
      cCurrentContext = SendDlgItemMessage(hDlg,IDC_COMMUNITY_STRING,CB_SETCURSEL,(WPARAM)cCurrentContext, 0);
      /*OID*/
      NPWSNMPGetIniSection ((LPCSTR)"MIB Variables",&sOStruct);
      for (i=0; i<sOStruct.count; i++)
      {
         SendDlgItemMessage(hDlg, IDC_INPUT_OID_1, CB_ADDSTRING, 0, (LPARAM)((LPSTR)sOStruct.ptrs[i]));
         SendDlgItemMessage(hDlg, IDC_INPUT_OID_2, CB_ADDSTRING, 0, (LPARAM)((LPSTR)sOStruct.ptrs[i]));
         SendDlgItemMessage(hDlg, IDC_INPUT_OID_3, CB_ADDSTRING, 0, (LPARAM)((LPSTR)sOStruct.ptrs[i]));
         SendDlgItemMessage(hDlg, IDC_INPUT_OID_4, CB_ADDSTRING, 0, (LPARAM)((LPSTR)sOStruct.ptrs[i]));
         SendDlgItemMessage(hDlg, IDC_INPUT_OID_5, CB_ADDSTRING, 0, (LPARAM)((LPSTR)sOStruct.ptrs[i]));
      }
      return (FALSE);
   }
   case WM_CTLCOLOR:
      if (HIWORD(lParam) == CTLCOLOR_EDIT)
         {
         SetBkMode(wParam, TRANSPARENT);

         if (fOidOutFlag)
            SetTextColor (wParam, RGB(255,0,0));
         else
            SetTextColor (wParam, RGB(0,255,0));
         return (HBRUSH) GetStockObject (LTGRAY_BRUSH);
         }
      return (HBRUSH) NULL;
                  
   case WM_COMMAND:
    if (HIWORD(lParam) == EN_SETFOCUS) 
        fOidOutFlag = FALSE;
   switch (wParam)
      {
      DWORD dwIndex;
      case IDOK:
     if (fTimer)
      return FALSE;
      fOidOutFlag = FALSE;

      hwndButton = GetDlgItem (hDlg, IDOK);
      SendMessage (hwndButton, BM_SETSTATE, 1, 0L); // Set Depressed

      nVars = 0;
      dwIndex = SendDlgItemMessage(hDlg, IDC_AGENT_ADDRESS, CB_GETCURSEL,0, 0);
      if (dwIndex != CB_ERR)
         cCurrentEntity = dwIndex;
      GetDlgItemText (hDlg, IDC_AGENT_ADDRESS, gszNetAddrBuf, sizeof(gszNetAddrBuf));

      dwIndex = SendDlgItemMessage(hDlg, IDC_COMMUNITY_STRING, CB_GETCURSEL,0, 0);
      if (dwIndex != CB_ERR)
         cCurrentContext = dwIndex;
      GetDlgItemText (hDlg, IDC_COMMUNITY_STRING, gszCommStr, sizeof(gszCommStr));

      if(SendDlgItemMessage(hDlg, IDC_INPUT_OID_1, CB_GETCURSEL,0, 0) != CB_ERR)
      {
      GetDlgItemText (hDlg, IDC_INPUT_OID_1, gszOidInBuf[0], sizeof(gszOidInBuf[0]));
      GetDlgItemText (hDlg, IDC_RETURNED_VALUE_1,  gszOidOutBuf[0], sizeof(gszOidOutBuf[0]));
      nVars++;
      }
      if(SendDlgItemMessage(hDlg, IDC_INPUT_OID_2, CB_GETCURSEL,0, 0) != CB_ERR)
      {
      GetDlgItemText (hDlg, IDC_INPUT_OID_2, gszOidInBuf[1], sizeof(gszOidInBuf[1]));
      GetDlgItemText (hDlg, IDC_RETURNED_VALUE_2,  gszOidOutBuf[1], sizeof(gszOidOutBuf[1]));
      nVars++;
      }
        
      if(SendDlgItemMessage(hDlg, IDC_INPUT_OID_3, CB_GETCURSEL,0, 0) != CB_ERR)
      {
      GetDlgItemText (hDlg, IDC_INPUT_OID_3, gszOidInBuf[2], sizeof(gszOidInBuf[2]));
      GetDlgItemText (hDlg, IDC_RETURNED_VALUE_3,  gszOidOutBuf[2], sizeof(gszOidOutBuf[2]));
      nVars++;
      }

      if(SendDlgItemMessage(hDlg, IDC_INPUT_OID_4, CB_GETCURSEL,0, 0) != CB_ERR)
      {
      GetDlgItemText (hDlg, IDC_INPUT_OID_4, gszOidInBuf[3], sizeof(gszOidInBuf[3]));
      GetDlgItemText (hDlg, IDC_RETURNED_VALUE_4,  gszOidOutBuf[3], sizeof(gszOidOutBuf[3]));
      nVars++;
      }

      if(SendDlgItemMessage(hDlg, IDC_INPUT_OID_5, CB_GETCURSEL,0, 0) != CB_ERR)
      {
      GetDlgItemText (hDlg, IDC_INPUT_OID_5, gszOidInBuf[4], sizeof(gszOidInBuf[4]));
      GetDlgItemText (hDlg, IDC_RETURNED_VALUE_5,  gszOidOutBuf[4], sizeof(gszOidOutBuf[4]));
      nVars++;
      }

      if (OutProcessPDU () == SNMPAPI_FAILURE)
      {
         fOidOutFlag = FALSE;
         SendMessage (hwndButton, BM_SETSTATE, 0, 0L); // Set Released
         if (fTimer)
         {
          KillTimer(hMainWnd,TIMER_ID);
          fTimer = FALSE;
         }
/*       return FALSE;*/
      }
      return (TRUE);

      case IDCANCEL:
      fOidOutFlag = FALSE;
      EndDialog(hDlg, TRUE);
      return (TRUE);
      }
   break;

   default:
   break;
   }
return (FALSE);
} // GetOid

SNMPAPI_STATUS InProcessPDU (void)
{
   HSNMP_PDU hPDU;
   HSNMP_VBL hVBL;
   smiOID name;
   SNMPAPI_STATUS status;
   smiINT PduType,Err_stat,Err_index;
   smiINT32 Request_id;
   smiUINT32 count;
   UINT i, j;

   status = SnmpRecvMsg(hSession, NULL, NULL, NULL, &hPDU); 
   if (status == SNMPAPI_FAILURE) 
   {
      NPWINSNMPErrMessage( hMainWnd,(LPSTR)"SnmpRecvMsg",
      (int)SnmpGetLastError(hSession)) ;
      return (SNMPAPI_FAILURE);
   }

   status = SnmpGetPduData(hPDU,&PduType,&Request_id,&Err_stat,
                 &Err_index,&hVBL);
   if (status == SNMPAPI_FAILURE)
   {
      NPWINSNMPErrMessage( hMainWnd,(LPSTR)"SnmpGetPduData",
      (int)SnmpGetLastError(hSession)) ;
      SnmpFreePdu(hPDU);
      return (SNMPAPI_FAILURE);
   }
   if (PduType != SNMP_PDU_RESPONSE)
      MessageBox (hMainWnd, "Pdu type not response", "SNMP_ERROR", MB_OK);
   if (Err_stat != SNMP_ERROR_NOERROR)
   {
      NPSNMPErrMessage( hMainWnd, (int)Err_stat,  (int)Err_index) ;
      SnmpFreePdu(hPDU);
      SnmpFreeVbl(hVBL);// Just in case.
      return  SNMPAPI_FAILURE;
   }
   count = SnmpCountVbl(hVBL);
   if (count == SNMPAPI_FAILURE)
   {
      NPWINSNMPErrMessage( hMainWnd,(LPSTR)"SnmpCountVbl",
      (int)SnmpGetLastError(hSession)) ;
      SnmpFreePdu(hPDU);
      SnmpFreeVbl(hVBL);
      return (SNMPAPI_FAILURE);
   }
   for (i = 0; i < count; i++)
   {
      status = SnmpGetVb (hVBL, i+1, &name, &(RetValue[i]));
      if (status == SNMPAPI_FAILURE)
      {
         NPWINSNMPErrMessage( hMainWnd,(LPSTR)"SnmpGetVb",
         (int)SnmpGetLastError(hSession)) ;
         SnmpFreePdu(hPDU);
         SnmpFreeVbl(hVBL);
         for(j=0;j < i; j++)
            SnmpFreeDescriptor (RetValue[j].syntax, &RetValue[j].value.string);
         return (SNMPAPI_FAILURE);
      }
      SnmpFreeDescriptor (SNMP_SYNTAX_OID, (smiLPOPAQUE)&name);
   }
   SnmpFreePdu(hPDU);
   SnmpFreeVbl(hVBL);
   return count;
} // InProcessPDU

SNMPAPI_STATUS OutProcessPDU ()
{
SNMPAPI_STATUS status;
HSNMP_ENTITY hDst,hSrc;
HSNMP_CONTEXT hContext;
HSNMP_PDU hPDU;
HSNMP_VBL hVBL;
smiVALUE InputValue[MAXVARS];
smiOID InputName[MAXVARS];
smiTIMETICKS   nActualTimeout = 0,
               nPolicyTimeout = 0;
char  buf1[256];
LPSTR profilePtr;
UINT i, j;

status = SnmpSetTranslateMode (SNMPAPI_TRANSLATED);
if (!(hDst = SnmpStrToEntity(hSession,gszNetAddrBuf)))
{
   NPWINSNMPErrMessage( hMainWnd,(LPSTR)"SnmpStrToEntity - Dst",
   (int)SnmpGetLastError(hSession)) ;
   return (SNMPAPI_FAILURE);
}

if (SnmpGetTimeout(hDst,&nPolicyTimeout,&nActualTimeout)!=SNMPAPI_FAILURE)
    timer_interval =  nPolicyTimeout*10;
else
    timer_interval = TIMER_INTERVAL;

if (!(hSrc = SnmpStrToEntity(hSession, "MyApp")))
{
   NPWINSNMPErrMessage( hMainWnd,(LPSTR)"SnmpStrToEntity - Src",
   (int)SnmpGetLastError(hSession)) ;
   SnmpFreeEntity(hDst);
   return (SNMPAPI_FAILURE);
}
communityString.ptr = (smiLPBYTE)&gszCommStr;
communityString.len = lstrlen (gszCommStr);
hContext = SnmpStrToContext(hSession, &communityString);
if (hContext == (HSNMP_CONTEXT) NULL)
{
   NPWINSNMPErrMessage( hMainWnd,(LPSTR)"SnmpStrToContext",
   (int)SnmpGetLastError(hSession)) ;
   SnmpFreeEntity(hSrc);
   SnmpFreeEntity(hDst);
   return (SNMPAPI_FAILURE);
}
for (i=0; i <  nVars ; i++)
  {
   GetPrivateProfileString("MIB Variables",&gszOidInBuf[i],"SysDescr",
      (LPSTR)buf1, sizeof(buf1),"NP_WSNMP.INI");
   profilePtr = strtok (buf1, comma);                  // OID part
   status = SnmpStrToOid (profilePtr, &InputName[i]);
   if (status == SNMPAPI_FAILURE)
   {
      NPWINSNMPErrMessage( hMainWnd,(LPSTR)"SnmpStrToOid",
      (int)SnmpGetLastError(hSession)) ;
      SnmpFreeEntity(hSrc);
      SnmpFreeEntity(hDst);
      SnmpFreeContext(hContext);
      if (i > 0)
         SnmpFreeVbl(hVBL);
      for (j=0; j < i;j++)
      {
         SnmpFreeDescriptor (SNMP_SYNTAX_OID, (smiLPOPAQUE)&InputName[j]);
         SnmpFreeDescriptor (InputValue[j].syntax, &InputValue[j].value.string);
      }
      return (SNMPAPI_FAILURE);
   }

   profilePtr = strtok (NULL, comma);                 // syntax part
   // convert to SNMP_SYNTAX type
   InputValue[i].syntax = SNMP_SYNTAX_NULL;
   if (!(lstrcmpi(profilePtr, "c32")))
      InputValue[i].syntax = SNMP_SYNTAX_CNTR32;
   if (!(lstrcmpi(profilePtr, "ds")))
      InputValue[i].syntax = SNMP_SYNTAX_OCTETS;
   if (!(lstrcmpi(profilePtr, "int")))
      InputValue[i].syntax = SNMP_SYNTAX_INT;
   if (!(lstrcmpi(profilePtr, "oid")))
      InputValue[i].syntax = SNMP_SYNTAX_OID;
   if (!(lstrcmpi(profilePtr, "os")))
      InputValue[i].syntax = SNMP_SYNTAX_OCTETS;
   if (!(lstrcmpi(profilePtr, "tt")))
      InputValue[i].syntax = SNMP_SYNTAX_TIMETICKS;
   profilePtr = strtok (NULL, comma);                 // access part
   // compare to 'rw'
   if (lstrcmpi (profilePtr, "rw"))
   {
      MessageBox (hMainWnd, "No write access to this variable", "MIB Validation Failure", MB_OK);
      SnmpFreeEntity(hSrc);
      SnmpFreeEntity(hDst);
      SnmpFreeContext(hContext);
      if (i > 0)
         SnmpFreeVbl(hVBL);
      for (j=0; j < i;j++)
      {
            SnmpFreeDescriptor (SNMP_SYNTAX_OID, (smiLPOPAQUE)&InputName[j]);
            SnmpFreeDescriptor (InputValue[j].syntax, &InputValue[j].value.string);
      }
      return (SNMPAPI_FAILURE);
   }
   profilePtr = strtok (NULL, comma);                 // status part
   // probably doesn't matter here
   InputValue[i].value.uNumber = 0;
   NPWSNMPStrToValue (gszOidOutBuf[i], &InputValue[i]);
   if (i==0)
   {
      hVBL = SnmpCreateVbl(hSession,&InputName[i],&InputValue[i]);
      if (hVBL == SNMPAPI_FAILURE)
      {
         NPWINSNMPErrMessage( hMainWnd,(LPSTR)"SnmpCreateVbl",
         (int)SnmpGetLastError(hSession)) ;
         SnmpFreeEntity(hSrc);
         SnmpFreeEntity(hDst);
         SnmpFreeContext(hContext);
         return (SNMPAPI_FAILURE);
      }
    }
    else
   {
       status = SnmpSetVb (hVBL, i+1, &InputName[i],&InputValue[i]);
      if (status == SNMPAPI_FAILURE)
      {
         NPWINSNMPErrMessage( hMainWnd,(LPSTR)"SnmpSetVb",
         (int)SnmpGetLastError(hSession)) ;
         SnmpFreeEntity(hSrc);
         SnmpFreeEntity(hDst);
         SnmpFreeContext(hContext);
         SnmpFreeVbl(hVBL);
         for (j=0; j <  i ; j++)
         {
            SnmpFreeDescriptor (SNMP_SYNTAX_OID, (smiLPOPAQUE)&InputName[j]);
            SnmpFreeDescriptor (InputValue[j].syntax, &InputValue[j].value.string);
         }
         return (SNMPAPI_FAILURE);
      }
   }
    
  }//nVars
hPDU = SnmpCreatePdu(hSession, SNMP_PDU_SET, 999, 0, 0, hVBL);
if (hPDU == SNMPAPI_FAILURE)
{
   NPWINSNMPErrMessage( hMainWnd,(LPSTR)"SnmpCreatePdu",
   (int)SnmpGetLastError(hSession)) ;
   SnmpFreeEntity(hSrc);
   SnmpFreeEntity(hDst);
   SnmpFreeContext(hContext);
   SnmpFreeVbl(hVBL);
   for (i=0; i <  nVars ; i++)
   {
      SnmpFreeDescriptor (SNMP_SYNTAX_OID, (smiLPOPAQUE)&InputName[i]);
      SnmpFreeDescriptor (InputValue[i].syntax, &InputValue[i].value.string);
   }
   return (SNMPAPI_FAILURE);
}

status = SnmpSendMsg(hSession,hSrc,hDst,hContext,hPDU);
if (status == SNMPAPI_FAILURE)
{ 
   NPWINSNMPErrMessage( hMainWnd,(LPSTR)"SnmpSendMsg",
   (int)SnmpGetLastError(hSession)) ;
   SnmpFreeEntity(hSrc);
   SnmpFreeEntity(hDst);
   SnmpFreeContext(hContext);
   SnmpFreePdu(hPDU);
   SnmpFreeVbl(hVBL);
   for (i=0; i <  nVars ; i++)
   {
      SnmpFreeDescriptor (SNMP_SYNTAX_OID, (smiLPOPAQUE)&InputName[i]);
      SnmpFreeDescriptor (InputValue[i].syntax, &InputValue[i].value.string);
   }
   return (SNMPAPI_FAILURE);
}
else
     if (!SetTimer (hMainWnd, TIMER_ID, (UINT)timer_interval, NULL))
        MessageBox (hMainWnd, "SetTimer"," Error", MB_OK);
      else
       fTimer = TRUE;

// Free resources
SnmpFreeEntity(hSrc);
SnmpFreeEntity(hDst);
SnmpFreeContext(hContext);
SnmpFreePdu(hPDU);
SnmpFreeVbl(hVBL);
for (i=0; i <  nVars ; i++)
 {
   SnmpFreeDescriptor (SNMP_SYNTAX_OID, (smiLPOPAQUE)&InputName[i]);
      SnmpFreeDescriptor (InputValue[i].syntax, &InputValue[i].value.string);
 }
return SNMPAPI_SUCCESS;
} // OutProcessPDU

// BobN 11/4/94
// Converts a string to a varbind value
SNMPAPI_STATUS NPWSNMPStrToValue (LPSTR lpString, smiLPVALUE Value)
{
smiUINT32 strLen;
if ((!lpString) || (!Value)) return (0);
strLen = lstrlen (lpString);
switch (Value->syntax)
   {
   case SNMP_SYNTAX_INT:
   Value->value.sNumber = atol (lpString);
   break;

   case SNMP_SYNTAX_UINT32:
   case SNMP_SYNTAX_CNTR32:
   case SNMP_SYNTAX_GAUGE32:
   case SNMP_SYNTAX_TIMETICKS:
   Value->value.uNumber = atol (lpString);
   break;

   case SNMP_SYNTAX_CNTR64:
//   Value->value.hNumber =
   break;

   case SNMP_SYNTAX_OCTETS:
   case SNMP_SYNTAX_BITS:
   case SNMP_SYNTAX_OPAQUE:
   Value->value.string.len = max (strLen, 1);
   Value->value.string.ptr = GlobalAllocPtr (GHND, Value->value.string.len);
   lstrcpy (Value->value.string.ptr, lpString);
   break;

   case SNMP_SYNTAX_IPADDR:
   case SNMP_SYNTAX_NSAPADDR:
   // missing in action...BobN 11/4/94
   break;

   case SNMP_SYNTAX_OID:
   SnmpStrToOid (lpString, &Value->value.oid);
   break;

   case SNMP_SYNTAX_NULL:
   Value->value.empty = 0;
   break;
   } // switch
return (SNMPAPI_SUCCESS);
}  // NPWSNMPStrToValue
