// NP_POLL.C     
// #includes and #defines
#include "np_poll.h"
#include <windowsx.h>
#include <stdlib.h>
#include <string.h>
#include <ctl3d.h>

#define WM_SNMPMSG WM_USER + 100
#define MAXVARS 5
#define FREQUENCY_TIMER_ID  1     // Default Polling Timer ID
#define FREQUENCY  8000  // # of ms between two consecutive polls.

// Local and Extern Variables
HANDLE hInst;
HANDLE hMainWnd;
LPSTR szAppName = "NP_POLL";
HWND hDialog, hwndButton;
BOOL fOidOutFlag = FALSE;
//BOOL fTimer = FALSE;
char gszOidOutBuf[MAXVARS][256];
char gszOidInBuf[MAXVARS][256];
char gszCommStr[256];
char gszNetAddrBuf[64];
char display_buffer[256];
LRESULT cCurrentEntity;
LRESULT cCurrentContext;
LRESULT cCurrentOID[5] = {-1,-1,-1,-1,-1};
HSNMP_SESSION hSession;
LPSTR communityValue = "public";
smiOCTETS communityString;
smiOCTETS outTest;
smiOID outName;
smiVALUE outValue[MAXVARS];
smiVALUE RetValue[MAXVARS];
smiUINT32  nVars;
smiINT32 SentReqId  = 0,
         RecvdReqId = 0;;

enum {Entity, Context, OID} focus;
enum {NotPolling, Polling } pollingButtonState;
char PollButtonText[2][6]={"Start","Stop"};
UINT frequency    = FREQUENCY;
UINT polling_count;
UINT reply_count;
HSNMP_ENTITY hDst;
HSNMP_ENTITY hSrc;
HSNMP_CONTEXT hContext;
HSNMP_VBL hVBL;
smiOID InputName[MAXVARS];
// Function Prototypes
SNMPAPI_STATUS ProcessPDU(void);
SNMPAPI_STATUS PollWinSNMP(void);
SNMPAPI_STATUS CleanPollWinSNMP(void);
SNMPAPI_STATUS PreparePollWinSNMP(void);
//void(SNMPAPI_CALL FAR *NPSNMPErrMessage)(HWND,int,int);

// WinMain
int PASCAL WinMain(
   HANDLE hInstance,     // current instance
   HANDLE hPrevInstance, // previous instance
   LPSTR lpCmdLine,      // command line
   int nCmdShow)         // show-window type (open/icon)
{
    MSG  msg;

   if (!hPrevInstance)
      if (!InitApplication(hInstance))
         return (FALSE);

   if (!InitInstance(hInstance, nCmdShow))
      return (FALSE);

   while (GetMessage(
      &msg,
      NULL,
      NULL,
      NULL))
   {
      TranslateMessage(&msg); // Translates virtual key codes
      DispatchMessage(&msg);  // Dispatches message to window
   }
   return (msg.wParam);       // Returns the value from PostQuitMessage
}  // WinMain

// InitApplication
BOOL InitApplication (HANDLE hInstance)
{
    WNDCLASS  wc;

// ctl3d registration
   Ctl3dRegister (hInstance);
   Ctl3dAutoSubclass (hInstance);

    wc.style = NULL;
    wc.lpfnWndProc = MainWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hbrBackground = (HBRUSH)(COLOR_BACKGROUND+1);
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_NP_POLL));
    wc.lpszMenuName =  szAppName;
    wc.lpszClassName = szAppName;

    return (RegisterClass(&wc));

} // InitApplication

// InitInstance
BOOL InitInstance (HANDLE hInstance, int nCmdShow)
{
HWND            hWnd;
SNMPAPI_STATUS status;
smiUINT32 nMajorV, nMinorV, nLevel, nTranslateMode, nReMode;

hInst = hInstance;

hWnd = CreateWindow (szAppName, szAppName, WS_OVERLAPPEDWINDOW,
                     CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
                     NULL, NULL, hInstance, NULL);
if (!hWnd)
   return (FALSE);

ShowWindow(hWnd, nCmdShow);
UpdateWindow(hWnd);
hMainWnd = hWnd;
status = SnmpStartup (&nMajorV, &nMinorV, &nLevel, &nTranslateMode, &nReMode);
if (nTranslateMode != SNMPAPI_UNTRANSLATED_V1)
   {
   status = SnmpSetTranslateMode(SNMPAPI_UNTRANSLATED_V1);
   if (status == SNMPAPI_FAILURE)
      NPWINSNMPErrMessage( hMainWnd,(LPSTR)"SnmpSetTranslateMode", (int)SnmpGetLastError(hSession)) ;
   }
lstrcpy (gszCommStr, communityValue);     
hSession = SnmpOpen (hWnd,WM_SNMPMSG);
return (TRUE); // Returns the value from PostQuitMessage
} // InitInstance
// MainWndProc
long CALLBACK __export
   MainWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
SNMPAPI_STATUS status;
UINT i;
char buf[8];
switch (message)
   {
   case WM_COMMAND:
      switch (wParam)
      {
      case IDM_ABOUT:
      NPAbout (hWnd, szAppName);
      break;
      
      case IDM_HELP_CONTENTS:
      WinHelp(hWnd, "NP_WSNMP.HLP", HELP_CONTENTS, 0L);
      break;
      
      case IDM_FILE_EXIT:
      SendMessage (hWnd, WM_CLOSE, 0, 0L);
      break;
                   
      case IDM_GETOID:
      focus = OID;
      DialogBox (hInst, "GETOID", hWnd, GetOid);
      break;
                  
      case IDM_PASSWD:
      focus = Context;
      DialogBox (hInst, "GETOID", hWnd, GetOid);
      break;
                  
      case IDM_IP:
      focus = Entity;
      DialogBox (hInst, "GETOID", hWnd, GetOid);
      break;
                  
      default:
      return (DefWindowProc (hWnd, message, wParam, lParam));
      }  // switch wParam
   break;

   case WM_SNMPMSG:

   status = ProcessPDU ();

   if ( status == SNMPAPI_FAILURE)
      {
//      wsprintf(display_buffer,"Status = %d\n", status);
//      MessageBox (hMainWnd, display_buffer, "ProcessPDU", MB_OK);

      KillTimer(hMainWnd,FREQUENCY_TIMER_ID);
      CleanPollWinSNMP();
      SendDlgItemMessage(hDialog,IDOK,WM_SETTEXT,0,
         (LPARAM)((LPSTR *)PollButtonText[0]));
      pollingButtonState = NotPolling;

      return TRUE;
      }

   nVars = min(status, MAXVARS);

   for (i = 0; i < nVars; i++)
   if  (RetValue[i].syntax == SNMP_SYNTAX_TIMETICKS)
   {
     /*Should be 26,13:30:15.0  format as RFC1443 suggests for dates*/ 
      unsigned long day = 24L*60L*60L*100L;
      unsigned long hour = 60L*60L*100L;
      unsigned long minute = 60L*100L;
      unsigned long hundred  = 100L;

     wsprintf(gszOidOutBuf[i],
         "%lu,%lu:%lu:%lu.%lu",
         RetValue[i].value.uNumber/day,
         (RetValue[i].value.uNumber%(day))/hour,
         ((RetValue[i].value.uNumber%(day))%hour)/minute,
         (((RetValue[i].value.uNumber%(day))%hour)%minute)/hundred,
         (((RetValue[i].value.uNumber%(day))%hour)%minute)%hundred);

   }
   else
         NPWSNMPValueToStr (&RetValue[i], sizeof(gszOidOutBuf[i]), gszOidOutBuf[i]);

   fOidOutFlag = TRUE;
   focus = OID;
   SendDlgItemMessage(hDialog,IDC_RETURNED_VALUE_1,WM_SETTEXT,0,(LPARAM)((LPSTR *)gszOidOutBuf[0]));
   SendDlgItemMessage(hDialog,IDC_RETURNED_VALUE_2,WM_SETTEXT,0,(LPARAM)((LPSTR *)gszOidOutBuf[1]));
   SendDlgItemMessage(hDialog,IDC_RETURNED_VALUE_3,WM_SETTEXT,0,(LPARAM)((LPSTR *)gszOidOutBuf[2]));
   SendDlgItemMessage(hDialog,IDC_RETURNED_VALUE_4,WM_SETTEXT,0,(LPARAM)((LPSTR *)gszOidOutBuf[3]));
   SendDlgItemMessage(hDialog,IDC_RETURNED_VALUE_5,WM_SETTEXT,0,(LPARAM)((LPSTR *)gszOidOutBuf[4]));
   fOidOutFlag = FALSE;
   for (i = 0; i < nVars; i++)
      SnmpFreeDescriptor (RetValue[i].syntax, &RetValue[i].value.string);

   SendDlgItemMessage(hDialog,IDC_REPLY_COUNT, WM_SETTEXT,0,
            (LPARAM)ultoa(++reply_count,(char *)buf,10));

   break;
        
   case WM_SYSCOLORCHANGE:
   // Ctl3d needs to know
     Ctl3dColorChange();
   break;
   case WM_TIMER:
       if (PollWinSNMP () != SNMPAPI_FAILURE)
         return (TRUE);
       
   break;
   case WM_DESTROY:
   // WinSNMP Cleanup
   KillTimer(hWnd,FREQUENCY_TIMER_ID);
   status = SnmpClose(hSession);
   if (status == SNMPAPI_FAILURE)
      {
      NPWINSNMPErrMessage( hMainWnd,(LPSTR)"SnmpClose", (int)SnmpGetLastError(hSession)) ;
      }
   status = SnmpCleanup();
   if (status == SNMPAPI_FAILURE)
      {
      NPWINSNMPErrMessage( hMainWnd,(LPSTR)"SnmpClose", (int)SnmpGetLastError(0)) ;
      }
   // Ctl3d cleanup
   Ctl3dUnregister (hInst);
   /* Windows cleanup */
   PostQuitMessage(0);
   break;

   default:                  /* Passes it on if unproccessed    */
   return (DefWindowProc(hWnd, message, wParam, lParam));
   }  // switch message

return (NULL);
} // MainWndProc

// GetOID
BOOL __export CALLBACK
   GetOid (HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
int i;
char buf[8];

switch (message)
{
   case WM_INITDIALOG:
   {
   NPWSNMPINISECTION sOStruct;
   NPWSNMPINISECTION sCStruct;
   NPWSNMPINISECTION sEStruct;
   hDialog = hDlg;

   switch (focus)
   {
      case Entity:
      SetFocus (GetDlgItem (hDlg, IDC_AGENT_ADDRESS));
      break;
      case Context:
      SetFocus (GetDlgItem (hDlg, IDC_COMMUNITY_STRING));
      break;
      case OID:
      SetFocus (GetDlgItem (hDlg, IDC_INPUT_OID_1));
      break;
   }
   /*Agent*/
   NPWSNMPGetIniSection ((LPCSTR)"Entities", &sEStruct);
   for (i=0; i<sEStruct.count; i++)
      SendDlgItemMessage (hDlg, IDC_AGENT_ADDRESS, CB_ADDSTRING, 0, (LPARAM) ((LPSTR)sEStruct.ptrs[i]));
   cCurrentEntity = SendDlgItemMessage(hDlg,IDC_AGENT_ADDRESS,CB_SETCURSEL,(WPARAM)cCurrentEntity, 0);
   GetDlgItemText (hDlg, IDC_AGENT_ADDRESS, gszNetAddrBuf, sizeof(gszNetAddrBuf));

   /*Community*/

   NPWSNMPGetIniSection ((LPCSTR)"Contexts", &sCStruct);
   for (i=0; i<sCStruct.count; i++)
      SendDlgItemMessage(hDlg, IDC_COMMUNITY_STRING, CB_ADDSTRING, 0, (LPARAM)((LPSTR)sCStruct.ptrs[i]));
   
   cCurrentContext = SendDlgItemMessage(hDlg,IDC_COMMUNITY_STRING,
      CB_SETCURSEL,(WPARAM)cCurrentContext, 0);

   /*OID*/
   NPWSNMPGetIniSection ((LPCSTR)"MIB Variables",&sOStruct);
   for (i=0; i<sOStruct.count; i++)
   {
      SendDlgItemMessage(hDlg, IDC_INPUT_OID_1, CB_ADDSTRING, 0, (LPARAM)((LPSTR)sOStruct.ptrs[i]));
      SendDlgItemMessage(hDlg, IDC_INPUT_OID_2, CB_ADDSTRING, 0, (LPARAM)((LPSTR)sOStruct.ptrs[i]));
      SendDlgItemMessage(hDlg, IDC_INPUT_OID_3, CB_ADDSTRING, 0, (LPARAM)((LPSTR)sOStruct.ptrs[i]));
      SendDlgItemMessage(hDlg, IDC_INPUT_OID_4, CB_ADDSTRING, 0, (LPARAM)((LPSTR)sOStruct.ptrs[i]));
      SendDlgItemMessage(hDlg, IDC_INPUT_OID_5, CB_ADDSTRING, 0, (LPARAM)((LPSTR)sOStruct.ptrs[i]));
   }
   if (fOidOutFlag == TRUE)
   {
       SetDlgItemText (hDlg, IDC_RETURNED_VALUE_1, gszOidOutBuf[0]);
       SetDlgItemText (hDlg, IDC_RETURNED_VALUE_2, gszOidOutBuf[1]);
       SetDlgItemText (hDlg, IDC_RETURNED_VALUE_3, gszOidOutBuf[2]);
       SetDlgItemText (hDlg, IDC_RETURNED_VALUE_4, gszOidOutBuf[3]);
       SetDlgItemText (hDlg, IDC_RETURNED_VALUE_5, gszOidOutBuf[4]);
   }
   if (cCurrentOID[0] >= 0)
      cCurrentOID[0] = SendDlgItemMessage(hDlg,IDC_INPUT_OID_1,CB_SETCURSEL,
         (WPARAM)cCurrentOID[0],0);
   if (cCurrentOID[1] >= 0)
      cCurrentOID[1] = SendDlgItemMessage(hDlg,IDC_INPUT_OID_2,CB_SETCURSEL,
         (WPARAM)cCurrentOID[1],0);
   if (cCurrentOID[2] >= 0)
      cCurrentOID[2] = SendDlgItemMessage(hDlg,IDC_INPUT_OID_3,CB_SETCURSEL,
         (WPARAM)cCurrentOID[2],0);
   if (cCurrentOID[3] >= 0)
      cCurrentOID[3] = SendDlgItemMessage(hDlg,IDC_INPUT_OID_4,CB_SETCURSEL,
         (WPARAM)cCurrentOID[3],0);
   if (cCurrentOID[4] >= 0)
      cCurrentOID[4] = SendDlgItemMessage(hDlg,IDC_INPUT_OID_5,CB_SETCURSEL,
         (WPARAM)cCurrentOID[4],0);
   
   SendDlgItemMessage(hDlg,IDC_FREQUENCY,WM_SETTEXT,0,
      (LPARAM)((LPSTR)ultoa(frequency/1000,(char *)buf,10)));

   SendDlgItemMessage(hDlg,IDC_POLLING_COUNT,WM_SETTEXT,0,
      (LPARAM)((LPSTR)"0"));

   SendDlgItemMessage(hDlg,IDC_REPLY_COUNT,WM_SETTEXT,0,
      (LPARAM)((LPSTR)"0"));

   return (FALSE);
   }
   case WM_COMMAND:
   switch (wParam)
   {
   DWORD dwIndex;
      case IDC_AGENT_ADDRESS:
         if (HIWORD(lParam) == CBN_SELCHANGE)
            if (pollingButtonState == Polling)
            {
               MessageBox(hMainWnd,"Stop Polling before changing Agent Address.",
                  "Polling", MB_OK);
               dwIndex = SendDlgItemMessage(hDlg, IDC_AGENT_ADDRESS,
                  CB_SETCURSEL,(WPARAM)cCurrentEntity, 0);
               return TRUE;
            }
      break;
      case IDC_COMMUNITY_STRING:
         if (HIWORD(lParam) == CBN_SELCHANGE)
            if (pollingButtonState == Polling)
            {
               MessageBox(hMainWnd,"Stop Polling before changing Community String.",
                  "Polling", MB_OK);
               dwIndex = SendDlgItemMessage(hDlg, IDC_COMMUNITY_STRING,
                  CB_SETCURSEL,(WPARAM)cCurrentContext, 0);
               return TRUE;
            }
      break;
      case IDC_INPUT_OID_1:
         if (HIWORD(lParam) == CBN_SELCHANGE)
            if (pollingButtonState == Polling)
            {
               MessageBox(hMainWnd,"Stop Polling before changing/adding OID.",
                  "Polling", MB_OK);
               dwIndex = SendDlgItemMessage(hDlg, IDC_INPUT_OID_1,
                  CB_SETCURSEL,(WPARAM)cCurrentOID[0], 0);
               return TRUE;
            }
         if (HIWORD(lParam) == CBN_EDITUPDATE)
            if (pollingButtonState == Polling)
            {
               MessageBox(hMainWnd,"Stop Polling before changing/deleting OID.",
                  "Polling", MB_OK);
               dwIndex = SendDlgItemMessage(hDlg, IDC_INPUT_OID_1,
                  CB_SETCURSEL,(WPARAM)cCurrentOID[0], 0);
               return TRUE;
            }
            else 
               cCurrentOID[0] = -1;
      break;
      case IDC_INPUT_OID_2:
         if (HIWORD(lParam) == CBN_SELCHANGE)
            if (pollingButtonState == Polling)
            {
               MessageBox(hMainWnd,"Stop Polling before changing/adding OID.",
                  "Polling", MB_OK);
               dwIndex = SendDlgItemMessage(hDlg, IDC_INPUT_OID_2,
                  CB_SETCURSEL,(WPARAM)cCurrentOID[1], 0);
               return TRUE;
            }
         if (HIWORD(lParam) == CBN_EDITUPDATE)
            if (pollingButtonState == Polling)
            {
               MessageBox(hMainWnd,"Stop Polling before changing/deleting OID.",
                  "Polling", MB_OK);
               dwIndex = SendDlgItemMessage(hDlg, IDC_INPUT_OID_2,
                  CB_SETCURSEL,(WPARAM)cCurrentOID[1], 0);
               return TRUE;
            }
            else 
               cCurrentOID[1] = -1;
      break;
      case IDC_INPUT_OID_3:
         if (HIWORD(lParam) == CBN_SELCHANGE)
            if (pollingButtonState == Polling)
            {
               MessageBox(hMainWnd,"Stop Polling before changing/adding OID.",
                  "Polling", MB_OK);
               dwIndex = SendDlgItemMessage(hDlg, IDC_INPUT_OID_3,
                  CB_SETCURSEL,(WPARAM)cCurrentOID[2], 0);
               return TRUE;
            }
         if (HIWORD(lParam) == CBN_EDITUPDATE)
            if (pollingButtonState == Polling)
            {
               MessageBox(hMainWnd,"Stop Polling before changing/deleting OID.",
                  "Polling", MB_OK);
               dwIndex = SendDlgItemMessage(hDlg, IDC_INPUT_OID_3,
                  CB_SETCURSEL,(WPARAM)cCurrentOID[2], 0);
               return TRUE;
            }
            else 
               cCurrentOID[2] = -1;
      break;
      case IDC_INPUT_OID_4:
         if (HIWORD(lParam) == CBN_SELCHANGE)
            if (pollingButtonState == Polling)
            {
               MessageBox(hMainWnd,"Stop Polling before changing/adding OID.",
                  "Polling", MB_OK);
               dwIndex = SendDlgItemMessage(hDlg, IDC_INPUT_OID_4,
                  CB_SETCURSEL,(WPARAM)cCurrentOID[3], 0);
               return TRUE;
            }
         if (HIWORD(lParam) == CBN_EDITUPDATE)
            if (pollingButtonState == Polling)
            {
               MessageBox(hMainWnd,"Stop Polling before changing/deleting OID.",
                  "Polling", MB_OK);
               dwIndex = SendDlgItemMessage(hDlg, IDC_INPUT_OID_4,
                  CB_SETCURSEL,(WPARAM)cCurrentOID[3], 0);
               return TRUE;
            }
            else 
               cCurrentOID[3] = -1;
      break;
      case IDC_INPUT_OID_5:
         if (HIWORD(lParam) == CBN_SELCHANGE)
            if (pollingButtonState == Polling)
            {
               MessageBox(hMainWnd,"Stop Polling before changing/adding OID.",
                  "Polling", MB_OK);
               dwIndex = SendDlgItemMessage(hDlg, IDC_INPUT_OID_5,
                  CB_SETCURSEL,(WPARAM)cCurrentOID[4], 0);
               return TRUE;
            }
         if (HIWORD(lParam) == CBN_EDITUPDATE)
            if (pollingButtonState == Polling)
            {
               MessageBox(hMainWnd,"Stop Polling before changing/deleting OID.",
                  "Polling", MB_OK);
               dwIndex = SendDlgItemMessage(hDlg, IDC_INPUT_OID_5,
                  CB_SETCURSEL,(WPARAM)cCurrentOID[4], 0);
               return TRUE;
            }
            else 
               cCurrentOID[4] = -1;
      break;
      case IDOK:
         if (pollingButtonState == NotPolling)
         {
         nVars  = 0;
   
         dwIndex = SendDlgItemMessage(hDlg,IDC_AGENT_ADDRESS,CB_GETCURSEL,0,0);
         if (dwIndex != CB_ERR)
            cCurrentEntity = dwIndex;
         GetDlgItemText (hDlg, IDC_AGENT_ADDRESS, gszNetAddrBuf,
            sizeof(gszNetAddrBuf));
   
         dwIndex = SendDlgItemMessage(hDlg, IDC_COMMUNITY_STRING,
            CB_GETCURSEL,0, 0);
         if (dwIndex != CB_ERR)
            cCurrentContext = dwIndex;
         GetDlgItemText (hDlg, IDC_COMMUNITY_STRING, gszCommStr,
            sizeof(gszCommStr));
   
         dwIndex = SendDlgItemMessage(hDlg, IDC_INPUT_OID_1, CB_GETCURSEL,0,0);
         if (dwIndex != CB_ERR)
         {
            cCurrentOID[0] = dwIndex;
            GetDlgItemText (hDlg, IDC_INPUT_OID_1, gszOidInBuf[0],
               sizeof(gszOidInBuf[0]));
            nVars++;
         }
         else
            cCurrentOID[0] = -1;     
   
         dwIndex = SendDlgItemMessage(hDlg, IDC_INPUT_OID_2, CB_GETCURSEL,0,0);
         if (dwIndex != CB_ERR)
         {
            cCurrentOID[1] = dwIndex;
            GetDlgItemText (hDlg, IDC_INPUT_OID_2, gszOidInBuf[1],
               sizeof(gszOidInBuf[1]));
            nVars++;
         }
         else
            cCurrentOID[1] = -1;     
   
         dwIndex = SendDlgItemMessage(hDlg, IDC_INPUT_OID_3, CB_GETCURSEL,0,
            0);
         if (dwIndex != CB_ERR)
         {
            cCurrentOID[2] = dwIndex;
            GetDlgItemText (hDlg, IDC_INPUT_OID_3, gszOidInBuf[2],
               sizeof(gszOidInBuf[2]));
            nVars++;
         }
         else
           cCurrentOID[2] = -1;     
   
         dwIndex = SendDlgItemMessage(hDlg, IDC_INPUT_OID_4, CB_GETCURSEL,0,0);
         if (dwIndex != CB_ERR)
         {
            cCurrentOID[3] = dwIndex;
            GetDlgItemText (hDlg, IDC_INPUT_OID_4, gszOidInBuf[3],
               sizeof(gszOidInBuf[3]));
            nVars++;
         }
         else
           cCurrentOID[3] = -1;     
   
         dwIndex = SendDlgItemMessage(hDlg, IDC_INPUT_OID_5, CB_GETCURSEL,0,0);
         if (dwIndex != CB_ERR)
         {
         cCurrentOID[4] = dwIndex;
         GetDlgItemText (hDlg, IDC_INPUT_OID_5, gszOidInBuf[4],
            sizeof(gszOidInBuf[4]));
         nVars++;
         }
         else
           cCurrentOID[4] = -1;     
   
         if (nVars == 0)
         {
            MessageBox (hMainWnd, "No Variables Chosen",
               "Please, Select At Least One Variable", MB_OK);
            return TRUE;
         }
   
         for (i=0; i< MAXVARS; i++)
            lstrcpy (gszOidOutBuf[i],"");
         SendDlgItemMessage(hDialog,IDC_RETURNED_VALUE_1,WM_SETTEXT,0,
            (LPARAM)((LPSTR *)gszOidOutBuf[0]));
         SendDlgItemMessage(hDialog,IDC_RETURNED_VALUE_2,WM_SETTEXT,0,
            (LPARAM)((LPSTR *)gszOidOutBuf[1]));
         SendDlgItemMessage(hDialog,IDC_RETURNED_VALUE_3,WM_SETTEXT,0,
            (LPARAM)((LPSTR *)gszOidOutBuf[2]));
         SendDlgItemMessage(hDialog,IDC_RETURNED_VALUE_4,WM_SETTEXT,0,
            (LPARAM)((LPSTR *)gszOidOutBuf[3]));
         SendDlgItemMessage(hDialog,IDC_RETURNED_VALUE_5,WM_SETTEXT,0,
            (LPARAM)((LPSTR *)gszOidOutBuf[4]));
   
   
         GetDlgItemText (hDlg, IDC_FREQUENCY, buf, sizeof(buf));
         if ( !(frequency = atoi (buf)*1000))
           frequency = FREQUENCY;
   
         if (!SetTimer (hMainWnd, FREQUENCY_TIMER_ID, frequency, NULL))
         {
           MessageBox (hMainWnd, "Set Frequency Timer"," Error", MB_OK);
           return SNMPAPI_FAILURE;
         }
   
         if ( PreparePollWinSNMP () != SNMPAPI_FAILURE)
            if (PollWinSNMP () != SNMPAPI_FAILURE)
            {
               SendDlgItemMessage(hDialog,IDOK,WM_SETTEXT,0,
                  (LPARAM)((LPSTR *)PollButtonText[1]));
               pollingButtonState = Polling;
            }
         else
         { 
          KillTimer(hMainWnd,FREQUENCY_TIMER_ID);
          CleanPollWinSNMP();
          SendDlgItemMessage(hDialog,IDOK,WM_SETTEXT,0,
            (LPARAM)((LPSTR *)PollButtonText[0]));
          pollingButtonState = NotPolling;
         }
       }
       else
         if (pollingButtonState == Polling)
         {
           KillTimer(hMainWnd,FREQUENCY_TIMER_ID);
            
           CleanPollWinSNMP();
           SendDlgItemMessage(hDialog,IDOK,WM_SETTEXT,0,
               (LPARAM)((LPSTR *)PollButtonText[0]));
           pollingButtonState = NotPolling;
         }
         
       return (TRUE);
   
       case IDCANCEL:
         if (pollingButtonState == Polling)
         {
           CleanPollWinSNMP();
           pollingButtonState = NotPolling;
         }
         fOidOutFlag = FALSE;
         KillTimer(hMainWnd,FREQUENCY_TIMER_ID);
         EndDialog(hDlg, TRUE);
         return (TRUE);
         }
      break;
   
      default:
      break;
   }
return (FALSE);
} // GetOid


SNMPAPI_STATUS ProcessPDU ()
{
   HSNMP_PDU hResponsePDU;
   HSNMP_VBL hResponseVBL;
   smiOID name;
   SNMPAPI_STATUS status;
   smiINT PduType,Err_stat,Err_index;
   smiUINT32 count, i, j;
   smiINT32 Request_id;
   status = SnmpRecvMsg(hSession, NULL, NULL, NULL, &hResponsePDU); 
   if (status == SNMPAPI_FAILURE)
   {
      KillTimer(hMainWnd,FREQUENCY_TIMER_ID);
      NPWINSNMPErrMessage( hMainWnd,(LPSTR)"SnmpRecvMsg", (int)SnmpGetLastError(hSession)) ;
      return  SNMPAPI_FAILURE;
   }
   status = SnmpGetPduData(hResponsePDU,&PduType,&Request_id,&Err_stat,
                 &Err_index,&hResponseVBL);
   if (status == SNMPAPI_FAILURE)
   {
      KillTimer(hMainWnd,FREQUENCY_TIMER_ID);
      NPWINSNMPErrMessage( hMainWnd,(LPSTR)"SnmpRecvMsg", (int)SnmpGetLastError(hSession)) ;
      SnmpFreePdu(hResponsePDU);
      return SNMPAPI_FAILURE;
   }
   if (PduType != SNMP_PDU_RESPONSE)
   {
      MessageBox (hMainWnd, "Received Pdu type is not a response one", "SNMP_ERROR", MB_OK);
      return  SNMPAPI_FAILURE;
   }
   if (Err_stat != SNMP_ERROR_NOERROR)
      {
      KillTimer(hMainWnd,FREQUENCY_TIMER_ID);
      NPSNMPErrMessage( hMainWnd, (int)Err_stat,  (int)Err_index) ;
      SnmpFreePdu(hResponsePDU);
      SnmpFreeVbl(hResponseVBL);
      return  SNMPAPI_FAILURE;
      }

   if (Request_id > RecvdReqId)
      RecvdReqId  = Request_id;
   else
      {
      // Do nothing
      SnmpFreePdu(hResponsePDU);
      return  SNMPAPI_FAILURE;
      }

   count = SnmpCountVbl(hResponseVBL);
   if (count == SNMPAPI_FAILURE)
      {
      KillTimer(hMainWnd,FREQUENCY_TIMER_ID);
      NPWINSNMPErrMessage( hMainWnd, (LPSTR)"SnmpCountVbl", (int)SnmpGetLastError(0)) ;
      SnmpFreePdu(hResponsePDU);
      SnmpFreeVbl(hResponseVBL);
      return  SNMPAPI_FAILURE;
      }
   for (i = 0; i < count; i++)
   {
      status = SnmpGetVb (hResponseVBL, i+1, &name, &(RetValue[i]));
      if (status == SNMPAPI_FAILURE)
         {
         KillTimer(hMainWnd,FREQUENCY_TIMER_ID);
         NPWINSNMPErrMessage( hMainWnd, (LPSTR)"SnmpCountVbl", (int)SnmpGetLastError(0)) ;
         SnmpFreePdu(hResponsePDU);
         SnmpFreeVbl(hResponseVBL);
         for (j = 0; j < i - 1; j++)
            SnmpFreeDescriptor (RetValue[j].syntax, &RetValue[j].value.string);

         return  SNMPAPI_FAILURE;
         }
      SnmpFreeDescriptor (SNMP_SYNTAX_OID, (smiLPOPAQUE)&name);
    }

   SnmpFreePdu(hResponsePDU);
   SnmpFreeVbl(hResponseVBL);
   return count;
} // ProcessPDU
SNMPAPI_STATUS PreparePollWinSNMP(void)
{
SNMPAPI_STATUS status;
smiVALUE InputValue;
char buf[MAXVARS][256], buf1[256];
LPSTR profilePtr;
UINT i;
LPSTR comma=",";

SnmpSetTranslateMode (SNMPAPI_TRANSLATED);

if (!(hDst = SnmpStrToEntity(hSession,gszNetAddrBuf)))
 {
   NPWINSNMPErrMessage( hMainWnd, (LPSTR)"SnmpStrToEntity(hDst)", (int)SnmpGetLastError(hSession)) ;
   return SNMPAPI_FAILURE;
 }

if (!(hSrc = SnmpStrToEntity(hSession, "MyApp")))
 {
   NPWINSNMPErrMessage( hMainWnd,(LPSTR)"SnmpStrToEntity(hSrc)", (int)SnmpGetLastError(hSession)) ;
   return SNMPAPI_FAILURE;
 }
communityString.ptr = (smiLPBYTE)&gszCommStr;
communityString.len = lstrlen (gszCommStr);
hContext = SnmpStrToContext(hSession, &communityString);
if (hContext == (HSNMP_CONTEXT) NULL)
   {
   NPWINSNMPErrMessage( hMainWnd,(LPSTR)"SnmpStrToContext", (int)SnmpGetLastError(hSession)) ;
   return SNMPAPI_FAILURE;
   }
for (i=0; i <  nVars ; i++)
  {
   GetPrivateProfileString("MIB Variables",gszOidInBuf[i],"1.3.6.1.2.1.1.1.0,",(LPSTR)buf1,
         sizeof(buf1),"NP_WSNMP.INI");
    
   profilePtr =  strtok (buf1, comma);
   lstrcpy((LPSTR)&buf[i], profilePtr);
   status = SnmpStrToOid ((LPSTR)&buf[i], &InputName[i]);
   InputValue.syntax = SNMP_SYNTAX_NULL;
   InputValue.value.empty = 0;
   if (i==0)
   {
   hVBL = SnmpCreateVbl(hSession,&InputName[0],&InputValue);
   if (hVBL == SNMPAPI_FAILURE)
      {
      NPWINSNMPErrMessage( hMainWnd,(LPSTR)"SnmpCreateVbl", (int)SnmpGetLastError(hSession)) ;
      return SNMPAPI_FAILURE;
      }
   }
   else
   {
    status = SnmpSetVb (hVBL, i+1, &InputName[i],&InputValue);
    if (status == SNMPAPI_FAILURE)
      {
      NPWINSNMPErrMessage( hMainWnd, (LPSTR)"SnmpSetVb",  (int)SnmpGetLastError(hSession)) ;
      return SNMPAPI_FAILURE;
      }
   }
  }
      
  polling_count = 0;
  reply_count = 0;
  SendDlgItemMessage(hDialog,IDC_POLLING_COUNT,WM_SETTEXT,0,
   (LPARAM)((LPSTR)"0"));

  SendDlgItemMessage(hDialog,IDC_REPLY_COUNT,WM_SETTEXT,0,
      (LPARAM)((LPSTR)"0"));

}
SNMPAPI_STATUS PollWinSNMP(void)
{
SNMPAPI_STATUS status;
HSNMP_PDU hPDU;
char buf[8];

hPDU = SnmpCreatePdu(hSession, SNMP_PDU_GET, ++SentReqId, 0, 0, hVBL);
if (hPDU == SNMPAPI_FAILURE)
   {
   KillTimer(hMainWnd,FREQUENCY_TIMER_ID);
   NPWINSNMPErrMessage( hMainWnd, (LPSTR)"SnmpCreatePdu",(int)SnmpGetLastError(hSession)) ;
   return SNMPAPI_FAILURE;
   }

status = SnmpSendMsg(hSession,hSrc,hDst,hContext,hPDU);
if (status == SNMPAPI_FAILURE)
   { 
   KillTimer(hMainWnd,FREQUENCY_TIMER_ID);
   NPWINSNMPErrMessage( hMainWnd, (LPSTR)"SnmpSendMsg",(int)SnmpGetLastError(hSession)) ;
   return SNMPAPI_FAILURE;
   }

   SendDlgItemMessage(hDialog,IDC_POLLING_COUNT, WM_SETTEXT,0,
            (LPARAM)ultoa(++polling_count,(char *)buf,10));

SnmpFreePdu(hPDU);

}
// Free resources
SNMPAPI_STATUS CleanPollWinSNMP(void)
{
UINT i;
SnmpFreeEntity(hSrc);
SnmpFreeEntity(hDst);
SnmpFreeContext(hContext);
SnmpFreeVbl(hVBL);
for (i=0; i <  nVars ; i++)
   SnmpFreeDescriptor (SNMP_SYNTAX_OID, (smiLPOPAQUE)&InputName[i]);
return SNMPAPI_SUCCESS;
} // CleanPollWinSNMP

