// NP_GET.C     
// #includes and #defines
#include "np_get.h"

#define WM_SNMPMSG WM_USER + 100
#define MAXVARS 5
#define TIMER_ID        1     // Default Timer ID
#define TIMER_INTERVAL  8000  // # of ms to wait for response.
// Format as per RFC1443
#define DAY       (24L*60L*60L*100L)
#define HOUR      (60L*60L*100L)
#define MINUTE    (60L*100L)
#define HUNDRED   (100L)

// Local and Extern Variables
HANDLE hInst;
LPSTR szAppName = "NP_GET";
HWND hWnd, hDialog;
BOOL fOidOutFlag = FALSE;
BOOL fTimer = FALSE;
BOOL fSetLog  = FALSE;                  // Log option disabled
UINT cntlID[MAXVARS]={IDC_RETURNED_VALUE_1, IDC_RETURNED_VALUE_2, IDC_RETURNED_VALUE_3,
                    IDC_RETURNED_VALUE_4, IDC_RETURNED_VALUE_5};
char gszOidOutBuf[1024];
char gszOidInBuf[MAXVARS][256];
char gszCommStr[256];
char gszNetAddrBuf[64];
char display_buffer[256];
LRESULT cCurrentEntity=0;
LRESULT cCurrentContext=0;
LRESULT cCurrentOID[MAXVARS] = {-1,-1,-1,-1,-1};
HSNMP_SESSION hSession;
LPSTR communityValue = "public";
smiOCTETS communityString;
smiVALUE RetValue[MAXVARS];
smiUINT32  nVars;
smiUINT32 timer_interval = TIMER_INTERVAL;
// Variables used for log file operations
HFILE hLogFile;
OPENFILENAME ofl;
char szLogFile[128] = "\0";
LPSTR szLogFilter = "NetPlus Log\0*.log\0";
LPCSTR szLogDefExt = "log";
int nRowLen;
char szDate[9];
char szTime[9];
//
enum {Entity, Context, OID} focus;
// Function Prototypes
SNMPAPI_STATUS ReceivePDU (void);
SNMPAPI_STATUS SendPDU (void);
BOOL SetLog (BOOL, HWND);

// WinMain
int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)         // show-window type (open/icon)
{
MSG  msg;
if (!hPrevInstance)
   if (!InitApplication(hInstance))
      return (FALSE);
if (!InitInstance(hInstance, nCmdShow))
   return (FALSE);
while (GetMessage(&msg, NULL, NULL, NULL))
   {
   TranslateMessage(&msg); // Translates virtual key codes
   DispatchMessage(&msg);  // Dispatches message to window
   }
return (msg.wParam);       // Returns the value from PostQuitMessage
} // WinMain

// InitApplication
BOOL InitApplication (HANDLE hInstance)
{
WNDCLASS  wc;
//  ctl3d registration
Ctl3dRegister (hInstance);
Ctl3dAutoSubclass (hInstance);
//
wc.style = NULL;
wc.lpfnWndProc = MainWndProc;
wc.cbClsExtra = wc.cbWndExtra = 0;
wc.hInstance = hInstance;
wc.hbrBackground = (HBRUSH)(COLOR_BACKGROUND+1);
wc.hCursor = LoadCursor(NULL, IDC_ARROW);
wc.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_NP_GET));
wc.lpszMenuName =  wc.lpszClassName = szAppName;
return (RegisterClass(&wc));
} // InitApplication

// InitInstance
BOOL InitInstance (HANDLE hInstance, int nCmdShow)
{
smiUINT32 nMajorV, nMinorV, nLevel, nTranslateMode, nReMode;
hInst = hInstance;
hWnd = CreateWindow (szAppName, szAppName, WS_OVERLAPPEDWINDOW,
                     CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
                     NULL, NULL, hInstance, NULL);
if (!hWnd)
   return (FALSE);
ShowWindow(hWnd, nCmdShow);
UpdateWindow(hWnd);
if (!SnmpStartup (&nMajorV, &nMinorV, &nLevel, &nTranslateMode, &nReMode))
   {
   NPWINSNMPErrMessage (hWnd,(LPSTR)"SnmpStartup", (int)SnmpGetLastError(0));
   return (SNMPAPI_FAILURE);
   }
if (!SnmpSetTranslateMode(SNMPAPI_UNTRANSLATED_V1))
   {
   NPWINSNMPErrMessage (hWnd,(LPSTR)"SnmpSetTranslateMode", (int)SnmpGetLastError(0));
   return (SNMPAPI_FAILURE);
   }
lstrcpy (gszCommStr, communityValue);     
if (!(hSession = SnmpOpen (hWnd, WM_SNMPMSG)))
   {
   NPWINSNMPErrMessage (hWnd,(LPSTR)"SnmpOpen", (int)SnmpGetLastError(0));
   return (SNMPAPI_FAILURE);
   }
   
// Need error check here!  BobN 1/3/95
return (TRUE); 
} // InitInstance

// MainWndProc
long CALLBACK __export
   MainWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
SNMPAPI_STATUS status;
UINT i;
switch (message)
   {
   case WM_COMMAND:
      switch (wParam)
      {
      case IDM_ABOUT:
      NPAbout (hWnd, szAppName);
      break;
      
      case IDM_HELP_CONTENTS:
      WinHelp (hWnd, "NP_WSNMP.HLP", HELP_CONTENTS, 0L);
      break;
      
      case IDM_FILE_EXIT:
      SendMessage (hWnd, WM_CLOSE, 0, 0L);
      break;
                      
      case IDM_GETOID:
      focus = OID;
      DialogBox (hInst, "GETOID", hWnd, GetOid);
      break;
                  
      case IDM_PASSWD:
      focus = Context;
      DialogBox (hInst, "GETOID", hWnd, GetOid);
      break;
                  
      case IDM_IP:
      focus = Entity;
      DialogBox (hInst, "GETOID", hWnd, GetOid);
      break;
      
      case IDM_FILE_LOG:
      if (!SetLog(!fSetLog, hWnd))
         {
         fSetLog = FALSE;
         }
      break;
                  
      default:
      return (DefWindowProc (hWnd, message, wParam, lParam));
      }  // switch wParam
   break;

   case WM_SNMPMSG:
   if (fTimer)
    {
    KillTimer (hWnd,TIMER_ID);
    fTimer = FALSE;
//    SendDlgItemMessage (hDialog, IDOK, BM_SETSTATE, 0, 0L); // Set Released
    }
//   else
//    return TRUE;

   if (!(status = ReceivePDU ()))
      return FALSE;
   if (fSetLog)
      {
      // Format Source Entity line
      nRowLen = wsprintf (display_buffer, "%s %s %s\r\n",
                          _strdate(szDate), _strtime(szTime), gszNetAddrBuf);
      _lwrite (hLogFile, display_buffer, nRowLen);
      }
   nVars = min(status, MAXVARS);
   fOidOutFlag = TRUE;
   focus = OID;
   for (i = 0; i < nVars; i++)
      {
      if  (RetValue[i].syntax == SNMP_SYNTAX_TIMETICKS)
         {
         wsprintf(gszOidOutBuf, "%lu,%lu:%lu:%lu.%lu",
         RetValue[i].value.uNumber/DAY,
         (RetValue[i].value.uNumber%(DAY))/HOUR,
         ((RetValue[i].value.uNumber%(DAY))%HOUR)/MINUTE,
         (((RetValue[i].value.uNumber%(DAY))%HOUR)%MINUTE)/HUNDRED,
         (((RetValue[i].value.uNumber%(DAY))%HOUR)%MINUTE)%HUNDRED);
         }
      else
         {
         NPWSNMPValueToStr (&RetValue[i], sizeof(gszOidOutBuf), gszOidOutBuf);
         }
      if (fSetLog)
         {
         nRowLen = wsprintf (display_buffer, "%-20.20s%-56.56s\r\n", gszOidInBuf[i], gszOidOutBuf);
         _lwrite (hLogFile, display_buffer, nRowLen);
         }
      SendDlgItemMessage(hDialog, cntlID[i], WM_SETTEXT, 0, (LPARAM)(LPSTR)gszOidOutBuf);
      SnmpFreeDescriptor (RetValue[i].syntax, &RetValue[i].value.string);
      }
   fOidOutFlag = FALSE;
   break;
        
   case WM_SYSCOLORCHANGE:
   // Ctl3d needs to know
   Ctl3dColorChange();
   break;

   case WM_TIMER:
   KillTimer (hWnd,TIMER_ID);
   fTimer = FALSE ;
//   SendDlgItemMessage (hDialog, IDOK, BM_SETSTATE, 0, 0L); // Set Relesed
   wsprintf(display_buffer,"No Response within %d seconds.", timer_interval/1000);
   MessageBox (hDialog, display_buffer, "TimeOut", MB_OK);
   break;
   
   case WM_DESTROY:
   // WinSNMP Cleanup
   if (fTimer)
      {
      KillTimer(hWnd,TIMER_ID);
      fTimer = FALSE ;
      }
   if (!SnmpClose(hSession))
      {
      NPWINSNMPErrMessage( hWnd,(LPSTR)"SnmpClose", (int)SnmpGetLastError(hSession));
      return (SNMPAPI_FAILURE);
      }
   if (!SnmpCleanup())
      {
      NPWINSNMPErrMessage( hWnd,(LPSTR)"SnmpCleanup", (int)SnmpGetLastError(0));
      return (SNMPAPI_FAILURE);
      }
   // Ctl3d cleanup
   Ctl3dUnregister (hInst);
   // Windows cleanup
   PostQuitMessage(0);
   break;

   case WM_INITMENU:
   CheckMenuItem (GetMenu(hWnd), IDM_FILE_LOG, (fSetLog ? MF_CHECKED : MF_UNCHECKED));
   break;

   default:
   return (DefWindowProc(hWnd, message, wParam, lParam));
   }  // switch message

return (NULL);
} // MainWndProc

BOOL SetLog (BOOL fSetLogT, HWND hWnd)
{
char szExplanation[] = "NP_GET Log\r\n";
fSetLog = fSetLogT;
if (!fSetLog)
   return FALSE;
// Initialize the OPENFILENAME members
memset(&ofl, 0, sizeof(OPENFILENAME));
szLogFile[0] = '\0';
ofl.lStructSize = sizeof(OPENFILENAME);
ofl.hwndOwner = hWnd;
ofl.lpstrFilter = szLogFilter;
ofl.lpstrFile= szLogFile;
ofl.nMaxFile = sizeof(szLogFile);
ofl.lpstrDefExt = szLogDefExt;
ofl.Flags = OFN_SHOWHELP | OFN_OVERWRITEPROMPT;
if (GetSaveFileName(&ofl))
   {
   hLogFile = _lcreat (szLogFile, 0);
   _lwrite (hLogFile, szExplanation, lstrlen (szExplanation));
   return TRUE;
   }                                
else
   {
//   _lclose (hLogFile); I don't think so!  BobN 1/6/95
   return FALSE;
   }
}

// GetOid
BOOL __export CALLBACK
   GetOid (HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
int i;
switch (message)
   {
   case WM_INITDIALOG:
      {
      NPWSNMPINISECTION sOStruct;
      NPWSNMPINISECTION sCStruct;
      NPWSNMPINISECTION sEStruct;
      hDialog = hDlg;
      CheckDlgButton (hDlg, IDC_GET_LOG, (int)fSetLog);
      switch (focus)
         {
         case Entity:
         SetFocus (GetDlgItem (hDlg, IDC_AGENT_ADDRESS));
         break;
         
         case Context:
         SetFocus (GetDlgItem (hDlg, IDC_COMMUNITY_STRING));
         break;
         
         case OID:
         SetFocus (GetDlgItem (hDlg, IDC_INPUT_OID_1));
         break;
         }
      /*Agent*/
      NPWSNMPGetIniSection ((LPCSTR)"Entities", &sEStruct);
      for (i=0; i<sEStruct.count; i++)
         SendDlgItemMessage (hDlg, IDC_AGENT_ADDRESS, CB_ADDSTRING, 0, (LPARAM)(LPSTR)sEStruct.ptrs[i]);
      cCurrentEntity = SendDlgItemMessage(hDlg,IDC_AGENT_ADDRESS,CB_SETCURSEL,(WPARAM)cCurrentEntity, 0);
      /*Community*/
      NPWSNMPGetIniSection ((LPCSTR)"Contexts", &sCStruct);
      for (i=0; i<sCStruct.count; i++)
         SendDlgItemMessage(hDlg, IDC_COMMUNITY_STRING, CB_ADDSTRING, 0, (LPARAM)(LPSTR)sCStruct.ptrs[i]);
      cCurrentContext = SendDlgItemMessage(hDlg,IDC_COMMUNITY_STRING,CB_SETCURSEL,(WPARAM)cCurrentContext, 0);
      /*OID*/
      NPWSNMPGetIniSection ((LPCSTR)"MIB Variables",&sOStruct);
      for (i=0; i<sOStruct.count; i++)
         {
         SendDlgItemMessage(hDlg, IDC_INPUT_OID_1, CB_ADDSTRING, 0, (LPARAM)(LPSTR)sOStruct.ptrs[i]);
         SendDlgItemMessage(hDlg, IDC_INPUT_OID_2, CB_ADDSTRING, 0, (LPARAM)(LPSTR)sOStruct.ptrs[i]);
         SendDlgItemMessage(hDlg, IDC_INPUT_OID_3, CB_ADDSTRING, 0, (LPARAM)(LPSTR)sOStruct.ptrs[i]);
         SendDlgItemMessage(hDlg, IDC_INPUT_OID_4, CB_ADDSTRING, 0, (LPARAM)(LPSTR)sOStruct.ptrs[i]);
         SendDlgItemMessage(hDlg, IDC_INPUT_OID_5, CB_ADDSTRING, 0, (LPARAM)(LPSTR)sOStruct.ptrs[i]);
         }
      if (cCurrentOID[0] >= 0)
      cCurrentOID[0] = SendDlgItemMessage(hDlg,IDC_INPUT_OID_1,CB_SETCURSEL,(WPARAM)cCurrentOID[0],0);
      if (cCurrentOID[1] >= 0)
      cCurrentOID[1] = SendDlgItemMessage(hDlg,IDC_INPUT_OID_2,CB_SETCURSEL,(WPARAM)cCurrentOID[1],0);
      if (cCurrentOID[2] >= 0)
      cCurrentOID[2] = SendDlgItemMessage(hDlg,IDC_INPUT_OID_3,CB_SETCURSEL,(WPARAM)cCurrentOID[2],0);
      if (cCurrentOID[3] >= 0)
      cCurrentOID[3] = SendDlgItemMessage(hDlg,IDC_INPUT_OID_4,CB_SETCURSEL,(WPARAM)cCurrentOID[3],0);
      if (cCurrentOID[4] >= 0)
      cCurrentOID[4] = SendDlgItemMessage(hDlg,IDC_INPUT_OID_5,CB_SETCURSEL,(WPARAM)cCurrentOID[4],0);
      return (FALSE);
      }
   break;
   
   case WM_COMMAND:
   switch (wParam)
      {
      DWORD dwIndex;
      case IDC_GET_LOG:
         if (!SetLog(!fSetLog, hDlg))
         {
         fSetLog = FALSE;
         CheckDlgButton(hDlg, IDC_GET_LOG, 0);
         }
      break;

      case IDOK:
      if (fTimer)
         return FALSE;
//      SendDlgItemMessage (hDlg, IDOK, BM_SETSTATE, 1, 0L); // Set Depressed
      nVars = 0;
      dwIndex = SendDlgItemMessage(hDlg, IDC_AGENT_ADDRESS, CB_GETCURSEL,0, 0);
      if (dwIndex != CB_ERR)
         cCurrentEntity = dwIndex;
      GetDlgItemText (hDlg, IDC_AGENT_ADDRESS, gszNetAddrBuf, sizeof(gszNetAddrBuf));
      dwIndex = SendDlgItemMessage(hDlg, IDC_COMMUNITY_STRING, CB_GETCURSEL,0, 0);
      if (dwIndex != CB_ERR)
         cCurrentContext = dwIndex;
      GetDlgItemText (hDlg, IDC_COMMUNITY_STRING, gszCommStr, sizeof(gszCommStr));
      dwIndex = SendDlgItemMessage(hDlg, IDC_INPUT_OID_1, CB_GETCURSEL,0, 0);
      if (dwIndex != CB_ERR)
         {
         cCurrentOID[0] = dwIndex;
         GetDlgItemText (hDlg, IDC_INPUT_OID_1, gszOidInBuf[0], sizeof(gszOidInBuf[0]));
         nVars++;
         }
      else
         cCurrentOID[0] = -1;     
       dwIndex = SendDlgItemMessage(hDlg, IDC_INPUT_OID_2, CB_GETCURSEL,0, 0);
      if (dwIndex != CB_ERR)
         {
         cCurrentOID[1] = dwIndex;
         GetDlgItemText (hDlg, IDC_INPUT_OID_2, gszOidInBuf[1], sizeof(gszOidInBuf[1]));
         nVars++;
         }
      else
         cCurrentOID[1] = -1;     
      dwIndex = SendDlgItemMessage(hDlg, IDC_INPUT_OID_3, CB_GETCURSEL,0, 0);
      if (dwIndex != CB_ERR)
         {
         cCurrentOID[2] = dwIndex;
         GetDlgItemText (hDlg, IDC_INPUT_OID_3, gszOidInBuf[2], sizeof(gszOidInBuf[2]));
         nVars++;
         }
      else
         cCurrentOID[2] = -1;     
      dwIndex = SendDlgItemMessage(hDlg, IDC_INPUT_OID_4, CB_GETCURSEL,0, 0);
      if (dwIndex != CB_ERR)
         {
         cCurrentOID[3] = dwIndex;
         GetDlgItemText (hDlg, IDC_INPUT_OID_4, gszOidInBuf[3], sizeof(gszOidInBuf[3]));
         nVars++;
         }
      else
         cCurrentOID[3] = -1;     
      dwIndex = SendDlgItemMessage(hDlg, IDC_INPUT_OID_5, CB_GETCURSEL,0, 0);
      if (dwIndex != CB_ERR)
         {
         cCurrentOID[4] = dwIndex;
         GetDlgItemText (hDlg, IDC_INPUT_OID_5, gszOidInBuf[4], sizeof(gszOidInBuf[4]));
         nVars++;
         }
      else
         cCurrentOID[4] = -1;     
      if (nVars == 0)
         {
         MessageBox (0, "No variables chosen", "NOOP", MB_OK);
         return TRUE;
         }

      for (i=0; i< MAXVARS; i++)
         {
         SendDlgItemMessage(hDlg, cntlID[i], EM_SETSEL, 0, MAKELONG(0, -1));
         SendDlgItemMessage(hDlg, cntlID[i], WM_CLEAR, 0, 0);
         }

      if (!SendPDU())
         {
         fOidOutFlag = FALSE;
//         SendDlgItemMessage (hDlg, IDOK, BM_SETSTATE, 0, 0L); // Set Released
         if (fTimer)
            {
            KillTimer(hWnd,TIMER_ID);
            fTimer = FALSE;
            }
         }
      return (TRUE);

      case IDCANCEL:
      fOidOutFlag = FALSE;
      EndDialog(hDlg, TRUE);
      return (TRUE);
      }
   break;

   default:
   break;
   }
return (FALSE);
} // GetOid

SNMPAPI_STATUS ReceivePDU ()
{
   HSNMP_PDU hPDU;
   HSNMP_VBL hVBL;
   smiOID name;
   SNMPAPI_STATUS status;
   smiINT PduType,Err_stat,Err_index;
   smiINT32 Request_id;
   smiUINT32 count, i, j;

   status = SnmpRecvMsg(hSession, NULL, NULL, NULL, &hPDU); 
   if (status == SNMPAPI_FAILURE) 
        {
           NPWINSNMPErrMessage( hWnd,(LPSTR)"SnmpRecvMsg",
           (int)SnmpGetLastError(hSession)) ;
                return (SNMPAPI_FAILURE);
   }

   status = SnmpGetPduData(hPDU,&PduType,&Request_id,&Err_stat,
                 &Err_index,&hVBL);
   if (status == SNMPAPI_FAILURE)
   {
           NPWINSNMPErrMessage( hWnd,(LPSTR)"SnmpGetPduData",
           (int)SnmpGetLastError(hSession)) ;
           SnmpFreePdu(hPDU);
                return (SNMPAPI_FAILURE);
   }
   if (PduType != SNMP_PDU_RESPONSE)
      MessageBox (hWnd, "Pdu type not response", "SNMP_ERROR", MB_OK);
   if (Err_stat != SNMP_ERROR_NOERROR)
   {
      NPSNMPErrMessage( hWnd, (int)Err_stat,  (int)Err_index) ;
      SnmpFreePdu(hPDU);
      SnmpFreeVbl(hVBL);// Just in case.
      return  SNMPAPI_FAILURE;
   }
   count = SnmpCountVbl(hVBL);
   if (count == SNMPAPI_FAILURE)
        {
           NPWINSNMPErrMessage( hWnd,(LPSTR)"SnmpCountVbl",
           (int)SnmpGetLastError(hSession)) ;
           SnmpFreePdu(hPDU);
           SnmpFreeVbl(hVBL);
                return (SNMPAPI_FAILURE);
   }
   for (i = 0; i < count; i++)
   {
      status = SnmpGetVb (hVBL, i+1, &name, &(RetValue[i]));
      if (status == SNMPAPI_FAILURE)
                {
                   NPWINSNMPErrMessage( hWnd,(LPSTR)"SnmpGetVb",
                   (int)SnmpGetLastError(hSession)) ;
                   SnmpFreePdu(hPDU);
                   SnmpFreeVbl(hVBL);
                        for(j=0;j < i; j++)
                           SnmpFreeDescriptor (RetValue[j].syntax, &RetValue[j].value.string);
                        return (SNMPAPI_FAILURE);
                }
   SnmpFreeDescriptor (SNMP_SYNTAX_OID, (smiLPOPAQUE)&name);
    }
   SnmpFreePdu(hPDU);
   SnmpFreeVbl(hVBL);
   return count;
} // ReceivePDU

SNMPAPI_STATUS SendPDU (void)
{
SNMPAPI_STATUS status;
HSNMP_ENTITY hDst,hSrc;
HSNMP_CONTEXT hContext;
HSNMP_PDU hPDU;
HSNMP_VBL hVBL = 0;
smiVALUE InputValue;
smiOID InputName[MAXVARS];
smiTIMETICKS   nActualTimeout = 0,
               nPolicyTimeout = 0;
char buf1[256];
LPSTR profilePtr;
UINT i, j;
LPSTR comma=",";
status = SnmpSetTranslateMode (SNMPAPI_TRANSLATED);
if (!(hDst = SnmpStrToEntity(hSession,gszNetAddrBuf)))
   {
   NPWINSNMPErrMessage( hWnd,(LPSTR)"SnmpStrToEntity - Dst",
   (int)SnmpGetLastError(hSession)) ;
        return (SNMPAPI_FAILURE);
   }

if (SnmpGetTimeout(hDst,&nPolicyTimeout,&nActualTimeout)!=SNMPAPI_FAILURE)
    timer_interval =  nPolicyTimeout*10;
else
    timer_interval = TIMER_INTERVAL;

if (!(hSrc = SnmpStrToEntity(hSession, "MyApp")))
   {
   NPWINSNMPErrMessage( hWnd,(LPSTR)"SnmpStrToEntity - Src",
   (int)SnmpGetLastError(hSession)) ;
        SnmpFreeEntity(hDst);
        return (SNMPAPI_FAILURE);
   }

communityString.ptr = (smiLPBYTE)&gszCommStr;
communityString.len = lstrlen (gszCommStr);
hContext = SnmpStrToContext(hSession, &communityString);
if (hContext == (HSNMP_CONTEXT) NULL)
   {
   NPWINSNMPErrMessage( hWnd,(LPSTR)"SnmpStrToContext",
   (int)SnmpGetLastError(hSession)) ;
        SnmpFreeEntity(hSrc);
        SnmpFreeEntity(hDst);
        return (SNMPAPI_FAILURE);
   }
for (i=0; i < nVars; i++)
   {
   GetPrivateProfileString("MIB Variables",gszOidInBuf[i],"1.3.6.1.2.1.1.1.0,",
                           buf1, sizeof(buf1), "NP_WSNMP.INI");
   profilePtr =  strtok (buf1, comma);
   // Both of the above calls need return value error checking
   if (!(SnmpStrToOid (profilePtr, &InputName[i])))
      {
      NPWINSNMPErrMessage (hWnd, (LPSTR)"SnmpStrToOid", (int)SnmpGetLastError(hSession));
      SnmpFreeEntity(hSrc);
      SnmpFreeEntity(hDst);
      SnmpFreeContext(hContext);
      if (i > 0)
         SnmpFreeVbl(hVBL);
      for (j=0; j < i; j++)
         SnmpFreeDescriptor (SNMP_SYNTAX_OID, (smiLPOPAQUE)&InputName[j]);
      return (SNMPAPI_FAILURE);
      }
   InputValue.syntax = SNMP_SYNTAX_NULL;
   InputValue.value.empty = 0;
   if (i==0)
      {
      hVBL = SnmpCreateVbl (hSession,&InputName[i],&InputValue);
      if (hVBL == SNMPAPI_FAILURE)
         {
         NPWINSNMPErrMessage (hWnd, (LPSTR)"SnmpCreateVbl", (int)SnmpGetLastError(hSession));
         SnmpFreeEntity(hSrc);
         SnmpFreeEntity(hDst);
         SnmpFreeContext(hContext);
         return (SNMPAPI_FAILURE);
         }
      }
   else
      {
      if (!(SnmpSetVb (hVBL, i+1, &InputName[i],&InputValue)))
         {
         NPWINSNMPErrMessage (hWnd, (LPSTR)"SnmpSetVb", (int)SnmpGetLastError(hSession));
         SnmpFreeEntity(hSrc);
         SnmpFreeEntity(hDst);
         SnmpFreeContext(hContext);
         SnmpFreeVbl(hVBL);
         for (j=0; j <  i; j++)
            SnmpFreeDescriptor (SNMP_SYNTAX_OID, (smiLPOPAQUE)&InputName[j]);
         return (SNMPAPI_FAILURE);
         }
      }
   } // end of for loop for varbindlist populaton
hPDU = SnmpCreatePdu(hSession, SNMP_PDU_GET, 999, 0, 0, hVBL);
if (hPDU == SNMPAPI_FAILURE)
   {
   NPWINSNMPErrMessage (hWnd, (LPSTR)"SnmpCreatePdu", (int)SnmpGetLastError(hSession));
   SnmpFreeEntity(hSrc);
   SnmpFreeEntity(hDst);
   SnmpFreeContext(hContext);
   SnmpFreeVbl(hVBL);
   for (i=0; i < nVars; i++)
      SnmpFreeDescriptor (SNMP_SYNTAX_OID, (smiLPOPAQUE)&InputName[i]);
   return (SNMPAPI_FAILURE);
   }
if (!(SnmpSendMsg(hSession,hSrc,hDst,hContext,hPDU)))
   { 
   NPWINSNMPErrMessage (hWnd, (LPSTR)"SnmpSendMsg", (int)SnmpGetLastError(hSession));
   SnmpFreeEntity(hSrc);
   SnmpFreeEntity(hDst);
   SnmpFreeContext(hContext);
   SnmpFreePdu(hPDU);
   SnmpFreeVbl(hVBL);
   for (i=0; i < nVars; i++)
      SnmpFreeDescriptor (SNMP_SYNTAX_OID, (smiLPOPAQUE)&InputName[i]);
   return (SNMPAPI_FAILURE);
   }
else
   {
   if (!SetTimer (hWnd, TIMER_ID, (UINT)timer_interval, NULL))
      {
      MessageBox (hWnd, "SetTimer"," Error", MB_OK);
      return SNMPAPI_FAILURE;
      }
   else
      fTimer = TRUE;
   }
// Free resources
SnmpFreeEntity(hSrc);
SnmpFreeEntity(hDst);
SnmpFreeContext(hContext);
SnmpFreePdu(hPDU);
SnmpFreeVbl(hVBL);
for (i=0; i < nVars; i++)
   SnmpFreeDescriptor (SNMP_SYNTAX_OID, (smiLPOPAQUE)&InputName[i]);
return SNMPAPI_SUCCESS;
} // SendPDU

