// NP_ALERT.h

#include "winsnmp.h"
#include "resource.h"

// The NPWSNMPINISECTION strcutre is populated by the non-WinSNMP
// NPWSNMPGetIniSection function in NetPlus/WISP applications
typedef struct
   {
   int   count;
   int   bytes;
   long FAR *ptrs;
   char FAR *buffer;
   } NPWSNMPINISECTION, FAR *LPNPWSNMPINISECTION;
// external function prototypes
extern void SNMPAPI_CALL NPWSNMPGetIniSection (LPCSTR, LPNPWSNMPINISECTION);
extern SNMPAPI_STATUS SNMPAPI_CALL SnmpStrToIpAddress (LPCSTR, smiLPIPADDR);
extern SNMPAPI_STATUS SNMPAPI_CALL SnmpStrToOctets (LPCSTR, smiLPOCTETS);
extern SNMPAPI_STATUS SNMPAPI_CALL NPWSNMPSetV1TrapPduData (HSNMP_PDU PDU,
                                                            smiLPOID enterprise,
                                                            smiLPIPADDR agent_addr,
                                                            smiLPINT generic_trap,
                                                            smiLPINT specific_trap,
                                                            smiLPTIMETICKS time_ticks);

extern BOOL CALLBACK NPAbout (HWND, LPSTR);
// local function prototypes
int PASCAL WinMain (HANDLE, HANDLE, LPSTR, int);
BOOL InitApplication (HANDLE);
BOOL InitInstance (HANDLE, int);
long __export CALLBACK MainWndProc (HWND, UINT, WPARAM, LPARAM);
BOOL __export CALLBACK doGetPdu (HWND, unsigned, WORD, LONG);
