// NP_ALERT.c
#include "np_alert.h" 
#include <stdlib.h>
#include <ctl3d.h>
#define WM_SNMPMSG WM_USER + 1
SNMPAPI_STATUS NPALERTSnmpSendMsg (void);
//
LPSTR szAppName = "NP_ALERT";
HINSTANCE hInst;
HWND hMainWnd;
SNMPAPI_STATUS snmpErr;
HSNMP_SESSION hSession;
HSNMP_ENTITY hSrc, hDst;
HSNMP_CONTEXT hCtx;
HSNMP_PDU hPdu;
HSNMP_VBL hVbl;
smiIPADDR dAgent_Addr;
smiOCTETS dContext;
smiOID dEnterprise;
smiVALUE dTrapText;
smiINT lGeneric, lSpecific, lTimeStamp;
char display_buffer[256];
BOOL bReady = FALSE;
// "Build" dialog box variables
LPSTR pIni = "np_wsnmp.ini";
LPSTR pDefs = "default_values";
LPSTR pAlarms = "pbx_alarms";
char szCommStr[64];
char szEnterprise[64];
char szTimeStamp[16];
char szAgentAddr[16];
char szGeneric[2];
char szSpecific[16];
char szTrapText[256];
char szMgrAddr[16];
// 
// WinMain
int PASCAL WinMain (HANDLE hInstance,     // current instance
                    HANDLE hPrevInstance, // previous instance
                    LPSTR lpCmdLine,      // command line
                    int nCmdShow)         // show-window type (open/icon)
{
MSG  msg;
if (!hPrevInstance)
   if (!InitApplication(hInstance))
      return (FALSE);
if (!InitInstance(hInstance, nCmdShow))
   return (FALSE);
while (GetMessage (&msg, NULL, NULL, NULL))
   {
   TranslateMessage(&msg); // Translates virtual key codes
   DispatchMessage(&msg);  // Dispatches message to window
   }
return (msg.wParam);       // Returns the value from PostQuitMessage
} // WinMain
// InitApplication
BOOL InitApplication (HANDLE hInstance)
{
WNDCLASS  wc;
// ctl3d registration
Ctl3dRegister (hInstance);
Ctl3dAutoSubclass (hInstance);

wc.style = NULL;
wc.lpfnWndProc = MainWndProc;
wc.cbClsExtra = 0;
wc.cbWndExtra = 0;
wc.hInstance = hInstance;
wc.hbrBackground = (HBRUSH)(COLOR_BACKGROUND+1);
wc.hCursor = LoadCursor(NULL, IDC_ARROW);
wc.hIcon = LoadIcon (hInstance, MAKEINTRESOURCE(IDI_NP_ALERT));
wc.lpszMenuName =  szAppName;
wc.lpszClassName = szAppName;
return (RegisterClass(&wc));
} // InitApplication
// InitInstance
BOOL InitInstance (HANDLE hInstance, int nCmdShow)
{
smiUINT32 nMajorV, nMinorV, nLevel, nTranslateMode, nReMode;
hInst = hInstance;
hMainWnd = CreateWindow (szAppName, szAppName,
                        WS_OVERLAPPEDWINDOW,
                        CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
                        NULL, NULL, hInstance, NULL);
if (!hMainWnd)
   return (FALSE);
// Load defaults from np_alert.ini
GetPrivateProfileString (pDefs,"CommunityString","public",szCommStr,sizeof(szCommStr),pIni);
GetPrivateProfileString (pDefs,"Enterprise","1.3.6.1.4.1.999",szEnterprise,sizeof(szEnterprise),pIni);
GetPrivateProfileString (pDefs,"AgentIpAddress","",szAgentAddr,sizeof(szAgentAddr),pIni);
GetPrivateProfileString (pDefs,"GenericValue","6",szGeneric,sizeof(szGeneric),pIni);
GetPrivateProfileString (pDefs,"SpecificValue","1",szSpecific,sizeof(szSpecific),pIni);
GetPrivateProfileString (pDefs,"MgrIpAddress","",szMgrAddr,sizeof(szMgrAddr),pIni);
// Start WinSNMP
snmpErr = SnmpStartup (&nMajorV, &nMinorV, &nLevel, &nTranslateMode, &nReMode);
// Need better WinSNMP error processing in this small startup section
if (nTranslateMode != SNMPAPI_UNTRANSLATED_V1)
   {
   if (!(snmpErr = SnmpSetTranslateMode(SNMPAPI_UNTRANSLATED_V1)))
      MessageBox (GetFocus(), "SNMPAPI_FAILURE", "SnmpSetTranslateMode", MB_OK);
   }
if (!(hSession = SnmpOpen (hMainWnd, WM_SNMPMSG)))
   MessageBox (GetFocus(), "SNMPAPI_FAILURE", "SnmpOpen", MB_OK);
ShowWindow(hMainWnd, nCmdShow);
UpdateWindow(hMainWnd);
return (TRUE);
} // InitInstance
// MainWndProc
long CALLBACK __export
   MainWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
switch (message)
   {
   case WM_COMMAND:
      switch (wParam)
      {
      case IDM_ABOUT:
      NPAbout (hWnd, szAppName);
      break;
      
      case IDM_HELP_CONTENTS:
      WinHelp(hWnd, "NP_WSNMP.HLP", HELP_CONTENTS, 0L);
      break;
      
      case IDM_FILE_EXIT:
      SendMessage (hWnd, WM_CLOSE, 0, 0L);
      break;
       
      case IDM_BUILD:
      DialogBox (hInst, "GetPdu", hWnd, doGetPdu);
      break;
      
      case IDM_SEND:
      if (bReady)
         NPALERTSnmpSendMsg();
      else
         MessageBox (hWnd, "Please select Build.. first", "Menu Error", MB_OK);
      break;
                   
      default:
      break;
      }  // switch wParam
   break;
   
   case WM_SYSCOLORCHANGE:
   // Ctl3d needs to know
     Ctl3dColorChange();
   break;
   case WM_DESTROY:
   // WinSNMP Cleanup
   SnmpClose(hSession);
   SnmpCleanup();
   // Ctl3d cleanup
   Ctl3dUnregister (hInst);
   /* Windows cleanup */
   PostQuitMessage(0);
   break;

   default:                  /* Passes it on if unproccessed    */
   return (DefWindowProc(hWnd, message, wParam, lParam));
   }  // switch message

return (NULL);
} // MainWndProc

// doGetPdu
BOOL __export CALLBACK
   doGetPdu (HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
switch (message)
   {
   case WM_INITDIALOG:
   {
   int i;
   NPWSNMPINISECTION sEStruct;
   SendDlgItemMessage (hDlg, IDC_COMMSTR, WM_SETTEXT, 0, (LPARAM)(LPCSTR)szCommStr);
   SendDlgItemMessage (hDlg, IDC_ENTERPRISE, WM_SETTEXT, 0, (LPARAM)(LPCSTR)szEnterprise);
   SendDlgItemMessage (hDlg, IDC_AGENTADDR, WM_SETTEXT, 0, (LPARAM)(LPCSTR)szAgentAddr);
   SendDlgItemMessage (hDlg, IDC_GENERIC, WM_SETTEXT, 0, (LPARAM)(LPCSTR)szGeneric);
   SendDlgItemMessage (hDlg, IDC_SPECIFIC, WM_SETTEXT, 0, (LPARAM)(LPCSTR)szSpecific);
   wsprintf (display_buffer, "%lu", GetTickCount()/10); // Convert to 100ths of secs
   SendDlgItemMessage (hDlg, IDC_TIMESTAMP, WM_SETTEXT, 0, (LPARAM)(LPCSTR)display_buffer);
   SendDlgItemMessage (hDlg, IDC_MGRADDR, WM_SETTEXT, 0, (LPARAM)(LPCSTR)szMgrAddr);
   NPWSNMPGetIniSection (pAlarms, &sEStruct);
   for (i=0; i<sEStruct.count; i++)
      {
      SendDlgItemMessage (hDlg, IDC_TRAPTEXT, CB_ADDSTRING, 0, (LPARAM) ((LPSTR)sEStruct.ptrs[i]));
      }
   SendDlgItemMessage(hDlg, IDC_TRAPTEXT, CB_SETCURSEL, 0, 0);
   bReady = TRUE;
   return (TRUE);
   }

   case WM_COMMAND:
   switch (wParam)
      {
      case IDOK:
      GetDlgItemText (hDlg, IDC_COMMSTR, szCommStr, sizeof(szCommStr));
      GetDlgItemText (hDlg, IDC_ENTERPRISE, szEnterprise, sizeof(szEnterprise));
      GetDlgItemText (hDlg, IDC_AGENTADDR, szAgentAddr, sizeof(szAgentAddr));
      lGeneric = (smiUINT32)GetDlgItemInt (hDlg, IDC_GENERIC, NULL, FALSE);
      lSpecific = (smiUINT32)GetDlgItemInt (hDlg, IDC_SPECIFIC, NULL, FALSE);
      if (lGeneric < 6) lSpecific = 0;
      if (lSpecific)
         {
         GetDlgItemText (hDlg, IDC_TRAPTEXT, szTrapText, sizeof(szTrapText));
         if (!GetPrivateProfileString (pAlarms,szTrapText,"",szTrapText,sizeof(szTrapText),pIni))
            GetPrivateProfileString (pDefs,"TrapText","",szTrapText,sizeof(szTrapText),pIni);
         GetDlgItemText (hDlg, IDC_MGRADDR, szMgrAddr, sizeof(szMgrAddr));
         }
      GetDlgItemText (hDlg, IDC_TIMESTAMP, szTimeStamp, sizeof(szTimeStamp));
      lTimeStamp = atol (szTimeStamp);
      NPALERTSnmpSendMsg();
      EndDialog (hDlg, TRUE);
      return (TRUE);

      case IDCANCEL:
      EndDialog (hDlg, TRUE);
      return (TRUE);
      
      default:
      break;
      }
   default:
   break;
   } // switch
return (FALSE);
} // doGetPdu

SNMPAPI_STATUS NPALERTSnmpSendMsg()
{
hVbl = SnmpCreateVbl (hSession, NULL, NULL);
if (lSpecific)
   {
   SnmpStrToOid (szEnterprise, &dEnterprise);
   dTrapText.syntax = SNMP_SYNTAX_OCTETS;
   dTrapText.value.string.len = lstrlen (szTrapText);
   dTrapText.value.string.ptr = szTrapText;
   SnmpSetVb (hVbl, 1, &dEnterprise, &dTrapText);
   }   
SnmpStrToIpAddress (szAgentAddr, &dAgent_Addr);
SnmpStrToOctets (szCommStr, &dContext);
hCtx = SnmpStrToContext (hSession, &dContext);
hSrc = SnmpStrToEntity (hSession, szAgentAddr);
hDst = SnmpStrToEntity (hSession, szMgrAddr);
hPdu = SnmpCreatePdu (hSession, SNMP_PDU_V1TRAP, 0, 0, 0, hVbl);
if (hPdu == SNMPAPI_FAILURE)
   {
   snmpErr = SnmpGetLastError (hSession);
   wsprintf (display_buffer, "%SNMPAPI_FAILURE = %lu", snmpErr);
   MessageBox (GetFocus(), display_buffer, "SnmpCreatePdu", MB_OK);
   return (SNMPAPI_FAILURE);
   }
NPWSNMPSetV1TrapPduData (hPdu, &dEnterprise, &dAgent_Addr,
                         &lGeneric, &lSpecific, &lTimeStamp);
SnmpSendMsg (hSession, hSrc, hDst, hCtx, hPdu);
SnmpFreeEntity (hSrc);
SnmpFreeEntity (hDst);
SnmpFreeContext (hCtx);
SnmpFreeVbl (hVbl);
SnmpFreePdu (hPdu);
return (SNMPAPI_SUCCESS);
}
