/*
 *   COMPONENT_NAME: somc
 *
 *   ORIGINS: 27
 *
 *
 *   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
 *   All Rights Reserved
 *   Licensed Materials - Property of IBM
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */
/* @(#) somc/symtab.h 2.5 9/1/94 20:03:05 [9/21/94 17:45:27] */

/*
 */

/*
 *         File:    symtab.h.
 *     Contents:    Header file for generic symbol table routines.
 *                  [12/06/93] Free up unused symbol tables #1112
 */

#ifndef symtab_h
#define symtab_h

#include <smcidl.h>

#ifndef bool
#define bool boolean
#endif

#define SepNULL     (Sep *) NULL

/*
 * Forward referenc the Symbol table:
 */
struct Stab;

/*
 * Default Entry for a symbol table
 */
_typedef struct SEntry {
    char *name;
} _name(SEntry);

/*
 * Keyword structure.
 */
_typedef struct KeyTabEntry {
    char *kword;
    long token;
} _name(KeytabEntry);

/*
 * Symbol table entry linked list
 */
_typedef struct Sep {
    size_t posn;
    SEntry *ep;
    struct Sep *next;
} _name(Sep);

/*
 *  MemBuf is the structure used to allocate new memory in contiguous blocks.
 *  We can use it for unique strings too if the uniq flag is set when calling
 *  somtcreateMemBuf().
 */
_typedef struct MemBuf {
    char *base;
    size_t size;
    size_t nelms;
    char *cur;
    _struct Stab *stab;
} _name(MemBuf);

/*
 * Basic Symbol Table (STab) structure.
 */
_typedef struct Stab {
    size_t size;
    long entrysize;
    size_t nelms;
    Sep *base;
    Sep *limit;
    Sep *buf;
    MemBuf *membuf;
    bool ignorecase;
} _name(Stab);

#ifndef __SOMIDL__
SOMEXTERN char *somtallocBuf(MemBuf *membuf, void *buf, long len);
SOMEXTERN char *somtuniqString(MemBuf *membuf, char *s);
SOMEXTERN long somtkeyword(KeytabEntry *keytab, char *kword, long keytabsize);
SOMEXTERN void *somtaddEntry(Stab *stab, char *name, void *ep);
SOMEXTERN void *somtgetEntry(Stab *stab, char *name);
SOMEXTERN void *somtstabFirst(Stab *stab, Sep **sepp);
SOMEXTERN void *somtstabFirstName(Stab *stab, char *name, Sep **sepp);
SOMEXTERN void *somtstabNext(Stab *stab, Sep **sepp);
SOMEXTERN void *somtstabNextName(Stab *stab, Sep **sepp);
SOMEXTERN void somtcreateMemBuf(MemBuf **membufp, size_t bufsize, long stabsize);
SOMEXTERN void somtcreateStab(Stab *stab, long stabsize, long entrysize);
SOMEXTERN int somticstrcmp(char *s, char *t);
SOMEXTERN void *somtaddEntryBuf(Stab *stab, char *name, void *ep, void *buf, size_t len);
SOMEXTERN void somtFreeStab(Stab *stab, bool freeEp);
#endif  /* __SOMIDL__ */

#endif                                 /* symtab_h */
