/* @(#) 1.4 src/somu/somthrd.h, somu, som2.1 10/4/94 20:01:47 [11/1/94 21:15:25] */
/*
 *   COMPONENT_NAME: somd
 *
 *   ORIGINS: 27
 *
 *
 *   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
 *   All Rights Reserved
 *   Licensed Materials - Property of IBM
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */


/*
 *  somthrd.h - include file for Thread Service Provider Interfaces (SPIs)
 */

#ifndef SOM_somthrd_h
#define SOM_somthrd_h

#include <som.h>

#ifdef __IBMC__
 #pragma linkage(somTD_SOMStartThread     , system)
 #pragma linkage(somTD_SOMEndThread       , system)
 #pragma linkage(somTD_SOMKillThread      , system)
 #pragma linkage(somTD_SOMYieldThread     , system)
 #pragma linkage(somTD_SOMGetThreadHandle , system)
#endif

typedef void somTD_SOMThreadProc(void * data);
/* note: for OS/2 CSet++, somTD_SOMThreadProc must use _Optlink linkage */

typedef unsigned long SOMLINK somTD_SOMStartThread(OUT somToken * thrd,
						   IN somTD_SOMThreadProc proc,
						   IN void * data, 
						   IN unsigned long datasz,
						   IN unsigned long stacksz);
typedef unsigned long SOMLINK somTD_SOMEndThread(void);
typedef unsigned long SOMLINK somTD_SOMKillThread(IN somToken thrd);
typedef unsigned long SOMLINK somTD_SOMYieldThread(void);
typedef unsigned long SOMLINK somTD_SOMGetThreadHandle(OUT somToken * thrd);

/* pointers to thread service functions */
#ifndef _WIN32
SOMEXTERN somTD_SOMStartThread     * SOMDLINK SOMStartThread;
SOMEXTERN somTD_SOMEndThread       * SOMDLINK SOMEndThread;
SOMEXTERN somTD_SOMKillThread      * SOMDLINK SOMKillThread;
SOMEXTERN somTD_SOMYieldThread     * SOMDLINK SOMYieldThread;
SOMEXTERN somTD_SOMGetThreadHandle * SOMDLINK SOMGetThreadHandle;
#else

#define SOMStartThread  (*resolve_SOMStartThread())
SOMEXTERN somTD_SOMStartThread ** SOMLINK resolve_SOMStartThread(void);

#define SOMEndThread  (*resolve_SOMEndThread())
SOMEXTERN somTD_SOMEndThread ** SOMLINK resolve_SOMEndThread(void);

#define SOMKillThread  (*resolve_SOMKillThread())
SOMEXTERN somTD_SOMKillThread ** SOMLINK resolve_SOMKillThread(void);

#define SOMYieldThread (*resolve_SOMYieldThread())
SOMEXTERN somTD_SOMYieldThread ** SOMLINK resolve_SOMYieldThread(void);

#define SOMGetThreadHandle  (*resolve_SOMGetThreadHandle())
SOMEXTERN somTD_SOMGetThreadHandle ** SOMLINK resolve_SOMGetThreadHandle(void);

#endif /* !_WIN32 */


#endif /* SOM_somthrd_h */



