/*
 *   COMPONENT_NAME: somi
 *
 *   ORIGINS: 27
 *
 *
 *   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
 *   All Rights Reserved
 *   Licensed Materials - Property of IBM
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */
/* @(#) 2.8 src/somc/tc/somtcnst.h, somi, som2.1, somwarp_ga 9/1/94 18:29:12 [9/21/94 17:45:34] */

/*
 */

/*
 * SOMTCNST.H
 * TypeCode constants as defined in CORBA for use with SOM
 */

#ifndef somtcnst_h
#define somtcnst_h

#ifdef somtcnst_xh
  #include <som.xh>
#else
  #include <som.h>
#endif /* somtcnst_xh */

#if defined(_WIN32_SOMC) || !defined(_WIN32)
/* CORBA 7.6.2, p.141 */
#define TC_null 		    ((TypeCode) &TC__null)
#define TC_void 		    ((TypeCode) &TC__void)
#define TC_short		    ((TypeCode) &TC__short)
#define TC_long 		    ((TypeCode) &TC__long)
#define TC_ushort		    ((TypeCode) &TC__ushort)
#define TC_ulong		    ((TypeCode) &TC__ulong)
#define TC_float		    ((TypeCode) &TC__float)
#define TC_double		    ((TypeCode) &TC__double)
#define TC_boolean		    ((TypeCode) &TC__boolean)
#define TC_char 		    ((TypeCode) &TC__char)
#define TC_octet		    ((TypeCode) &TC__octet)
#define TC_any			    ((TypeCode) &TC__any)
#define TC_TypeCode		    ((TypeCode) &TC__TypeCode)
#define TC_Principal		    ((TypeCode) &TC__Principal)
#define TC_Object		    ((TypeCode) &TC__Object)
#define TC_string		    ((TypeCode) &TC__string)
#define TC_NamedValue		    ((TypeCode) &TC__NamedValue)
#define TC_InterfaceDescription     ((TypeCode) &TC__InterfaceDescription)
#define TC_OperationDescription     ((TypeCode) &TC__OperationDescription)
#define TC_AttributeDescription     ((TypeCode) &TC__AttributeDescription)
#define TC_ParameterDescription     ((TypeCode) &TC__ParameterDescription)
#define TC_RepositoryDescription    ((TypeCode) &TC__RepositoryDescription)
#define TC_ModuleDescription	    ((TypeCode) &TC__ModuleDescription)
#define TC_ConstDescription	    ((TypeCode) &TC__ConstDescription)
#define TC_ConstantDescription	    ((TypeCode) &TC__ConstDescription)
#define TC_ExceptionDescription     ((TypeCode) &TC__ExceptionDescription)
#define TC_TypeDescription	    ((TypeCode) &TC__TypeDescription)
#define TC_FullInterfaceDescription ((TypeCode) &TC__FullInterfaceDescription)

SOMEXTERN somToken SOMDLINK TC__null;
SOMEXTERN somToken SOMDLINK TC__void;
SOMEXTERN somToken SOMDLINK TC__short;
SOMEXTERN somToken SOMDLINK TC__long;
SOMEXTERN somToken SOMDLINK TC__ushort;
SOMEXTERN somToken SOMDLINK TC__ulong;
SOMEXTERN somToken SOMDLINK TC__float;
SOMEXTERN somToken SOMDLINK TC__double;
SOMEXTERN somToken SOMDLINK TC__boolean;
SOMEXTERN somToken SOMDLINK TC__char;
SOMEXTERN somToken SOMDLINK TC__octet;
SOMEXTERN somToken SOMDLINK TC__any;
SOMEXTERN somToken SOMDLINK TC__TypeCode;
SOMEXTERN somToken SOMDLINK TC__Principal;
SOMEXTERN somToken SOMDLINK TC__Object;
SOMEXTERN somToken SOMDLINK TC__string;
SOMEXTERN somToken SOMDLINK TC__NamedValue;
SOMEXTERN somToken SOMDLINK TC__InterfaceDescription;
SOMEXTERN somToken SOMDLINK TC__OperationDescription;
SOMEXTERN somToken SOMDLINK TC__AttributeDescription;
SOMEXTERN somToken SOMDLINK TC__ParameterDescription;
SOMEXTERN somToken SOMDLINK TC__RepositoryDescription;
SOMEXTERN somToken SOMDLINK TC__ModuleDescription;
SOMEXTERN somToken SOMDLINK TC__ConstDescription;
SOMEXTERN somToken SOMDLINK TC__ExceptionDescription;
SOMEXTERN somToken SOMDLINK TC__TypeDescription;
SOMEXTERN somToken SOMDLINK TC__FullInterfaceDescription;

#else

/*
**  These are the prototypes for the resolve functions used
**  in the macros below.  These are required to establish link names.
*/
SOMEXTERN TypeCode SOMLINK resolve_TC__null(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__void(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__short(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__long(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__ushort(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__ulong(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__float(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__double(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__boolean(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__char(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__octet(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__any(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__TypeCode(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__Principal(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__Object(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__string(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__NamedValue(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__InterfaceDescription(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__OperationDescription(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__AttributeDescription(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__ParameterDescription(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__RepositoryDescription(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__ModuleDescription(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__ConstDescription(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__ExceptionDescription(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__TypeDescription(void);
SOMEXTERN TypeCode SOMLINK resolve_TC__FullInterfaceDescription(void);

/* CORBA 7.6.2, p.141 */
#define TC_null 		    (resolve_TC__null())
#define TC_void 		    (resolve_TC__void())
#define TC_short		    (resolve_TC__short())
#define TC_long 		    (resolve_TC__long())
#define TC_ushort		    (resolve_TC__ushort())
#define TC_ulong		    (resolve_TC__ulong())
#define TC_float		    (resolve_TC__float())
#define TC_double		    (resolve_TC__double())
#define TC_boolean		    (resolve_TC__boolean())
#define TC_char 		    (resolve_TC__char())
#define TC_octet		    (resolve_TC__octet())
#define TC_any			    (resolve_TC__any())
#define TC_TypeCode		    (resolve_TC__TypeCode())
#define TC_Principal		    (resolve_TC__Principal())
#define TC_Object		    (resolve_TC__Object())
#define TC_string		    (resolve_TC__string())
#define TC_NamedValue		    (resolve_TC__NamedValue())
#define TC_InterfaceDescription     (resolve_TC__InterfaceDescription())
#define TC_OperationDescription     (resolve_TC__OperationDescription())
#define TC_AttributeDescription     (resolve_TC__AttributeDescription())
#define TC_ParameterDescription     (resolve_TC__ParameterDescription())
#define TC_RepositoryDescription    (resolve_TC__RepositoryDescription())
#define TC_ModuleDescription	    (resolve_TC__ModuleDescription())
#define TC_ConstDescription	    (resolve_TC__ConstDescription())
#define TC_ConstantDescription	    (resolve_TC__ConstDescription())
#define TC_ExceptionDescription     (resolve_TC__ExceptionDescription())
#define TC_TypeDescription	    (resolve_TC__TypeDescription())
#define TC_FullInterfaceDescription (resolve_TC__FullInterfaceDescription())

#define TC__null                     (*resolve_TC__null())
#define TC__void                     (*resolve_TC__void())
#define TC__short                    (*resolve_TC__short())
#define TC__long                     (*resolve_TC__long())
#define TC__ushort                   (*resolve_TC__ushort())
#define TC__ulong                    (*resolve_TC__ulong())
#define TC__float                    (*resolve_TC__float())
#define TC__double                   (*resolve_TC__double())
#define TC__boolean                  (*resolve_TC__boolean())
#define TC__char                     (*resolve_TC__char())
#define TC__octet                    (*resolve_TC__octet())
#define TC__any                      (*resolve_TC__any())
#define TC__TypeCode                 (*resolve_TC__TypeCode())
#define TC__Principal                (*resolve_TC__Principal())
#define TC__Object                   (*resolve_TC__Object())
#define TC__string                   (*resolve_TC__string())
#define TC__NamedValue               (*resolve_TC__NamedValue())
#define TC__InterfaceDescription     (*resolve_TC__InterfaceDescription())
#define TC__OperationDescription     (*resolve_TC__OperationDescription())
#define TC__AttributeDescription     (*resolve_TC__AttributeDescription())
#define TC__ParameterDescription     (*resolve_TC__ParameterDescription())
#define TC__RepositoryDescription    (*resolve_TC__RepositoryDescription())
#define TC__ModuleDescription        (*resolve_TC__ModuleDescription())
#define TC__ConstDescription         (*resolve_TC__ConstDescription())
#define TC__ConstantDescription      (*resolve_TC__ConstDescription())
#define TC__ExceptionDescription     (*resolve_TC__ExceptionDescription())
#define TC__TypeDescription          (*resolve_TC__TypeDescription())
#define TC__FullInterfaceDescription (*resolve_TC__FullInterfaceDescription())
#endif

#endif /* somtcnst_h */
