/* $HEADER$ */
/*
	File:		t_regist.cpp

	Contains:	Temporary part registration code

	Written by:	Lynn LeBaron

	Portions Copyright:	(c) 1994 by WordPerfect Corporation, all rights reserved.

	Change History (most recent first):

		 <1>	 01 Feb 1994	LDL		Creation

	To Do:
*/

#ifndef _T_REGIST_
#define _T_REGIST_

#ifndef SOM_ODPart_xh
#include "part.xh"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*


*/

class ODExport ODPartRegistryIterator;
class ODExport ODPartRegistry;


//==============================================================================
// Constants
//==============================================================================

#define TYPE_CLASS_DELIMITER ":"
#define TYPE_SECTION_STRING "ODTypes"
#define PREFERRED_STRING "PREFERRED"
#define DLL_STRING "DLL"
#define OLE2_CLASS_STRING "OLE2CLASS"
#define OLE2_ICON_STRING "OLE2ICON"
#define INI_FILE_STRING "OPENDOC.INI"

typedef	ODPart*	(WINAPI *ODFactoryType)(int, int);

#define MAX_PART_TYPE_DATA_STRING 80
typedef struct {
	char partKind[MAX_PART_TYPE_DATA_STRING];
	char editorName[MAX_PART_TYPE_DATA_STRING];
	char lpszDLLPath[MAX_PART_TYPE_DATA_STRING];
	char lpszClassIDOLE2[MAX_PART_TYPE_DATA_STRING];
	char lpszIconDescriptor[MAX_PART_TYPE_DATA_STRING];
} ODPartRegistryData;

class ODExport ODPartRegistry {

public:

	// Constructor
	ODPartRegistry() {};
	ODVMethod ~ODPartRegistry() {};

	// Methods

	ODMethod ODBoolean RegisterKindAndEditor(
		ODType 		partKind,
		ODEditor 	editorName,
		LPCSTR 		lpszDLLPath,
		LPCSTR 		lpszClassIDOLE2,
		LPCSTR 		lpszIconDescriptor);

	ODMethod ODBoolean UnregisterKindAndEditor(
		ODType 		partKind,
		ODEditor 	editorName);

	ODMethod ODBoolean SetPreferredEditorForKind(
		ODType 		partKind,
		ODEditor 	editorName);

	ODMethod ODBoolean GetRegDataForPreferredEditor(
		ODType 				partKind,
		ODPartRegistryData 	*typeData);

	ODMethod ODEditor GetPreferredEditor(
		ODType 		partKind);

	ODMethod ODBoolean GetRegDataForEditor(
		ODType 				partKind,
		ODEditor 			editorName,
		ODPartRegistryData 	*typeData);

	ODMethod ODBoolean EditorExists(
		ODType 				partKind,
		ODEditor 			editorName);

private:

};

class ODExport ODPartRegistryIterator {

friend class ODExport ODPartRegistry;

public:

	ODPartRegistryIterator();
	ODVMethod ~ODPartRegistryIterator();

	ODMethod void First(ODBoolean preferredOnly, ODPartRegistryData *typeData);

	ODMethod void Next(ODPartRegistryData *typeData);

	ODMethod void SkipToNextKind();

	ODMethod ODBoolean IsNotComplete();

private:

	ODMethod void GetNext(ODPartRegistryData *typeData);

#define MAX_KIND_BUF_BYTES 1024
#define MAX_EDITOR_BUF_BYTES 1024
	char		*fKindPtr;
	char		fKindBuf[MAX_KIND_BUF_BYTES];
	char		*fEditorPtr;
	char		fEditorBuf[MAX_EDITOR_BUF_BYTES];
	ODBoolean	fPreferredOnly;
	ODBoolean	fDone;
};

extern "C"
{
//-------------------------------------------------------------------------------------
// ODRegisterClass
//
// Register a part editor for a given part kind.
// A C interface to ODPartRegistry::RegisterTypeAndEditor
//-------------------------------------------------------------------------------------
BOOL WINAPI ODRegisterClass(
	LPCSTR	lpstrKindName,
	LPCSTR	lpstrEditorName,
	LPCSTR	lpstrDllFilename,
	LPCSTR	lpstrClsid,
	LPCSTR	lpstrIconDescriptor);

//-------------------------------------------------------------------------------------
// ODUnregisterClass
//
// Unregister a part editor for a given part kind.
// A C interface to ODPartRegistry::UnregisterTypeAndEditor
//-------------------------------------------------------------------------------------
BOOL FAR PASCAL ODUnregisterClass(
	LPCSTR	lpstrTypeName,
	LPCSTR	lpstrEditorName);
}

#if 0
//-------------------------------------------------------------------------------------
// IsNoPart
//
// Returns whether or not the given part is currently being edited by the
// handler of last resort.
//-------------------------------------------------------------------------------------
BOOL IsNoPart(Environment* ev, ODPart* rootPart);
#endif

#endif
