/*
 *   COMPONENT_NAME: somd
 *
 *   ORIGINS: 27
 *
 *
 *   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
 *   All Rights Reserved
 *   Licensed Materials - Property of IBM
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */
/* @(#) 2.17 src/somd/somdext.h, somd, som2.1 9/1/94 16:51:52 [11/1/94 20:24:28] */

/*
 */


/*
 *  somdext.h - miscellaneous external definitions for DSOM runtime
 *              (other external definitions are made in IDL files)
 */

#ifndef somdext_h
#define somdext_h

/* DSOM runtime functions */

#ifdef __IBMC__
  #pragma linkage(SOMD_Init, system)
  #pragma linkage(SOMD_Uninit, system)
  #pragma linkage(SOMD_RegisterCallback, system)
  #pragma linkage(SOMD_Callback, system)
  #pragma linkage(SOMInitsomd, system)
  #pragma linkage(ORBfree, system)
  #pragma linkage(SOMD_NoORBfree, system)
  #pragma linkage(somdExceptionFree, system)
  #pragma linkage(SOMD_FlushInterfaceCache, system)
#endif

SOMEXTERN void SOMLINK SOMD_Init(Environment *);
SOMEXTERN void SOMLINK SOMD_Uninit(Environment *);

typedef void SOMD_Callback(void *, void *);

#ifdef SOM_STRICT_IDL
SOMEXTERN void SOMLINK SOMD_RegisterCallback(SOMObject emanObj, SOMD_Callback *func);
#else
SOMEXTERN void SOMLINK SOMD_RegisterCallback(SOMObject *emanObj, SOMD_Callback *func);
#endif /* SOM_STRICT_IDL */

SOMEXTERN void SOMLINK SOMInitsomd(void);
#ifndef _DOS_REGIMPL
SOMEXTERN void SOMLINK ORBfree(void *);
#endif
SOMEXTERN void SOMLINK SOMD_NoORBfree(void);
SOMEXTERN void SOMLINK somdExceptionFree(Environment *ev);
SOMEXTERN void SOMLINK SOMD_FlushInterfaceCache(Environment *ev, string name);

/* DSOM global variables */

#ifdef _WIN16
#define SOMD_TraceLevel (*SOMD_TraceLevelResolve())
SOMEXTERN long * SOMLINK SOMD_TraceLevelResolve(void);
#define SOMD_DebugFlag (*SOMD_DebugFlagResolve())
SOMEXTERN long * SOMLINK SOMD_DebugFlagResolve(void);
#elif _WIN32
#define SOMD_TraceLevel (*resolve_SOMD_TraceLevel())
SOMEXTERN long * SOMLINK resolve_SOMD_TraceLevel(void);
#define SOMD_DebugFlag (*resolve_SOMD_DebugFlag())
SOMEXTERN long * SOMLINK resolve_SOMD_DebugFlag(void);
#else
SOMEXTERN long SOMDLINK SOMD_TraceLevel; 
SOMEXTERN long SOMDLINK SOMD_DebugFlag;
#endif /* _WIN16 */

#endif /* somdext_h */
