/*
 *   COMPONENT_NAME: somc
 *
 *   ORIGINS: 27
 *
 *
 *   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
 *   All Rights Reserved
 *   Licensed Materials - Property of IBM
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
	Last change:  KAS  26 Oct 94    6:01 pm
 */
/*
 *    @(#) 2.23 src/somc/lib/smlib.h, somc, som2.1, somwarp_ga 9/1/94 20:05:06 [9/21/94 17:55:15]
 */

/*
 */

/*
 *         File:    smlib.h.
 *     Contents:    General macros used by the SOM Compiler and the
 *                  emitters.
 *
 *                  [12/06/93] Partial Entry structures #1089
 *                  [01/14/94] Changes for SC LITE #1184
 *                  [04/01/94] Added Mac form for "#include <private" #2752
 */

#ifndef smlib_h
#define smlib_h
#include <somc_msg.h>
#ifndef _WIN32
#include <somport.h>
#endif
#include <setjmp.h> /* #1960 */

#ifdef SOMWATCH
#ifdef __MAC__ /* #2752 */
  #include <private:somwatch.h>
#else
  #include <private/somwatch.h>
#endif /* __MAC__ */
#define basemalloc  somwatchMalloc
#define basefree    somwatchFree
#define baserealloc somwatchRealloc /* #1112 */
#define basecalloc  somwatchCalloc /* #1112 */
#else
#define basemalloc  malloc
#define basefree    free
#define baserealloc realloc /* #1112 */
#define basecalloc  calloc /* #1112 */
#endif


#define SOMTOVERRIDE_TYPE(ep) (ep->type == SOMTOverrideMethodE || ep->u.m.omethod)
#define SOMTVALIDENTRY(e,m) ((somtgetatt(e, "class") ? TRUE : FALSE) == m)
#define SMUNKNOWNTYPE(e)    fprintf(stderr, "\"%s\": %d " \
				      "[%d]. \"%s\"\n", __FILE__, __LINE__,\
				       e->type, e->name)
#define somtfindBaseType(ep) (somtfindBaseEp(ep)->type)
/*
 * Error handling macros.  We keep a track of our various errors & warnings
 * in a global structure so that emitters can also post errors.
 * They can do this in one of two ways - calling the somtwarn, somterror,
 * somtfatal, somtinternal functions, or using these macros.
 */
#ifdef _WIN32 
#define SMANYERRORS()       ((*resolve_somtg_f()).ERROR || (*resolve_somtg_f()).FATAL || (*resolve_somtg_f()).INTERNAL)
#define SMANYFATAL()        ((*resolve_somtg_f()).FATAL || (*resolve_somtg_f()).INTERNAL)
#define SMWARNCOUNT()       ((*resolve_somtg_f()).WARN)
#define SMERRORCOUNT()      ((*resolve_somtg_f()).ERROR + (*resolve_somtg_f()).FATAL + (*resolve_somtg_f()).INTERNAL)
#define SMPOSTERROR(type)   ((*resolve_somtg_f()).type++)
#define SOMTSTAR            ((*resolve_somtaddstar()) ? "*" : "")
#define SOMTQUAL(cls)       (cls->sname && cls->sname[1])
#define ATTMAP(n)           ((!(*resolve_somtg_f()).idl && n && (*n == 'c')) ? somtattMap(n) : n)
#else
#define SMANYERRORS()       (somtg_f.ERROR || somtg_f.FATAL || somtg_f.INTERNAL)
#define SMANYFATAL()        (somtg_f.FATAL || somtg_f.INTERNAL)
#define SMWARNCOUNT()       (somtg_f.WARN)
#define SMERRORCOUNT()      (somtg_f.ERROR + somtg_f.FATAL + somtg_f.INTERNAL)
#define SMPOSTERROR(type)   (somtg_f.type++)
#define SOMTSTAR            (somtaddstar ? "*" : "")
#define SOMTQUAL(cls)       (cls->sname && cls->sname[1])
#define ATTMAP(n)           ((!somtg_f.idl && n && (*n == 'c')) ? somtattMap(n) : n)
#endif /* _WIN32 */
#define MSGSET STK
#ifdef __RESTRICT_MEMORY__
#define MAX_MSGSIZE 256
#else
#define MAX_MSGSIZE 500
#endif

/* 
 * setjmp/longjmp exit details #1960
 */

typedef struct {
    jmp_buf jmpbuf;
    bool called;
    int  status;
} SOMTExitBuf;

#define SOMTSETEXIT(buf)    if (!buf.called) setjmp(buf.jmpbuf) /* #1960 */

#define SOMT_IDL_SEQUENCE_LEN_1  13             /* IDL_SEQUENCE */
#define SOMT_IDL_SEQUENCE_LEN_2  22             /* seq<%10d> */
#define SOMT_IDL_SEQUENCE_LEN (SOMT_IDL_SEQUENCE_LEN_1+SOMT_IDL_SEQUENCE_LEN_2)
#define SOMT_REMOVE_IDL_SEQUENCE(s)   ((*s == '/') ? \
					 s+SOMT_IDL_SEQUENCE_LEN_2 : s)

/*
 * DBCS enabling macros
 */
#ifdef _DBCS
  #define DBCSBLANK        0x8140
  #define DBCSTOINT(buf)   ((((int)*(buf))<<8)+((int)*((buf)+1)))
  #define DBCSCOPY(buf,c)  if(isDBCS(c))\
    {*(buf)++=(char)((c)>>8);*(buf)++=(char)((c)&0xFF);}\
    else *(buf)++=(char)(c)
  #define DBCSSCAN(buf)    somtdbcsScan((char **)&(buf))
  #define DBCSINCR(buf)    ((buf) += isDBCS(*(buf))? 2: 1)
  #define DBCSCHAR(buf)    (isDBCS(*(buf)) ? DBCSTOINT(buf) : (int)(*(buf)))
  #define DBCS_output      dbcsOutput
  #define dbcsOutput(c,fp) ((isDBCS(c) && (putc((char)(c>>8), fp) == EOF)) \
					   ? EOF \
					   : putc((char) (c&0x00FF), fp))
  #define DBCS_strchr      somtdbcsStrchr
  #define DBCS_strrchr     somtdbcsStrrchr
  #define DBCS_strstr      somtdbcsStrstr
  #define DBCS_preincr     somtdbcsPreincr
  #define DBCS_postincr    somtdbcsPostincr
  #define isDBCS           somtisDbcs
  #define DBCS_isspace(c)  ((c >= 0) && (c < 256) && isspace(c))
#else
  #define DBCSCOPY(buf,c)  (*(buf)++=(char)(c))
  #define DBCSSCAN(buf)    ((int)(*(buf)++))
  #define DBCSINCR(buf)    (++(buf))
  #define DBCSCHAR(buf)    ((int)(*(buf)))
  #define DBCS_output      putc
  #define DBCS_strchr      strchr
  #define DBCS_strrchr     strrchr
  #define DBCS_strstr      strstr
  #define DBCS_preincr     ++
  #define DBCS_postincr(x) ((x)++)
  #define isDBCS(s)        (FALSE)
  #define DBCS_isspace(c)  (isspace(c))
#endif /* _DBCS */

/*
 * ISO LATIN 8859.1 Characater Set
 */
#define SOMTISALNUM(c)        (isalnum(c) || c == '_' || IS_ISO_LATIN_8859_1(c))
#define ISO_LATIN_8859_1_START  192
#define ISO_LATIN_8859_1_FINISH 255
#define IS_ISO_LATIN_8859_1(c)  (c >= ISO_LATIN_8859_1_START && \
				 c <= ISO_LATIN_8859_1_FINISH && \
				 c != 215 && c != 247)

/*
 * Enum for parent traversal.
 */
typedef enum _SMTraverse {SMTraverseAll, SMTraverseOnce, SMTraverseMany}
	SMTraverse;

/*
 * Command line flags and error structure.
 */
typedef struct {
    unsigned verbose:1;
    unsigned quiet:1;
    unsigned warn:1;
    unsigned extra:1;
    unsigned comments:1;
    AttList *atts;
    unsigned lex:1;
    unsigned yacc:1;
    unsigned release:1;
    unsigned stab:1;
    unsigned qualify:1;
    unsigned idl:1;
#ifdef __RESTRICT_MEMORY__
#define MAX_NO_EMITTERS 4
#else
#define MAX_NO_EMITTERS 32
#endif
    char *emitters[MAX_NO_EMITTERS];
    char *progname;
    int ERROR;
    int WARN;
    int FATAL;
    int INTERNAL;
    unsigned append:1;          /* Append to files, like -memitappend */
    unsigned level2:1;          /* level 2 extensions */
    unsigned noint:1;           /* no "int" warning */
    size_t commentsize;         /* size of comment buffer */
    unsigned useshort:1;        /* use short names */
    AttList *pragmas;           /* list of pragmas */
    Mlist *glbemits;            /* list of types to globally emit */
    unsigned fullyqualified:1;  /* TRUE if names have been fullyqualified */
    unsigned tcdone:1;          /* TRUE if typecodes have been created */
    unsigned relchk:1;          /* TRUE if you want release order checking */
} Flags;

/*
 * Global variables - that are really macros
 */

#ifdef _WIN32
#define somtcommentsize      (*resolve_somtg_f()).commentsize
#define somtpragmaList       (*resolve_somtg_f()).pragmas
#define somtglbemits         (*resolve_somtg_f()).glbemits
#define somtfullyqualified   (*resolve_somtg_f()).fullyqualified
#define somttcdone           (*resolve_somtg_f()).tcdone
#define somtrelchk           (*resolve_somtg_f()).relchk
#else
#define somtcommentsize      somtg_f.commentsize
#define somtpragmaList       somtg_f.pragmas
#define somtglbemits         somtg_f.glbemits
#define somtfullyqualified   somtg_f.fullyqualified
#define somttcdone           somtg_f.tcdone
#define somtrelchk           somtg_f.relchk
#endif /* WIN32 */

#define ARG_STRING          ((*argc)--, *(*argv)++)
#define MAX_ARG_LIST_LENGTH 2048
#define SOMTSABUF           (4*(FILENAME_MAX+2)+1) /* ::id::id::id::id */
#define SOMT_MSG_SIZE       MAX_ARG_LIST_LENGTH + SOMTSABUF

typedef struct {
    char *name;
    char *desc;
    short len;
} BaseType;

/*
 * Emitter function prototype:
 */
typedef FILE* (*EmitFn)(char*,Entry*,Stab*);

/*
 * External function prototypes from smlib.c, smload.c, smtypes.c, smdesc.c,
 * smmsg.c
 */
#ifdef _WIN32
SOMEXTERN int somttraverseParents(FILE *fp, Entry * cls, Entry *arg, int (*fn)(FILE*,Entry*,Entry*), SMTraverse flg);
#endif
SOMEXTERN AttList *somtattalloc(MemBuf *membuf, char *name, char *value);
SOMEXTERN AttList *somtgetap(AttList *ap, char *att);
SOMEXTERN EmitFn somtload(char *fileName, char *functionName, void **modHandle);
SOMEXTERN Entry *somtfindBaseEp(Entry *ep);
SOMEXTERN Entry *somtgetType(char *name, SOMTTypes type);
SOMEXTERN FILE *somtokfopen(char *path, char *mode);
SOMEXTERN FILE *somtopenEmitFile(char *file, char *ext);
SOMEXTERN bool somtisDbcs(int c);
SOMEXTERN bool somtremoveExt(char *name, char *ext, char *buf);
SOMEXTERN char *somtaddExt(char *name, char *ext, char *buf);
SOMEXTERN char *somtarrayToPtr(Entry *ep, char *stars, char *buf);
SOMEXTERN char *somtattNormalise(char *name, char *buf);
SOMEXTERN char *somtbasename(char *path);
SOMEXTERN char *somtctos(Const *con, char *buf);
SOMEXTERN char *somtdbcsPostincr(char **p);
SOMEXTERN char *somtdbcsPreincr(char **p);
SOMEXTERN char *somtdbcsStrchr(char *s, int c);
SOMEXTERN char *somtdbcsStrrchr(char *s, int c);
SOMEXTERN char *somtdbcsStrstr(char *s1, char *s2);
SOMEXTERN char *somteptotype(Entry *ep, char *ptrs, char *buf);
SOMEXTERN char *somtgetDesc(Stab *stab, Entry *cls, Entry *method, char *desc, bool addQuotes, bool use, bool versflg);
SOMEXTERN char *somtgetVersion(char *sccsid, char *version);
SOMEXTERN char *somtgetgatt(char *s);
SOMEXTERN char *somtnextword(const char *s, char *buf);
SOMEXTERN char *somtnormaliseDesc(char *desc, char *normal);
SOMEXTERN char *somtsatos(char **sa, char *sep, char *buf);
SOMEXTERN char *somtsearchFile(char *file, char *path, char *envvar);
SOMEXTERN char *somtskipws(const char *s);
SOMEXTERN char *somtstringFmt(char *fmt, ...);
SOMEXTERN char *somttype(SOMTTypes type);
SOMEXTERN char *somtuniqFmt(MemBuf *membuf, char *fmt, ...);
SOMEXTERN int somtargFlag(int *argc, char ***argv);
SOMEXTERN int somtattjoin(register AttList *ap1, AttList *ap2);
SOMEXTERN int somtdbcsLastChar(char *buf);
SOMEXTERN int somtdbcsScan(char **buf);
SOMEXTERN int somtdiskFull(FILE *fp);
SOMEXTERN int somtfclose(FILE *fp);
SOMEXTERN int somtfexists(char *file);
SOMEXTERN int somtisparent(Entry *cls, Entry *parent);
SOMEXTERN int somtmget(int setnum, int msgnum, char *msgbuf);
SOMEXTERN int somtmopen(char *filename);
SOMEXTERN int somtmprintf(int setnum, int msgnum, ...);
SOMEXTERN int somtokremove(char *file);
SOMEXTERN int somtunload(void *modHandle);
SOMEXTERN int somtwriteaccess(char *file);
SOMEXTERN void *somtsmalloc(size_t nbytes, bool clear);
SOMEXTERN void somtaddGAtt(MemBuf **membuf, AttList **ap, char *buf);
SOMEXTERN void somtcalcFileName(char *def, char *over, char *ext);
SOMEXTERN void somtcleanFilesFatal(int status);
SOMEXTERN void somtemitTypes(FILE *fp, Mlist *mp, Stab *stab);
SOMEXTERN void somterror(char *file, long lineno, char *fmt, ...);
SOMEXTERN void somtfatal(char *file, long lineno, char *fmt, ...);
SOMEXTERN void somtinternal(char *file, long lineno, char *fmt, ...);
SOMEXTERN void somtmclose(void);
SOMEXTERN void somtmsg(char *file, long lineno, char *fmt, ...);
SOMEXTERN void somtreadDescFile(Stab *stab, char *file);
SOMEXTERN void somtsetDefaultDesc(Stab *stab);
SOMEXTERN void somtsetEmitSignals(void(*cleanup) (int), void (*internal) (int));
SOMEXTERN void somtsetTypeDefn(Entry *type, Entry *ep, char *ptrs, Entry *ret, bool array);
SOMEXTERN void somtsetext(int csc);
SOMEXTERN void somtshowVersion(char *s, char *progname, char *sccsid);
SOMEXTERN void somtsmfree(void *first, ...);
SOMEXTERN void somtunsetEmitSignals(void);
SOMEXTERN void somtwarn(char *file, long lineno, char *fmt, ...);
SOMEXTERN char *somtuppercase(char *s, char *buf);
SOMEXTERN char *somtlowercase(char *s, char *buf);
SOMEXTERN char *somtdbcsuppercase(char *s, char *buf);
SOMEXTERN char *somtdbcslowercase(char *s, char *buf);
SOMEXTERN void somtresetEmitSignals(void);
SOMEXTERN size_t somtsizeofEntry(SOMTTypes type);
SOMEXTERN char *somtepname(Entry *ep, char *buf, bool suppressImpctxCheck);
SOMEXTERN char *somtgenSeqName(long n, Entry *base, char *buf, bool fullname);
SOMEXTERN void somtmrifatal(char *file, long lineno, int msgnum,...);
SOMEXTERN void somtmriinternal(char *file, long lineno, int msgnum,...);
SOMEXTERN void somtmrierror(char *file, long lineno, int msgnum,...);
SOMEXTERN void somtmrimsg(char *file, long lineno, int msgnum,...);
SOMEXTERN void somtmriwarn(char *file, long lineno, int msgnum,...);
SOMEXTERN void somtsetInternalMessages(char *too_long, char *cant_continue, char *segv, char *bus);
SOMEXTERN bool somtisvoid(Entry *type, char *defn);
SOMEXTERN bool somtreturnsStruct(Entry *ep);
SOMEXTERN bool somtreturnsPtr(Entry *ep);
SOMEXTERN char *somtsimpleName(Entry *ep);
SOMEXTERN void somtqualifyNames(Stab * stab, bool fully);
SOMEXTERN Entry *somtfindBaseEpNonPtr(Entry *ep);
SOMEXTERN bool somtprocessTraps(void);
SOMEXTERN Mlist *somtallocMlist(Entry * ep); /* #206 */
SOMEXTERN Mlist *somtmlistend(Mlist * mp, char *name); /* #206 */
SOMEXTERN bool somtisMutRef(Entry *ep, Mlist *seen, bool isself, long level); /* #206 */
SOMEXTERN Mlist * somtfreeMlist(Mlist *mp); /* #206 */
SOMEXTERN Mlist * somtdupMlist(Mlist *mp, Entry *ep); /* #206 */
SOMEXTERN void somtfreeWorld(); /* #1112 */
SOMEXTERN void somtinitMalloc(bool dynamic); /* #1112 */
SOMEXTERN void somtInitialiseEmitlib(void); /* #1180 */
SOMEXTERN void somtInitialiseSmmeta(void); /* #1180 */
SOMEXTERN void somtInitialiseCreatetc(void); /* #1180 */
SOMEXTERN void somtInitialiseSmtypes(void); /* #1180 */
SOMEXTERN void somtInitialiseSomc(void); /* #1180 */
SOMEXTERN void somtInitialiseSmsmall(void);
SOMEXTERN char *somtattMap(char *name);
SOMEXTERN void somtexit(SOMTExitBuf *ebuf, int status); /* #1960 */

/*
 * In emitlib.c
 */
SOMEXTERN void somtdymain(char *file, Entry *cls, EmitFn emitfn, char *emitter, int first, char *version, Stab *stab);
SOMEXTERN void somtaddHeader(char *file, FILE *fp, char *ext);

/*
 * Global variables
 */
#ifdef _WIN32
SOMEXTERN Flags * SOMLINK resolve_somtg_f(void);
#define somtg_f (*resolve_somtg_f())
#else
SOMEXTERN global Flags somtg_f;        /* Command line flags structure */
#endif

#ifdef _WIN32
SOMEXTERN MemBuf **  SOMLINK resolve_somtg_membuf(void);
#define  somtg_membuf (*resolve_somtg_membuf())
#else
SOMEXTERN global MemBuf *somtg_membuf; /* Memory buffer for string allocation */
#endif


#ifdef _WIN32
SOMEXTERN Mlist ** SOMLINK resolve_somtglbdefs(void);
#define  somtglbdefs (*resolve_somtglbdefs ())
#else
SOMEXTERN global Mlist *somtglbdefs;   /* Global defs */
#endif

#ifdef _WIN32
SOMEXTERN SMEXT * SOMLINK resolve_somtext(void);
#define somtext (*resolve_somtext())
#else
SOMEXTERN global SMEXT somtext;        /* Different idl/oidl extensions */
#endif

#ifdef _WIN32
SOMEXTERN Stab ** SOMLINK resolve_somtstab(void);  
#define   somtstab (*resolve_somtstab())
#else
SOMEXTERN global Stab *somtstab;       /* Pointer to symbol table */
#endif

#ifdef _WIN32
SOMEXTERN bool * SOMLINK resolve_somtaddstar(void);
#define somtaddstar (*resolve_somtaddstar())
#else
SOMEXTERN global bool somtaddstar;     /* Cached copy of global modifier */
#endif

#ifdef _WIN32
SOMEXTERN bool * SOMLINK resolve_somtrmstar(void);
#define somtrmstar (*resolve_somtrmstar())
#else
SOMEXTERN global bool somtrmstar;      /* Cached copy of global modifier */
#endif

#ifdef _WIN32
SOMEXTERN char ** SOMLINK resolve_somtg_buf(void);
#define somtg_buf (*resolve_somtg_buf())
#else
SOMEXTERN global char *somtg_buf;      /* Comment/pass thru buffer */
#endif

#ifdef _WIN32
SOMEXTERN char ** SOMLINK resolve_somtg_sccsid(void);
#define somtg_sccsid (*resolve_somtg_sccsid())
#else
SOMEXTERN global char *somtg_sccsid;
#endif

#ifdef _WIN32
typedef char arc[];
SOMEXTERN arc * SOMLINK resolve_somtfilePath(void);
#define somtfilePath (*resolve_somtfilePath())
#else
SOMEXTERN global char somtfilePath[];  /* input file full path */
#endif

#ifdef _WIN32
SOMEXTERN arc * SOMLINK resolve_somtfileStem(void);
#define somtfileStem (*resolve_somtfileStem())
#else
SOMEXTERN global char somtfileStem[];  /* infput file stem */
#endif

#ifdef _WIN32
SOMEXTERN arc * SOMLINK resolve_somtoutPath(void);
#define somtoutPath (*resolve_somtoutPath())
#else
SOMEXTERN global char somtoutPath[];   /* output file */
#endif

#ifdef _WIN32
typedef char * (*somTD_somtgetAtt)(AttList *, char *, char **);
somTD_somtgetAtt * SOMLINK resolve_somtgetAtt(void); /* #1960 real exit to call */
#define somtgetAtt  (*resolve_somtgetAtt())
#else
SOMEXTERN global char *(*somtgetAtt) (AttList *, char *, char **);
#endif

#ifdef _WIN32
SOMEXTERN Entry ** SOMLINK resolve_somtmodule(void);
#define somtmodule  (*resolve_somtmodule())
#else
SOMEXTERN global Entry *somtmodule;    /* Pinter to last module encountered */
#endif

#ifdef _WIN32
SOMEXTERN Mlist ** SOMLINK resolve_somtclassList(void);
#define somtclassList (*resolve_somtclassList())
#else
SOMEXTERN global Mlist *somtclassList; /* List of classes that sc emits */
#endif

#ifdef _WIN32
SOMEXTERN long * SOMLINK resolve_somtsaved(void);
#define somtsaved  (*resolve_somtsaved())
#else
SOMEXTERN global long somtsaved;       /* Bytes saved due to various
					* optimisations steps #1089 */
#endif

#ifdef _WIN32                                   
typedef void * (*somTD_somtmalloc)(size_t);
SOMEXTERN somTD_somtmalloc * SOMLINK resolve_somtmalloc(void);
#define  somtmalloc (*resolve_somtmalloc())

typedef void (*somTD_somtfree)(void *);
SOMEXTERN somTD_somtfree *SOMLINK resolve_somtfree(void);         /* #1112 */
#define  somtfree (*resolve_somtfree())

typedef void * (*somTD_somtcalloc)(size_t, size_t);
SOMEXTERN somTD_somtcalloc * SOMLINK resolve_somtcalloc(void); /* #1112 */
#define somtcalloc (*resolve_somtcalloc())

typedef void * (*somTD_somtrealloc)(void *,size_t);
SOMEXTERN somTD_somtrealloc * SOMLINK resolve_somtrealloc(void); /* #1112 */
#define somtrealloc (*resolve_somtrealloc())

#else
SOMEXTERN global void *(*somtmalloc)(size_t nbytes); /* #1112 */
SOMEXTERN global void (*somtfree)(void *bp);         /* #1112 */
SOMEXTERN global void *(*somtcalloc)(size_t nmemb, size_t size);  /* #1112 */
SOMEXTERN global void *(*somtrealloc)(void *bp, size_t nbytes); /* #1112 */
#endif

#ifdef _WIN32
typedef void (*somTD_signalfunc_f)(int);
/* cleanup signal function to call */
SOMEXTERN somTD_signalfunc_f * SOMLINK resolve_somtcleanup_f(void); 
#define somtcleanup_f (*resolve_somtcleanup_f())
/* internal signal function to call */
SOMEXTERN somTD_signalfunc_f * SOMLINK resolve_somtinternal_f(void); 
#define somtinternal_f (*resolve_somtinternal_f())
SOMEXTERN int * SOMLINK resolve_somtopenEmitFileCalled(void); /* #1125, #1180 */
#define somtopenEmitFileCalled (*resolve_somtopenEmitFileCalled())
/* don't you just LOVE win32 dll architecture? */
#else
SOMEXTERN global void (*somtcleanup_f) (int); /* cleanup signal function to call */
SOMEXTERN global void (*somtinternal_f) (int);/* internal signal function to call */
SOMEXTERN global int somtopenEmitFileCalled; /* #1125, #1180 */
#endif

#ifdef _WIN32
SOMEXTERN SOMTExitBuf * SOMLINK resolve_somtipcbuf(void);
#define somtipcbuf (*resolve_somtipcbuf())
#else
SOMEXTERN global SOMTExitBuf somtipcbuf;  /* #1960 - global buffer for the setmp/longjmp */
#endif

#ifdef _WIN32
SOMEXTERN SOMTExitBuf * SOMLINK resolve_somtscbuf(void);
#define somtscbuf (*resolve_somtscbuf())
#else
SOMEXTERN global SOMTExitBuf somtscbuf;   /* #1960 - global buffer for the setmp/longjmp */
#endif

#ifdef _WIN32
SOMEXTERN void ** SOMLINK resolve_somtemitReturns(void);
#define somtemitReturns (*resolve_somtemitReturns())
#else
SOMEXTERN global void *somtemitReturns; /* Emitter returns */ /* #1960 */
#endif

#ifdef _WIN32
typedef void (*somTD_somtrealExit)(int);
SOMEXTERN somTD_somtrealExit * SOMLINK resolve_somtrealExit(void); /* #1960 real exit to call */
#define somtrealExit (*resolve_somtrealExit())
#else
SOMEXTERN global void (*somtrealExit)(int status); /* #1960 real exit to call */
#endif

#endif
