/*
 *   COMPONENT_NAME: somc
 *
 *   ORIGINS: 27
 *
 *
 *   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
 *   All Rights Reserved
 *   Licensed Materials - Property of IBM
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
	Last change:  KAS  26 Oct 94    2:29 pm
 */
/* @(#) somc/emitlib.h 2.8 9/1/94 20:05:14 [9/21/94 17:45:20] */

/*
 */

/*
 *         File:    emitlib.h.
 *     Contents:    Header file for General routines that are primarily
 *                  used by the base emitters and framework.
 */

#ifndef emitlib_h
#define emitlib_h

#include <smstd.h>
#include <sm.h>
#include <symtab.h>
#include <smlib.h>

#ifndef SOMObject
  #define SOMObject void *
  #include <somcorba.h>
  #undef SOMObject
#else
  #include <somcorba.h>
#endif /* !SOMObject */

#ifndef _IDL_SEQUENCE_string_defined
#define _IDL_SEQUENCE_string_defined
SOM_SEQUENCE_TYPEDEF (string);
#endif /* _IDL_SEQUENCE_string_defined */

#define MAX_COMMENT_ARG_LIST_LENGTH (MAX_ARG_LIST_LENGTH * 2)
#define MAX_DESCRIPTOR_LENGTH       512
#define PASSTHRU_STRIP              0x2
#define SMMETA_PREFIX               "M_"

/*
 * Macro version of single line functions
 */
#define somtattExists(ep,s)          (somtgetatt(ep,s) ? TRUE : FALSE)
#define somtlookupComment(n)         (n ? n : "")

/* typedef needed by somtGetReintroducedMethods: */
typedef SOM_SEQUENCE(Entry *) _IDL_SEQUENCE_EntryPtr;

/*
 * External function prototypes from: emitlib.c, meta.c, createtc.c
 */
SOMEXTERN Entry *somtnthArg(Entry * method, int n);
SOMEXTERN FILE *somtemitModule(char *file, Entry *cls, char *ext);
SOMEXTERN Mlist *somtallocDataList(Entry *cls);
SOMEXTERN Mlist *somtallocMethodList(Entry *cls, bool all);
SOMEXTERN char *somtclsfilename(Entry * cls);
SOMEXTERN char *somtclsname(Entry * cls);
SOMEXTERN char *somtfindMethodName(const char *bp, char *name);
SOMEXTERN char *somtfullPrototype(char *buf, Entry * method, char *sep, int varargs);
SOMEXTERN char *somtfullTypedef(char *buf, Entry * cls, Entry * method);
SOMEXTERN char *somtgetNonRepeatedParent(Entry *cls, int i);
SOMEXTERN char *somtgetatt(Entry * ep, char *s);
SOMEXTERN char *somtgetdatt(Entry * ep, char *s);
SOMEXTERN char *somtimplicit(Entry *ep, bool shortform, char *buf);
SOMEXTERN char *somtimplicitArgs(Entry *ep);
SOMEXTERN char *somtincludeOnce(Entry *cls, char *ext, char *buf);
SOMEXTERN char *somtpclsfilename(Entry *parent);
SOMEXTERN char *somtpclsname(Entry *parent);
SOMEXTERN char *somtprefixedPrototype(char *buf, Entry * method, char *sep, int varargs, char *prefix);
SOMEXTERN char *somtreplaceDataName(char *buf, Entry * data, char *replace);
SOMEXTERN char *somtrmSelf(char *str);
SOMEXTERN char *somtshortArgList(char *buf, Entry * method, char *sep, bool varargs, bool addself);
SOMEXTERN int somtimplicitMeta(Entry *cls);
SOMEXTERN int somtlistAttribute(FILE * fp, int n, AttList * ap, char *s, bool value, bool breakLine, bool firstComma);
SOMEXTERN int somtnewMethodsCount(Entry * cls, int meta, bool procflg);
SOMEXTERN int somtprivateMethodsCount(Entry * cls, int meta);
SOMEXTERN void somtaddHeader(char *file, FILE *fp, char *ext);
SOMEXTERN void somtcleanFiles(int status);
SOMEXTERN void somtdeclareIdlVarargs(FILE *fp, Entry *ep);
SOMEXTERN void somtdymain(char *file, Entry *cls, EmitFn emitfn, char *emitter, int first, char *version, Stab *stab);
SOMEXTERN void somtemitModuleTypes(FILE *fp, Entry *ep, Stab *stab);
SOMEXTERN void somtemitPassthru(FILE * fp, Entry * cls, char *name, int mode, char *att);
SOMEXTERN void somtfreeDataList(Mlist *mlist);
SOMEXTERN void somtfreeMethodList(Mlist *mlist);
SOMEXTERN void somtfullComment(FILE * fp, char *fmt,...);
SOMEXTERN void somthandleDiskFull(FILE *fp);
SOMEXTERN void somtinitialiseMeta(Entry * cls, Stab * stab, bool meta, int imp);
SOMEXTERN void somtoidlComment(FILE * fp, int min, int max, char style, char *comment);
SOMEXTERN void somtscmsg(Entry *cls, Entry *ep, char *fmt, ...);
SOMEXTERN void somtshortDefine(FILE *fp, Entry *ep, char *fmt, ...);
SOMEXTERN void somtuninitialiseMeta(Entry * cls);
SOMEXTERN FILE *somtobseleteHeaderFile(char *file, Entry *cls, char *ext, char *newext);
SOMEXTERN char *somtwidenType(Entry *ep, char *args, char *type);
SOMEXTERN void somtgenAttStubs(FILE *fp, Entry *cls, char *prefix, char *classprefix);
SOMEXTERN void somtstrictidl(FILE *fp);
SOMEXTERN void somtcreateTypeCodes (Stab *stab);
SOMEXTERN TypeCode *somtemitTcConstant (TypeCode t, FILE *f, char *name, TypeCode *alreadyDone);
SOMEXTERN void somtemitPredefinedTcConstants (FILE *f);
SOMEXTERN Entry *somtAncestorClass(Entry *cls, char *name);
SOMEXTERN short somttcAlignment (TypeCode t, Environment *ev);
SOMEXTERN long somttcSize (TypeCode t, Environment *ev);
SOMEXTERN TCKind somttcKind (TypeCode t, Environment *ev);
SOMEXTERN sequence(string) somttcSeqFromListString (string s);
SOMEXTERN _IDL_SEQUENCE_EntryPtr somtGetReintroducedMethods(Entry *cls);

/*
 * Global variables
 */
#ifdef _WIN32
int * SOMLINK resolve_somtCPP();
#define somtCPP   (*resolve_somtCPP())
#else
SOMEXTERN global int somtCPP;          /* C++ bindings */
#endif

#ifdef _WIN32
bool * SOMLINK resolve_somtclassIdlCall();
#define somtclassIdlCall   (*resolve_somtclassIdlCall())
#else
SOMEXTERN global bool somtclassIdlCall;/* IDL Calling convention */
#endif

#ifdef _WIN32
char ** SOMLINK resolve_somtclassName();
#define  somtclassName       (*resolve_somtclassName())
#else
SOMEXTERN global char *somtclassName;  /* Current Class Name */
#endif

#ifdef _WIN32
char ** SOMLINK resolve_somtclassPrefix();
#define somtclassPrefix    (*resolve_somtclassPrefix())
#else
SOMEXTERN global char *somtclassPrefix;/* Current Class Prefix */
#endif

#ifdef _WIN32
char ** SOMLINK resolve_somtg_somlink();
#define  somtg_somlink      (*resolve_somtg_somlink())
#else
SOMEXTERN global char *somtg_somlink;  /* Set to "SOMLINK" when required - csc,
                                        * psc emitters turn this off. */
#endif

#ifdef _WIN32
char ** SOMLINK resolve_somtmajorVersion();
#define   somtmajorVersion   (*resolve_somtmajorVersion())
#else
SOMEXTERN global char *somtmajorVersion; /* Major version number for class */
#endif

#ifdef _WIN32
char ** SOMLINK resolve_somtminorVersion();
#define   somtminorVersion   (*resolve_somtminorVersion())
#else
SOMEXTERN global char *somtminorVersion; /* Minor version number for class */
#endif

#ifdef _WIN32
int * SOMLINK resolve_somtmeta();
#define    somtmeta      (*resolve_somtmeta())
#else
SOMEXTERN global int somtmeta;         /* TRUE when in implicit meta mode */
#endif

#ifdef _WIN32
char ** SOMLINK resolve_somtmp();
#define  somtmp     (*resolve_somtmp())
#else
SOMEXTERN global char *somtmp;         /* Set to SMMETA_PREFIX when somtmeta is
					* TRUE */ 
#endif

#ifdef _WIN32
Entry  ** SOMLINK resolve_somtsomcls();
#define somtsomcls   (*resolve_somtsomcls())
#else
SOMEXTERN global Entry *somtsomcls;    /* Pointer to SOMClass Entry in Symbol
                                        * Table */
#endif



#endif
