/*
	File:		dbutton.h

	Contains:	Class definition for dbutton

	Written by:	Don Griffes

	Copyright:	c 1993-94 by WordPerfect, Inc., all rights reserved.

	Notes:		This file is not complete in this version.  Changes WILL be made
					and no api's are immune to changes.  Some methods have not been
					coded at this point.  In fact I expect I will have to make major
					changes for some of the things I plan on adding.  What do I plan
					on adding.  Well I'm not telling you so you don't get your hopes
					up, because it may turn out that I don't add anything or even
					finish what I've started here.  NO SUPPORT IS AVAILABLE!

	Change History (most recent first):

*/
#ifndef _DBUTTON_H_
#define _DBUTTON_H_


// Predefined button states
#define	DBS_UP	0
#define	DBS_DOWN	1

// Errors
#define	DERR_NOERROR		0
#define	DERR_OUTOFMEM		1
#define 	DERR_INVALID_ID	2
#define	DERR_INVALID_BITMAP	3
#define	DERR_RENDER			4


struct ButtonListTag
{
	int	id;
	HBITMAP	bitmap;
//	HBITMAP	curbitmap;
	int	x;
	int	y;
	int	w;
	int	h;
	int	state;
	int	UseBitmap;
	struct ButtonListTag *next;
};

class DButton
{
private:
	HWND	hWindow;
	ButtonListTag	*ButtonList;
	int Create(int _id, int _x, int _y, int _w, int _h, int _state);
	int Render(ButtonListTag *);
	ButtonListTag * Find (int _id);

public:
	DButton(HWND _hWindow);
	~DButton();
	int Add(int _id,int _x=0, int _y=0, int _w=0, int _h=0,
			  int _state=DBS_UP, int _UseBitmap = 0);
	int Remove (int _id);

	int SetState (int _id,int _state);
	int GetState( int _id);
	int SetLocation (int _id, int _x, int _y);

	int Draw(int _id);
	void DrawAll();

	int CheckForHit (int x, int y);
};


#endif  /* header wrapper */