/*
 File:		NicePart.h

 Contains:	NicePart Common constants used by .cpp & .r file

 Written by:	PartMaker 
*/

#ifndef _NICEPART_
#define _NICEPART_

// Kind
#define kNicePartKind "Apple:Kind:NicePart"

// Category
#define kNicePartCategory "Apple:Category:NicePart"

// Class ID / Editor [Used by ASLM]
#define kNicePartID "appl:NicePart$class"

// Editor User String
#define kNicePartEditorUserString "NicePart 1.0"

// Kind User String
#define kNicePartKindUserString "NicePart Kind"

// Category User String
#define kNicePartCategoryUserString "NicePart Category"

// NicePart OSType
#define kNicePartOSType 'GEEK'

#define kKindCategoryMapId			kNMAPid+1
#define kEditorKindMapId			kNMAPid+2
#define kEditorUserStringMapId		kNMAPid+3
#define kKindUserStringMapId		kNMAPid+4
#define kCategoryUserStringMapId	kNMAPid+5
#define kOldMacOSTypeMapId			kNMAPid+6

// Menu Ids
#define IDM_GRAY         2001
#define IDM_RED          2002
#define IDM_GREEN        2003
#define IDM_YELLOW       2004
#define IDM_BLUE         2005
#define IDM_MAGENTA      2006
#define IDM_CYAN         2007
#define IDM_WHITE        2008

struct ColorRect
{
 	ODRect* 	Rect;
	COLORREF	color;

	ColorRect(ODRect* rect, COLORREF clr)
	{
		Rect=rect;
		color=clr;
	}
};

#endif
