/*
	File:		FacetList.h

	Contains:	Linked list of facets, for use by parts

	Written by:	Jens Alfke

	Theory of Operation:
		This is a quick-n-dirty linked list of ODFacets. To use it, create a
		FacetList and use the Add and Remove methods to add/remove facets.
		To iterate over all the facets, do something like this:
		
			for( FacetLink *fl=facetList.First(); fl->Facet(); fl=fl->Next() )
				DoSomethingWithFacet( fl->Facet() );
*/

#ifndef _FACETLIST_
#define _FACETLIST_


class ODFacet;


//==============================================================================
// FacetLink
//==============================================================================

class FacetLink
{
public:
	
	ODFacet*	Facet( )					{return fFacet;}
	FacetLink*	Next( )						{return fNext;}
	
protected:
				FacetLink( ODFacet*, FacetLink *list );
				FacetLink( );
				~FacetLink( );
				
	ODFacet	*fFacet;
	FacetLink	*fPrev,
				*fNext;
	friend class FacetList;
};


//==============================================================================
// FacetList
//==============================================================================

class FacetList : public FacetLink
{
public:
				FacetList( );
				~FacetList( );
	void		Add( ODFacet* );
	void		Remove( ODFacet* );
	void		InvalAllFacets( );
	FacetLink*	First( )					{return fNext;}
};

#endif
