/*
	File:		PrtPrpAc.h

	Contains:	Interface to class that handles accessing part properties for
				the OpenDoc shell.

	Written by:	Nick Pilch

	Copyright:	c 1993 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		 <1>	 8/30/94	NP		first checked in
		 <6>	 1/19/94	eeh		fixed G/SetData param types
		 <5>	 1/11/94	eeh		nuke FramePropAccessor class; mods to
									others
		 <4>	 12/9/93	eeh		new classes AbsDrawPartPropAccessor,
									DragPartPropAccessor and FramePropAccessor
		 <3>	 12/1/93	CG		Added new class EmbeddedPartPropAccessor
									for getting pBounds and pTranslation from
									an embedded part.
		 <2>	11/16/93	CG		Includes DrawPart.h
		 <1>	 9/10/93	NP		first checked in

	To Do:
*/

#ifndef _PRTPRPAC_
#define _PRTPRPAC_

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef __APPLEEVENTS__
#include <AppleEvents.h>
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
	This a simple abstract class to aid in the processing of Apple Events that
	are requests to get or set properties. Since OpenDoc does the resolution
	first, the object accessor routines can allocate one of these classes
	according to the property for which they have been asked to create a token.
	When passed back to the event handler, the event handler need only call the
	the appropriate member function of this class, GetData or SetData, to
	process the event. The event handler must then delete the object.
*/

//==============================================================================
// Constants
//==============================================================================

//==============================================================================
// Scalar Types
//==============================================================================

//==============================================================================
// Classes defined in this interface
//==============================================================================

class DrawPartPropAccessor;
class EmbeddedPartPropAccessor;
class DragPartPropAccessor;

//==============================================================================
// Classes used by this interface
//==============================================================================

class ODObject;
class ODFrame;
class AppleTestDraw_DrawPart;
class DragPart;

//==============================================================================
// PropAccessor
//==============================================================================

class AbsDrawPartPropAccessor
{
	public:
		AbsDrawPartPropAccessor(DescType property, ODObject* object);
		ODVMethod void SetData(AEDesc* data);
		ODVMethod void GetData(AEDesc* result);
	
		ODMethod DescType GetProperty();

	protected :
		ODMethod ODObject* GetObject() ;

	private:
		ODObject*	fObject;
		DescType	fProperty;
};

class DrawPartPropAccessor : public AbsDrawPartPropAccessor
{
  public:

	DrawPartPropAccessor(DescType property, AppleTestDraw_DrawPart* part);

	ODMethod void SetData(AEDesc* data);
	ODMethod void GetData(AEDesc* result);
	
	ODMethod AppleTestDraw_DrawPart* GetDrawPart() ;
};

class EmbeddedPartPropAccessor : public AbsDrawPartPropAccessor
{
	public:
		EmbeddedPartPropAccessor( DescType property, ODFrame* frame,
			AppleTestDraw_DrawPart* me ) ;
		
		ODMethod void SetData(AEDesc* data);
		ODMethod void GetData(AEDesc* result);
		
		ODMethod ODFrame* GetFrame() ;
		ODMethod AppleTestDraw_DrawPart* GetThisPart() ;

	private:
		AppleTestDraw_DrawPart* fDrawPart ;
};

#ifdef TO_BE_DELETED
class FramePropAccessor : public AbsDrawPartPropAccessor
{
  public:

	FramePropAccessor(DescType property, ODFrame* frame);

	ODMethod void SetData(AEDesc* data);
	ODMethod void GetData(AppleEvent* reply);

	ODMethod ODFrame* GetFrame() ;
};
#endif // TO_BE_DELETED

class DragPartPropAccessor
{
  public:

	DragPartPropAccessor(DescType property, DragPart* part);

	ODVMethod void SetData(AEDesc* data);
	ODVMethod void GetData(AEDesc* result);

  private:

	DescType	fProperty;
	DragPart*	fPart;
};

#endif // _PRTPRPAC_