// DrPrtNat.h

#ifndef _DRPRTNAT_
#define _DRPRTNAT_

#ifndef _ALTPOINT_
#include "AltPoint.h"			// Use C++ savvy ODPoint and ODRect
#endif

#ifndef _ODTYPES_
#include "ODTypes.h"
#endif

#ifndef SOM_ODFacet_xh
#include <Facet.xh>
#endif

#ifndef SOM_ODSession_xh
#include <ODSessn.xh>
#endif

#include "StdIO.h"
#include "StdLib.h"

#define PlatformX(aPoint) 	((aPoint).x)
#define PlatformY(aPoint)	((aPoint).y)
#define AsPlatformRect(anODRect, aRect)	(anODRect.AsWinRect(aRect))
#define PlatformPtInRect(aPnt, aRectPtr)	(PtInRect(aRectPtr, aPnt))

#define PLATFORMPENCOLOR	HGDIOBJ

void *PlatformNewPtr(size_t theSize);
void *PlatformNewPtrClear(size_t theSize);
void PlatformFreePtr(void *aPtr);
void *PlatformMemCpy(void *dest, const void *src, size_t n);
void *PlatformMemMove(void *dest, const void *src, size_t n);
void PlatformDeleteFont(HFONT aFont);
Point PlatformGetFrameOffset(ODFacet* facet);
ODPlatformWindow PlatformNewWindow(ODSession* aSession, Rect *windRect, ODULong flags);
void PlatformSetWindowPos(ODPlatformWindow aWind, HWND topWnd, RECT *posSizeRect, UINT flags);
void PlatformEraseRect(HDC aDC, RECT *aRect);
void PlatformSetPt(Point *aPnt, int xVal, int yVal);
void PlatformPtFromEvent(ODEventData* event, POINT *p);
HFONT PlatformSelectFont(HDC aDC, HFONT theFont);
HBITMAP PlatformSelectBitmap(HDC aDC, HBITMAP aBMap);
void PlatformDeleteBitmap(HBITMAP aBMap);
HGDIOBJ PlatformSetPenColor(HDC aDC, int theBrushObject);
void PlatformSetPenMode(HDC aDC, int drawMode);
void PlatformMoveTo(HDC aDC, int xPos, int yPos);
void PlatformLineTo(HDC aDC, int xPos, int yPos);
void PlatformGlobalToLocal(Point *aPnt);
void PlatformLocalToGlobal(Point *aPnt);
void PlatformSetCursor(HINSTANCE hinst, LPCSTR cursorName);
void PlatformGetCanvas(HDC *aDC);
void PlatformSetCanvas(HDC aDC);
ODBoolean IsShiftKeyDown(void);
ODBoolean StillDown(ODFacet* facet);

#endif	// _DRPRTNAT_
