/*
	File:		DrawShape.h

	Contains:	DrawShape class used by DrawPart

	Written by:	Jeff Hanson
*/

#ifndef _DRAWSHAP_
#define _DRAWSHAP_

class ODFacet;

enum DrawShapeType {
	kNullShape,
	kRectShape,
	kRoundRectShape,
	kEllipseShape,
	kRectFillShape,
	kRoundRectFillShape,
	kEllipseFillShape,
	kLineShape
};

//==============================================================================
// DrawShape
//==============================================================================

class DrawShape
{
public:
	DrawShape();
	DrawShape(ODFacet* facet, ODRect* bounds, COLORREF fillColor, DrawShapeType aType);
	virtual ~DrawShape();

	virtual void GetBounds(ODRect* theBounds) {*theBounds = fBounds;}
	virtual void SetBounds(ODRect* newBounds);
				
	virtual COLORREF GetFillColor(void) {return fFillColor;}
	virtual void SetFillColor(COLORREF aColor) {fFillColor = aColor;}
				
	virtual DrawShapeType GetType(void) {return fType;}
	virtual void SetType(DrawShapeType aType) {fType = aType;}
				
	virtual ODBoolean GetSelected(void) {return fSelected;}
	virtual void SetSelected(ODBoolean selectFlag) {fSelected = selectFlag;}
				
	virtual ODRgnHandle CreateShapeRgn(DrawShapeType theType, Rect* aBoundsRect, ODPoint* startPt, ODPoint* endPt);
	virtual ODRgnHandle CreateBorderRgn(DrawShapeType theType, Rect* aBoundsRect, ODPoint* startPt, ODPoint* endPt);
	virtual ODBoolean DragCreate(Environment* ev, ODFacet* facet, ODPoint* downPnt, DrawShapeType theType);
	virtual void Draw(ODPlatformCanvas aCanvas);
	virtual void DrawGrowRects(ODPlatformCanvas aCanvas);
	virtual void GetGrowRects(Rect* growRectArr);
	virtual ODBoolean ContainsPoint(ODPoint* aPnt);
	virtual void Invalidate(Environment* ev, ODFrame* frame);
	virtual ODBoolean PtInBorder(ODPoint* aPnt);
	virtual ODSShort PtInResizeBox(ODPoint* aPnt);
	virtual void DragMove(Environment* ev, ODFacet* facet, ODPoint* downPnt);
	virtual void DragResize(Environment* ev, ODFacet* facet, ODPoint* downPnt);

	static COLORREF	fDefaultFillColor;

private:
	ODFacet*		fFacet;
	ODRect			fBounds;
	COLORREF		fFillColor;
	DrawShapeType	fType;
	ODRgnHandle		fRgn;
	ODBoolean		fSelected;
	ODPoint			fStartPt;
	ODPoint			fEndPt;
};

#endif
