/*
	File:		DrawPart.h

	Contains:	Interface to OSL support routines for the DrawPart

	Written by:	Caia Grisar

	Copyright:	c 1993 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		 <3>	 9/29/94	RA		1189812: Mods for 68K build.
		 <2>	 9/23/94	RR		Added forward decl of ODPart
		 <1>	 8/30/94	NP		first checked in
		 <3>	 12/9/93	eeh		added typeFrameProp
		 <2>	 12/1/93	CG		Added type defs for PartProp and
									EmbededPartProp.
		 <1>	11/16/93	CG		first checked in
	To Do:
*/

#ifndef _DRAWOBJ_
#define _DRAWOBJ_

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

//==============================================================================
// Constants
//==============================================================================

enum
{
	typeEmbededPartProp = 'eppr'
	,typePartProp 		= 'pprp'
	,typeFrameProp 		= 'frmp'
};

//==============================================================================
// Temporary constants
//==============================================================================

#define cDrawPart 'draw'
#define cDragPart 'drag'
#define cClockPart 'clck'
#define cTestPart 'test'

//==============================================================================
// Forward Declaration
//==============================================================================

class ODPart;

//==============================================================================
// Event Handlers and Object Accessors and Coercion Handlers.
//==============================================================================
#if 0
//skn#define ODOJBECT_ACCESSOR_PARAMS	ODPart*			thisPart,			
//skn									ODULong			desiredClass,		
//skn									ODOSLToken*	container,			
//skn									ODULong			containerClass,		
//skn									ODULong			form,				
//skn									AEDesc*		selectionData,		
//skn									ODOSLToken*		value,				
//skn									ODSLong			refCon
#endif

//sknODError GetPropertyFromNULL(ODOJBECT_ACCESSOR_PARAMS);
//sknODError GetPartFromNULL(ODOJBECT_ACCESSOR_PARAMS);
//skn//void GetFrameFromNULL(ODOJBECT_ACCESSOR_PARAMS);
//sknODError GetPropertyFromPart(ODOJBECT_ACCESSOR_PARAMS);
//sknODError GetWildcardFromPart(ODOJBECT_ACCESSOR_PARAMS);
//skn//void GetPartFromPart(ODOJBECT_ACCESSOR_PARAMS);
//skn//void GetPropertyFromFrame(ODOJBECT_ACCESSOR_PARAMS);
//sknODError GetWildcardFromList(ODOJBECT_ACCESSOR_PARAMS);
//skn//void GetPropertyFromFrame(ODOJBECT_ACCESSOR_PARAMS);
//skn//void GetPartFromFrame(ODOJBECT_ACCESSOR_PARAMS);

#ifdef PLATFORM_MACINTOSH
ODError HandleSetData(ODPart*		thisPart,
						AppleEvent*	theAppleEvent,
						AppleEvent*	reply,
						ODSLong	handlerRefcon);
						
ODError HandleGetData(ODPart*	thisPart,
					AppleEvent*	theAppleEvent,
					AppleEvent*	reply,
					ODSLong	handlerRefcon);
					
ODError HandleCreate(ODPart*	thisPart,
					AppleEvent*	theAppleEvent,
					AppleEvent*	reply,
					ODSLong	handlerRefcon);

ODError HandleMove(ODPart*	thisPart,
					AppleEvent*	theAppleEvent,
					AppleEvent*	reply,
					ODSLong	handlerRefcon);


ODError CoerceList2RGB(ODPart* thisPart, AEDesc* from, DescType toType,
							ODSLong /*refcon*/, AEDesc* result);

ODError DrawCompare(ODPart* thePart, DescType oper,
		ODOSLToken* obj1, ODOSLToken*	obj2, ODBoolean* result,
		ODSLong refCon);

ODError DrawCount(ODPart* thePart, DescType desiredType,
		DescType containerClass, ODOSLToken* container,
		ODSLong* result, ODSLong refCon);
ODError DrawDisposeToken(ODPart* thePart, ODOSLToken* unneededToken,
		ODSLong refCon);

#endif // PLATFORM_MACINTOSH
#endif // _DRAWOBJ_
