/*
	File:		SEUtils.h

	Contains:	Interface to Semantic Events Utility Functions

	Owned by:	Nick Pilch

	Copyright:	 1993 - 1995 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		 <8>	 2/13/95	eeh		1214783: add GETBYTESOFHANDLE
		 <7>	 1/25/95	eeh		1214783: add FIRSTBYTESFROMHANDLE etc.
		 <6>	 1/16/95	eeh		1211798: remove AllocAndStuff1st4Bytes and
									GetFirstFourBytesFromDataHandle
		 <5>	 9/15/94	NP		1186778: Removed a couple of routines that
									were more usefull for the old way of doing
									tokens.
		 <4>	 8/19/94	NP		1181622: Ownership fix.
		 <3>	 7/19/94	jpa		Use C calling conventions so functions can
									be exported.
		 <2>	  7/1/94	NP		Changed/added some constants.
		 <1>	 6/24/94	NP		first checked in
		 <8>	  2/9/94	NP		Tiger Team cleanup.
		 <7>	  2/7/94	NP		Tiger Team doings.
		 <6>	 12/9/93	eeh		added ThrowIfNotAbsent
		 <5>	11/15/93	eeh		added ThrowIfCantCoerce
		 <4>	10/22/93	NP		Added GetSLongAttr.
		 <3>	 9/10/93	NP		Added some functions.
		 <2>	 8/23/93	NP		Added some utils.
		 <1>	 7/23/93	CG		first checked in
		 <1>	 7/23/93	CG		first checked in
		 <4>	 4/28/93	NP		File name changes.
		 <3>	 3/17/93	NP		Added Pathname2FSSpec declaration.
		 <2>	 3/16/93	NP		Added some methods.
		 <1>	 3/15/93	NP		first checked in

	To Do:
*/

#ifndef _SEUTILS_
#define _SEUTILS_

#ifndef _ODTYPES_
#include "ODTypes.h"
#endif

//#ifndef _SEMTINTF_
//#include "SemtIntf.h"
//#endif

// the type should determine how many bytes are moved....

#define SETBYTESOFHANDLE(h,typ,data,skipbytes)							\
	*((typ*)((*(h))+(skipbytes))) = (data)								\

#define GETBYTESOFHANDLE(h,typ,skipbytes)								\
	*((typ*)((*(h))+(skipbytes)))										\

#define SETFIRSTBYTESOFHANDLE(h,typ,data)								\
	SETBYTESOFHANDLE(h,typ,data,0)										\

#define FIRSTBYTESFROMHANDLE(h, typ)									\
		GETBYTESOFHANDLE(h,typ,0)										\

const ODBoolean kFromTypeIsDesc = kODTrue;
const ODBoolean kFromTypeIsPtr = kODFalse;
const ODBoolean kIsSysHandler = kODTrue;

//ramextern "C" {

//ramODBoolean MissingParams(const AppleEvent* message);
//ramOSErr DecodeOrdinal(AEDesc ordData, long count, long* index,
//ram    				Boolean* allFlag, Boolean* zeroFlag);
//ramODSLong GetSLongAttr(AppleEvent* ae, AEKeyword keyword);

// does an in-place coercion!
//ramvoid ThrowIfCantCoerce( AEDesc* data, DescType desiredType ) ;
//ramvoid ThrowIfNotAbsent( OSErr err ) ;

//ram}

#endif // _SEUTILS_
