/*
	File:		PlatformFile.h

	Contains:	Template for PlatformFile header

	Written by:	Vincent Lo

	Copyright:	c 1993-1994 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		 <1>	10/24/94	jpa		first checked in
		 <7>	 9/14/94	jpa		Removed reference to ODMemoryHeap.
									[1186692]
		 <6>	 8/29/94	T		#1183553 Need to reduce usage of ODFileSpec
									in RlShell.  Added SetPlatformType.
		 <5>	 8/22/94	T		#1182449 Added SetStationery
		 <4>	 6/20/94	RR		ODMemoryHeap* -> ODMemoryHeapID
		 <3>	 6/14/94	CG		Changed references to ODHeap to
									ODMemoryHeap.
		 <2>	  6/2/94	VL		FileSpec* should be FileSpec.
		 <1>	 5/27/94	VL		first checked in

	To Do:
	In Progress:
*/

#ifndef _PLFMFILE_
#define _PLFMFILE_

#ifndef _ODTYPES_
#include "ODTypes.h"
#endif

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef _ODMEMORY_
#include "ODMemory.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

//==============================================================================
// Constants
//==============================================================================
const	ODSShort	kODNoFileRefNum 		= -2;
const	ODSShort	kODMaxFileNameSize		= 64;

//==============================================================================
// Scalar Types
//==============================================================================
typedef int	ODFilePermission;

//==============================================================================
// Classes defined in this interface
//==============================================================================
class PlatformFile;

//==============================================================================
// PlatformFile
//==============================================================================

#ifdef SHIPPING
class PlatformFile
#else
//exported for non-shipping code only! Browser needs it
class ODExport PlatformFile
#endif
{	
public:

	PlatformFile();
	PlatformFile(ODMemoryHeapID where);
	ODVMethod ~PlatformFile();

// Methods you can call when the file is not open:
	// pointing the PlatformFile at a physical file	and setting default opening permissions
	ODMethod void Specify(ODFileSpec fileSpec);
	ODMethod void SpecifyFromFile(PlatformFile* file);
	ODMethod void SetAsciiName(ODSByte* name);
	ODMethod void SetPermission(ODFilePermission filePermission);
	// create/open/delete the file
	ODMethod void Create();
	ODMethod void Open();
	ODMethod void Delete();

// Methods you can call anytime after calling Specify or SetAsciiName
	ODMethod ODBoolean IsStationery();
	ODMethod void SetStationery(ODBoolean isStationery);
	ODMethod ODBoolean Exists();

	ODMethod void FlushVolume();

	ODMethod ODName*	GetName();
	ODMethod void		GetAsciiName(char* name,ODULong maxLength);
	ODMethod ODULong	GetAsciiNameLength();
	ODMethod ODOSType	GetCreator();	// Macintosh specific, $$$$$ should probably be named GetPlatformCreator
	ODMethod ODOSType	GetPlatformType();	// Macintosh specific
	ODMethod void		SetPlatformType(ODOSType fileType);	// Macintosh specific
	ODMethod ODContainerType GetContainerType();
	ODMethod void SetContainerType(ODContainerType containerType);
	ODMethod ODFileSpec	GetFileSpec();
#ifdef PLATFORM_MACINTOSH
	ODMethod void MoveRename( ODFileSpec* newSpec, ODBoolean isDuplicate ) ;
	ODMethod void Move( ODSLong targetParID ) ;
	ODMethod void Rename( Str63 name ) ;
#endif
#ifdef PLATFORM_WINDOWS		
	ODMethod void MoveRename( ODFileSpec newSpec, ODBoolean isDuplicate ) ;
	ODMethod void Move( ODFileSpec ) ;
	ODMethod void Rename( ODFileSpec ) ;
	ODMethod ODFilePermission GetPermission(){return fPermission;};
#endif	
	
// Methods you must call while the file is open	
	ODMethod void Close();

	ODMethod void SetFilePos(ODSShort posMode, ODSLong posOff);
	ODMethod ODSLong GetFilePos();

	ODMethod void Read(ODSByte* buffer, ODSLong* count);
	ODMethod void Write(const ODSByte* buffer, ODSLong* count);

	ODMethod ODSLong GetEndOfFile();
	ODMethod void SetEndOfFile(ODSLong length);

	ODMethod ODSShort	GetFileRefNum();
#ifdef PLATFORM_WINDOWS		
	ODMethod void	SetFileRefNum(ODSShort fileRefNum);
#endif	

	ODMethod void CopyFrom( PlatformFile* src );

private:

	ODFileSpec			fFileSpec;
	ODSShort			fDataRefNum;
	ODFilePermission	fPermission;
	ODOSType			fCreator;
	ODOSType			fFileType;
	ODScriptCode		fScriptTag;
	ODMemoryHeapID 				fHeap;
};

#endif // _PLFMFILE_
