/*
	File:		PlfmDef.h

	Contains:	Platform specific definitions

	Written by:	Richard Rodseth

	Copyright:	c 1993-94 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		 <1>	10/24/94	jpa		first checked in
		 <5>	 8/18/94	T		#1181622 Set Written By: field to Richard
		 <4>	 6/22/94	eeh		include LowMem.h
		 <3>	 6/20/94	T		Added ODQDGlobals
		 <2>	  5/6/94	CG		Translated XMPs to ODs.
		 <1>	  5/5/94	CG		first checked in
		<26>	 3/28/94	CG		1153547: Defined ODSession as
									ODMacSession.
		<25>	  2/7/94	JA		Define ppcinterfaces for benefit of GX
									headers.
		<24>	  2/1/94	JA		Added PLATFORM_MACINTOSH.
		<23>	 1/21/94	CC		Added ODMacLinkSource.
		<22>	12/15/93	NP		Added ODMacUndo.
		<21>	12/14/93	VL		Added ODNVMethod.
		<20>	 12/8/93	RR		Removed ODWindowIterator
		<19>	11/15/93	NP		Changed ODSymbols to ODNameSpaceManager.
		<18>	11/12/93	JBS		added ODFacet, removed ODLayout*
		<17>	11/10/93	CC		Added define for ODLinkSpec
		<16>	 9/10/93	RR		Added ODMenuBar
		<15>	  9/3/93	JBS		added ODLayoutFrameIterator
		<15>	 8/20/93	JBS		Added ODLayout
		<14>	 7/21/93	NP		Added pascal and static #defines.
		<13>	  7/6/93	JBS		Added ODCanvas, ODShape, ODTransform
		<12>	  7/6/93	PH		Add ODStorageSystem
		<11>	  7/2/93	CG		Added SemtIntf, MssgIntf, NamRslvr.
		<10>	  7/2/93	NP		Added NamSpace.
		 <9>	  7/1/93	VL		Added ODClipboard, ODDragAndDrop,
									ODTranslation.
		 <8>	  7/1/93	NP		Added ODLink to #defines.
		 <6>	 6/29/93	RCR		Added Define for ODMacWindow.
		 <5>	 6/24/93	RCR		Added Define for ODMacDispatcher.
		 <4>	 6/17/93	VL		Changed ODUnused.
		 <3>	 4/29/93	VL		8.3 Name Change.
		 <2>	 4/12/93	VL		Added ODUnused.
		 <1>	  4/6/93	VL		first checked in

	To Do:
*/

#ifndef _PLFMDEF_
#define _PLFMDEF_

#ifdef PLATFORM_MACINTOSH
#ifndef __LOWMEM__
//bgn#include <LowMem.h>
#endif
#endif

//==============================================================================
// Macros
//==============================================================================

#define	ODMethod	virtual	
#define ODVMethod	virtual
#define ODNVMethod
#define ODPascal	pascal
#define ODStatic	static

//------------------------------------------------------------------------------
//
// ODUnused is for parameters not used in a function. It is similar to 
// #pragma unused. As a matter of fact, ODUnused can be a pragma statement
// when it functions correctly in C++. For the time being, we have this little 
// macro to get rid of the compiler warnings. Please use this macro instead of
// commenting out the parameter name.

#define ODUnused(x)	((void) &x)

#define ODQDGlobals (*(ODQDGlobalRec*)( *(char**)LMGetCurrentA5() \
							- sizeof(ODQDGlobalRec) + sizeof(GrafPtr)))

//bgn#define BGNBP ;
//bgn#define Str255 			LPSTR
//bgn#define Str63  			LPSTR
//bgn#define StringPtr 		LPSTR
#define fsFromStart 	0
#define Handle			HANDLE
#define Point			POINT
#define RgnHandle		HRGN

#endif	// _PLFMDEF_
