/*
	File:		OrdColl.h

	Contains:	Definition of class OrderedCollection

	Written by:	Richard Rodseth

	Copyright:	c 1993-94 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		 <1>	10/24/94	jpa		first checked in
		 <6>	 6/20/94	RR		ODMemoryHeap* -> ODMemoryHeapID
		 <5>	 6/14/94	RR		Added forward declaration ODMemoryHeap
		 <4>	  6/9/94	RR		Remove ASLM stuff
		 <2>	 5/10/94	RR		Removed ASLM_COMPATIBLE/CDECL
		 <1>	  5/5/94	CG		first checked in
		 <9>	 3/15/94	MB		Changes to support SCpp/ASLM builds,
									#1150864.
		 <8>	  2/9/94	T		add a couple of explicit "virtual" to the
									class declaration to pacify ASLM
		 <7>	  2/7/94	JA		Tiger Team Makeover!
		 <6>	  2/2/94	NP		Added support for allocating internal
									structures in given heap.
		 <5>	 12/7/93	NP		Added helpful comments, because PEOPLE
									AREN'T COMMENTING HEADER FILES!!!!!
		 <4>	11/19/93	PH		ASLM fix - add class id for ValueLink
		 <3>	11/19/93	NP		Add definition of ValueLink to here (to
									allow subclassing.)
		 <1>	 8/13/93	RCR		first checked in

	To Do:
*/

#ifndef _ORDCOLL_
#define _ORDCOLL_

#ifndef _ODTYPES_
#include "ODTypes.h"
#endif

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef _LIST_
#include "List.h"
#endif

#ifndef _ODMEMORY_
#include "ODMemory.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

// OrdereCollection is an ordered collection of elements of type void* (since
// we can't use templates)
// Duplicates are allowed.

//==============================================================================
// Constants
//==============================================================================

//==============================================================================
// Scalar Types
//==============================================================================

typedef void* ElementType;

//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class ODExport OrderedCollection;	// An ordered (not sorted) collection of ElementTypes
class ODExport OrderedCollectionIterator;

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class ValueLink; 			// A link plus a value of type ElementType.

//=====================================================================================
// Global Variables
//=====================================================================================

//=====================================================================================
// Class ValueLink - Definition
//=====================================================================================

class ValueLink : public Link {
	
public:
							ValueLink(ElementType value);		
	ODVMethod 			   ~ValueLink();
	ODNVMethod	ElementType	GetValue()						{ return fValue;}
	ODNVMethod void		SetValue(ElementType v)			{ fValue = v;}

private:
	ElementType 		fValue;
};

//=====================================================================================
// Class OrderedCollection
//=====================================================================================

class ODExport OrderedCollection
{
	
public:

	OrderedCollection();
	OrderedCollection(ODMemoryHeapID where);
	virtual ~OrderedCollection();

	ODNVMethod ODULong Count() const 			{ return fImplementation.Count(); };
	
	ODVMethod void	AddFirst(ElementType element);
	ODVMethod void	AddLast(ElementType element);
	ODVMethod void	AddBefore(ElementType existing, ElementType tobeadded);
	ODVMethod void	AddAfter(ElementType existing, ElementType tobeadded);

	ODVMethod ElementType	After(ElementType existing);
	ODVMethod ElementType	Before(ElementType existing);

	ODVMethod ElementType	First();
		// Returns kODNULL if there is no first element.
	ODVMethod ElementType	Last();

	ODVMethod ElementType	RemoveFirst();
		// Don't call if there are no elements. Crash will result.
	ODVMethod ElementType	RemoveLast();
	ODVMethod void	RemoveAll();
	
		// Called from the destructor. Removes all elements, deleting the links
		// Does not delete the elements themselves
		
	ODVMethod void	DeleteAll();
	
		// Removes and deletes all elements
		
	ODVMethod void	Remove(ElementType existing);
	ODVMethod ODBoolean	Contains(ElementType existing);
	
	ODVMethod OrderedCollectionIterator* CreateIterator();

protected:
	 ODVMethod ValueLink* 	CreateNewLink(ElementType value) const;
	 ODVMethod ODBoolean	ElementsMatch(ElementType v1,ElementType v2) const;
	 	// Does a pointer comparison by default 

private:
	LinkedList		fImplementation;
	ODMemoryHeapID	fHeap; // if kODNULL, use default heap.

	friend class OrderedCollectionIterator;
	friend class ListIterator;
};

//=====================================================================================
// Class OrderedCollectionIterator
//=====================================================================================

class ODExport OrderedCollectionIterator {
public:
	OrderedCollectionIterator(OrderedCollection* collection);
	~OrderedCollectionIterator();
	ElementType	First();
	ElementType	Next();
	ElementType	Last();
	ElementType	Previous();
	ODBoolean	IsNotComplete();
	
private:
  	OrderedCollection*	fCollection;
	LinkedListIterator	fImplementation;
};

#endif // _ORDCOLL_
