/* $HEADER$ */
/*
	File:		OLEMgrW.h

	Contains:	definition of XMPOLEManager class

	Written by: Brad Nicholes

	Copyright: (c) 1994 by WordPerfect Corporation, all rights reserved.

*/
#ifndef _OLEMGRW_
#define _OLEMGRW_

#ifndef _ODTYPES_
#include "odtypes.h"
#endif

#ifndef _PLFMDEF_
#include "plfmdef.h"
#endif

//==============================================================================
// Classes defined in this interface
//==============================================================================
class ODOLEManager;

//==============================================================================
// Classes used by this interface
//==============================================================================
							
//==============================================================================
// ODOLEManager
//==============================================================================

class ODOLEManager
{	

public:

	ODOLEManager();
	virtual ~ODOLEManager();

	ODMethod	BOOL	Initialize(LPSTR CmdLine);
	// Initialize OLE2 and filter out any OLE-specific command line parameters
	// that would not otherwise be expected by the OpenDoc shell program.

	ODMethod	BOOL 	Terminate();
	// Terminate OLE2

	ODMethod	BOOL	IsOleServer() 		 { return fIsOleServer; };
	// Returns TRUE if this process was run as an OLE embedding server, where
	// the command line contained a "-Embedding" parameter.

	ODMethod	BOOL	IsAutomationServer() { return fIsAutomationServer; };
	// Returns TRUE if this process was explicitly run as an OLE automation
	// server where the command line contained a "-Automation" parameter.

	ODMethod	BOOL 	RegisterOleFactory(BOOL	fRegWithOLE);
	// Register the OleWrapper object's class factory with COM when the shell
	// initializes

	ODMethod	void		IdleTimeCallback();
	// A shell must call this method when it detects idle time so that the
	// OleManager can update cached presentation information on a regular
	// basis.

	ODMethod	BOOL		GetMessageCallback(MSG *msg);
	// A shell calls this method from ::Run() whenever a message is pulled off
	// the application's message queue so that an OpenDoc part will get
	// re-activated properly when running in inside-out mode in an OLE app.
	//
	// If the function ever returns TRUE, the ::Run() mesage loop must be
	// terminated immediately.

	ODMethod	void		SetActiveObject(LPVOID pObject, LPVOID pclsid);
	// Register the active object for OLE automation to use. This is normally
	// the OleWrapper object, when we are open in SDI mode.

	ODMethod	void		ExportClipboard();

	ODMethod	void		ActiveFocusChanging( void *frame );
	// The opendoc active part is changing. If we are running in OLE, we may
	// need to hide or show our hairy border around the outside of the shell
	// window.

private:
	BOOL	fInitialized;
	BOOL	fIsOleServer;
	BOOL	fIsAutomationServer;
	BOOL	fOleInitialized;
	LPVOID  fOleWrapperClassFactory;
	LPVOID  fAppClassFactory;
	DWORD	fFactoryKey;
	DWORD	fLastTickCount;		
	DWORD	fdwRegisterActive;
};


#endif //OLEMGRW
