/*
	File:           ODTypesF.h

	Contains:       Definitions for Foreign types which can't be described in IDL

	Written by:     Richard Rodseth

	Copyright:      c 1994 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		<10>     9/23/94        RR              Removed forward declaration of ODPart
		 <9>     8/18/94        T              #1181622 Set Richard to the Written By:
									field
		 <8>     7/26/94        eeh             remove typedef of ODQDPoint
		 <7>     7/19/94        jpa             Include QDFixM.h.
		 <6>     6/20/94        T              Added ODQDGlobalRec
		 <5>     6/15/94        jpa             Added ODQDPoint definition.
		 <4>     6/13/94        NP              Added comment after endif
		 <3>      6/7/94        CG              Commented out def for GetIndString.
		 <2>     5/23/94        RR              Added ODPlatformType
		 <2>      4/4/94        RR              XMP -> OD

	To Do:
*/

#ifndef _ODTYPESF_
#define _ODTYPESF_

#ifdef OSL_BUILD
#include "OSLDefs.h"
#endif //OSL_BUILD

#ifdef PLATFORM_WINDOWS
#include <windows.h>
#include <windowsx.h>
#ifdef DEBUG_VALIDATION
#ifndef _RCDEBUG_
#include "rcdebug.h"
#endif
#endif

#endif

// This is a handmade file, where Macintosh-specific types, defined as ODForeign in the IDL files,
// are defined.
// This file is included in ODObject.xh by a "passThru" statement in ODObject.idl


#ifdef PLATFORM_MACINTOSH
#ifndef __TYPES__
//BGN#include <Types.h>
#endif

#ifndef __FILES__
//bgn#include <Files.h>
#endif

#ifndef _QDFIXM_
//BGN#include <QDFixM.h>
// This header fixes problems with the incorrect use of the 'frame'
// constant defined in QuickDraw.h ... see comments in QDFixM.h for details.
#endif

#ifndef __QUICKDRAW__
//bgn#include <QuickDraw.h>
#endif

#ifndef __WINDOWS__
//bgn#include <Windows.h>
#endif

#ifndef __MENUS__
//bgn#include <Menus.h>
#endif

#ifndef __AEREGISTRY_
//bgn#include <AERegistry.h>
#endif

#ifndef __TIME_H__
//bgn#include <time.h>
#endif

#ifndef __FIXMATH__
//bgn#include <FixMath.h>                       // Must include before GX headers...
#endif
#ifndef graphicsTypesIncludes
//bgn#include <graphics types.h>                // Another fine GX header
#endif
#endif

#ifdef PLATFORM_WINDOWS

#ifndef __TIME_H__
#include <time.h>
#endif

#endif

#define kODNULL   0

#define ODVersionString "1.0.0b1c1"

//#define GetIndString getindstring

typedef time_t ODTime;

// File System

typedef char*   ODFileSpec;
typedef short   ODScriptCode;
typedef short   ODLangCode;
typedef short   ODFileRefNum;

// Runtime

#ifdef PLATFORM_WINDOWS
#ifndef OSL_BUILD
// Win::Processe.h
/* type for unique process identifier */
struct ProcessSerialNumber {
	 unsigned long lowLongOfPSN;
	 unsigned long highLongOfPSN;
};
#endif //OSL_BUILD

typedef struct ProcessSerialNumber ProcessSerialNumber;
typedef ProcessSerialNumber *ProcessSerialNumberPtr;
#endif

typedef ProcessSerialNumber     ODProcessID;

typedef unsigned long   ODOSType;
typedef ODOSType                ODPlatformType;    // Host platform file & data type

// Imaging

typedef HDC             ODPlatformCanvas;

/* $$$$$
typedef Fixed                   ODFixed;                                // fixed-point (16.16) value
*/
//bgn typedef Region            ODRegion;
//bgn typedef RgnPtr                    ODRgnPtr;       
typedef HRGN    ODRgnHandle;
typedef HRGN    ODPlatformShape;                // Graphics-system-dependent shape data
typedef POINT   ODPlatformTransform;    // Graphics-system-dependent transform data
//bgn typedef gxShape           ODgxShape;

//bgn typedef struct
//bgn {
//bgn   char    privates[76];
//bgn   long    randSeed;
//bgn   BitMap  screenBits;
//bgn   Cursor  arrow;
//bgn   Pattern dkGray;
//bgn   Pattern ltGray;
//bgn   Pattern gray;
//bgn   Pattern black;
//bgn   Pattern white;
//bgn   GrafPtr thePort;
//bgn }
//bgn ODQDGlobalRec;

// Windows

typedef HWND    ODPlatformWindow;

// Menus

typedef struct tagodplatformmenu {
	HMENU menu;
	char strMenu[256];
} ODPlatformMenu;

typedef HMENU   ODPlatformMenuBar;

// Semantic Interface

#ifdef PLATFORM_MACINTOSH
typedef AEDesc                  ODObjectSpec;
#endif

#ifdef PLATFORM_WINDOWS
//typedef LPSTR                         ODObjectSpec;
typedef ODPlatformWindow        WindowPtr;
typedef ODRgnHandle                     RgnHandle;
typedef RECT                            Rect;
typedef POINT                           Point;
typedef HMENU                           MenuHandle;
typedef HACCEL                          ODPlatformAccel;
typedef unsigned long   ODTimerFrequency;
typedef ODScriptCode            ScriptCode;
typedef ODLangCode                      LangCode;

#ifndef OSL_BUILD
typedef LPSTR                           StringPtr;
typedef char                            Str255[256];
#endif  //OSL_BUILD

typedef char                            Str63[64];
typedef WPARAM                          ODWParam;
typedef LPARAM                          ODLParam;
typedef LRESULT                 ODLResult;
typedef DWORD                           HPROCESS;


typedef long                            OSErr;
typedef ODOSType                        OSType;

#define fixed1          (0x00010000L)
#define FixedToInt(a) ((short)(((long)(a) + fixed1/2) >> 16))
#define IntToFixed(a) ((long)(a) << 16)
#define ff(a)           IntToFixed(a)

#define ODNewRgn()  CreateRectRgn(0,0,0,0);
#define LONG2POINT(l,pt)        ((pt).x=(SHORT)LOWORD(l), (pt).y=(SHORT)HIWORD(l))

#define kODAsk                          0
#define kODYes                          1
#define kODNo                           2

#ifdef __BORLANDC__
#define DllExport __export
#else
#define DllExport __declspec(dllexport)
#endif

//bgn#define DllImport __declspec(dllimport)
#define ODExport DllExport
//bgn#define XMPImport DllImport
//bgn#define _export DllExport
//bgn#define __export DllExport
//bgn#define XMPFar
//bgn#define far
//bgn#define _far
//bgn#define __far
//bgn#define __huge
//bgn#define _huge
//bgn#define huge
//bgn#define XMPCLASS XMPExport


#if (defined (WIN32) || defined (MSVC20))
//TAG - these macros are defined to avoid compile problems with the new OLE string types.
#define LPODSTR         LPOLESTR
#define LPCODSTR        LPCOLESTR
#else
#define LPODSTR         LPSTR
#define LPCODSTR        LPCSTR
#endif

#define BGNBP   _asm { int 3 };
#define _BGNBP  ;
#endif

//bgn struct ODOSLToken
//bgn {
//bgn   DescType        descriptorType;
//bgn   Handle          dataHandle;
//bgn };


// apple event defines and types

typedef unsigned long           ResType;
typedef ResType DescType;
#define LONGCONST(a,b,c,d) ((((unsigned long)a)<<24) | (((unsigned long)b)<<16) | (((unsigned long)c)<<8) | (unsigned long)d)

// end apple event stuff


#endif // _ODTYPESF_
