/* $HEADER$ */
/*
	File:		ODShell.h

	Contains:	definition of XMPShell class

	Written by: Brad Nicholes

	Copyright: (c) 1994 by WordPerfect Corporation, all rights reserved.

*/


#ifndef _ODSHELL_
#define _ODSHELL_

#ifndef _ODTYPES_
#include "ODTypes.h"
#endif

#ifndef _ODUTILW_
#include "ODUtilW.h"
#endif

#ifndef SOM_ODSemanticInterface_xh
#include "semtintb.xh"
#endif

#ifdef LATER
#ifndef _OLEWRAP_
#include "olewrap.h"
#endif
#endif

#ifndef SOM_ODWindowState_xh
#include "winstat.xh"
#endif

#ifndef SOM_ODDispatcher_xh
#include "disptch.xh"
#endif

#ifndef _OLEMGRW_
#include "olemgrw.h"
#endif

#ifndef _DOCSHELL_
#include "docshell.h"
#endif


#include <ddeml.h>

//==============================================================================
// Theory of Operation
//==============================================================================

/*
	The Shell contains all code which interfaces a particular platform's
	user interface with the OpenDoc parts underneath.
	Each document is run in its own process.

*/

//==============================================================================
// Constants
//==============================================================================


//-------------------------------------------------------------------------------------
// Menus
//-------------------------------------------------------------------------------------

#define kODUser				0
#define kODClientWnd		4
#define	kODDocShell			8

//-------------------------------------------------------------------------------------
// OSType constants
//-------------------------------------------------------------------------------------

#define ODTimerID			1357	// ID number used when dealing with a windows timer
#define ODSysSpeedConstant	12345	// Just some arbitrary number.

//-------------------------------------------------------------------------------------
// Window Class Names
//-------------------------------------------------------------------------------------
#define kODSessionWndClass		"ODSessionWndClass"
#define kODDocumentWndClass		"ODDocumentWndClass"
#define kODRootWndClass			"ODRootWndClass"

//==============================================================================
// Classes defined in this interface
//==============================================================================
class ODExport ODShell;

ODShell* GetCurrentShell();
INSTANCENODE* GetGlobals();

extern HINSTANCE	ghDllInstance;

typedef struct shelllistnode {
	HWND hShellWnd;
	struct shelllistnode *pNext;
	ODBoolean isFloating;
} SHELLLISTNODE, *PSHELLLISTNODE;
													

//==============================================================================
// Classes used by this interface
//==============================================================================
class ODSession;
class ODWindowState;
class ODExport DocShell;
class ODOLEManager;
#ifdef LATER
class XMPSemanticInterface;
#endif
class ODInPlaceFrame;
							
//==============================================================================
// ODShell
//==============================================================================

class ODExport ODShell
{	

public:
	DocShell*       fDocShellList;                                                                                  //OLE2

	ODShell();
	virtual ~ODShell();

	ODMethod	ODBoolean	HandleSessionEvents(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);

	ODMethod	ODBoolean 	Initialize(HINSTANCE hInstance, int nCmdShow,LPSTR CmdLine);
	ODMethod	ODBoolean 	Terminate();

	ODMethod	HMENU		GetBaseMenuBar() = 0;
	ODMethod	HACCEL		GetBaseAcceleratorTable() = 0;
	ODMethod	ODMenuBar*	GetMenuBar () { return fMenuBar; };

	ODMethod	ODBoolean	RegisterSessionWndClass();
	ODMethod	ODBoolean	RegisterDocumentWndClass();
	ODMethod	ODBoolean	RegisterRootWndClass();
	ODMethod	ODSShort 	Run();	

	ODMethod	HWND		CreateSessionWindow();
	ODMethod	HWND 		CreateDocumentWindow(ODBoolean isFloating);
	ODMethod	HWND		CreateRootWindow(HWND hParent, DWORD dwFlags);

	ODMethod	LRESULT		DispatchEvent(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

	ODMethod    HWND        GetSessionWindow() { return fWndSession; };
	ODMethod	HWND 		GetClientWindow();
	ODMethod	void		SetClientWindow(HWND hWnd){fClientWnd = hWnd;};
	ODMethod	DocShell*	GetDefaultDocShell () { return fDefDocShell; };
	ODMethod	void		SetDefaultDocShell (DocShell* pDocShl) { fDefDocShell = pDocShl; };
	ODMethod	HWND		GetDefaultDocShellWnd() { return fWndDefDocShell; };
	ODMethod	HINSTANCE	GetInstance() { return fInstance; };
	ODMethod	ODSession*	GetSession() { return fSession; };
	ODMethod	DWORD		GetTimerFrequency(){return fTimerInterval;};
	ODMethod	ODOLEManager* GetOLEManager() {return fOLEManager;};
	ODMethod	ODWindowState* GetWindowState() {return fWindowState;};

	/* Create a doc shell object                                                    //OLE2
	 */                                                                                                                                     //OLE2
	ODMethod       DocShell*       CreateDocShell(LPSTR,LPSTR,BOOL) = 0;                        //OLE2
																		//OLE2
	/* Destroy the given doc shell                             			//OLE2
	 */                                                        			//OLE2
	ODMethod	void    DestroyDocShell(DocShell*) = 0;        			//OLE2
															   			//OLE2
	/* Flag to indicate whether this shell is in MDI or SDI mode 		//OLE2
	 */                                                          		//OLE2
	ODMethod    BOOL	GetIsMDI() = 0;                          		//OLE2
																 		//OLE2
	/* User readable name of this shell application              		//OLE2
	 */                                                          		//OLE2
	ODMethod    void	GetShellName(LPSTR, ULONG) = 0;          		//OLE2
																 		//OLE2
	/* Methods to access the status bar text (MDI case only)     		//OLE2
	 */                                                          		//OLE2
	ODMethod    void    GetStatusBarText(LPSTR, ULONG);          		//OLE2
	ODMethod    void    SetStatusBarText(LPSTR);                 		//OLE2
																 		//OLE2
	/* IsInteractive flag turns user input ON or OFF so that when    	//OLE2
	 * the shell is under script control the user cannot interfere.  	//OLE2
	 */                                                              	//OLE2
	ODMethod    BOOL	GetIsInteractive();               				//OLE2
	ODMethod    void  	SetIsInteractive(BOOL);           				//OLE2
																	 	//OLE2
	ODMethod    LPVOID  GetAppObject();                                 //OLE2                  //OLE2
																		//OLE2

   	ODMethod	void 		InitAE();
				void		InstallObjectAccessors(ODSemanticInterface* theSI);

	ODMethod	PSHELLLISTNODE	GetSessionWndList() { return fShellWndList; };
	ODMethod	void		SetSessionWndList(PSHELLLISTNODE p) { fShellWndList = p; };

	ODMethod	void		ExportClipboard();

 	ODMethod	BOOL 		InitDDE(void);
	ODMethod	void 		ShutDownDDE(void);

	static BOOL CALLBACK About(ODPlatformWindow hDlg,UINT message,UINT wParam,ODSLong lParam);

private:

	BOOL        	fInteractive;                                                                           //OLE2
	ODDispatcher	*fDispatcher;
	HWND			fWndDefDocShell;
	HWND			fWndSession;
	LONG			fMinTimerInterval;
	LONG			fTimerInterval;
	ODMenuBar*		fMenuBar;
	HACCEL			fAccel;
	Environment*	fEV;
	ODOLEManager*	fOLEManager;
	DocShell*		fDefDocShell;
	HWND			fClientWnd;
	PSHELLLISTNODE	fShellWndList;
	DocShell*		fDocShellLink;

public:
	ODSession* 		fSession;
	ODWindowState*	fWindowState;
	HINSTANCE		fInstance;
	LPVOID          fAppObject;                                                                                     //OLE2
	LPOLEINPLACEACTIVEOBJECT	fIOleIPActiveObject;
	ODInPlaceFrame*	fIOleInPlaceFrame;

//-------------------------------------------------------------------------------------
//data for Apple Events/DDEML	
//-------------------------------------------------------------------------------------
	DWORD				fDDEInst;				//DDE Instance
	HSZ					fHSZService;			//handle to service name
	HSZ					fHSZTopic;				//handle to topic name
	HCONV				fDDEConvEstabl;			//handle to DDEML conversation

};


#endif	// _ODSHELL_
