/*
	File:		ISOStr.h

	Contains:	Routines to manipulate XMPISOStr

	Written by:	Steve Smith, Vincent Lo.

	Copyright:	c 1993-1994 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		 <1>	10/24/94	jpa		first checked in
		 <4>	 9/29/94	RA		1189812: Mods for 68K build.
		 <3>	  6/1/94	VL		Changed XMP to OD.
		 <1>	  5/5/94	CG		first checked in
		 <4>	11/23/93	VL		Added overloaded XMPISOStrCopy, overloaded
									XMPISOStrCompare and XMPISOStrConcat.
		 <3>	 11/5/93	NP		Added ISOStrEqual and cleaned up interfaces
									to other routines.
		 <2>	 7/23/93	VL		Changed _ISOSTRING_ to _ISOSTR_.

	To Do:
*/

/************************************************************

	ISOString.h
	ISO String handling
	
	Copyright Apple Computer,Inc. 1993
	All rights reserved

************************************************************/


#ifndef _ISOSTR_
#define _ISOSTR_

#ifndef _ODTYPES_
#include "ODTypes.h"
#endif


#ifdef __cplusplus
extern "C" {
#endif

ODISOStr	ODExport ODISOStrCopy (ODISOStr dest, const ODISOStr source);
ODISOStr	ODExport ODISOStrNCopy (ODISOStr dest, const ODISOStr source, ODULong length);
ODISOStr	ODExport ODISOStrConcat (ODISOStr dest, const ODISOStr source);
ODISOStr	ODExport ODISOStrNConcat (ODISOStr dest, const ODISOStr source, ODULong length);
ODSLong	ODExport 	ODISOStrCompare (const ODISOStr iso1, const ODISOStr iso2);
ODSLong	ODExport 	ODISOStrNCompare (const ODISOStr iso1, const ODISOStr iso2, ODULong length);	// note the "N"!
ODBoolean ODExport 	ODISOStrEqual (const ODISOStr iso1, const ODISOStr iso2);
ODULong	 ODExport 	ODISOStrLength (const ODISOStr iso);
ODISOStr	ODExport ODISOStrFromCStr(const char* cstring);

#ifdef __cplusplus
}
#endif

#endif // _ISOSTR_
