/*
	File:		FragRsrc.h

	Contains:	Functions for using the resource fork of a code fragment

	Written by:	Jens Alfke

	Copyright:	c 1994 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		 <1>	10/24/94	jpa		first checked in

*/

#ifndef __FRAGRSRC__
#define __FRAGRSRC__

#ifndef __FRAGLOAD__
#include <FragLoad.h>	// Should be CodeFragments.h; change when MW revs hdrs
#endif


#ifdef __cplusplus
extern "C" {
#endif

#pragma lib_export on

typedef struct CFragResFile *CFragResFileRef;

OSErr	InitCFragResources( InitBlockPtr, CFragResFileRef * );
OSErr	FSpInitCFragResources( const FSSpec *, CFragResFileRef * );
OSErr	TermCFragResources( CFragResFileRef );
OSErr	BeginCFragResources( CFragResFileRef );
OSErr	EndCFragResources( CFragResFileRef );

#pragma lib_export off

#ifdef __cplusplus
}
#endif

#endif /*__FRAGRSRC__*/
