/*
	File:		EditrSet.h

	Contains:	Class definition for EditerSet and ODEditerSetIterator

	Owned by:	Eric House 

	Copyright:	c 1993-94 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		 <1>	10/24/94	jpa		first checked in
		 <2>	 8/24/94	CG		#1181622: Updated ownership info.
		 <1>	 6/23/94	eeh		first checked in
	To Do:
*/

#ifndef _EDITRSET_
#define _EDITRSET_

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef _ODOBJ_
#include "ODObject.xh"
#endif

#ifndef _ODTYPES_
#include "ODTypes.h"
#endif


//=====================================================================================
// Classes used by this interface
//=====================================================================================

class EditorSetIterator ;
class OrderedCollection;
class OrderedCollectionIterator;

//=====================================================================================
// Class EditorSet
//=====================================================================================
// Should these routines have more generic names like "Add" and "Remove", so there's more
// consistency with other set classes, like ODTypeList?

class EditorSet
{
	
public:

	EditorSet();
	void InitEditorSet();
	virtual ~EditorSet();

	ODMethod void AddEditor(ODEditor editor);
	
		// Adds an type to the end of the set, creating a copy of the argument in the set.

	ODMethod void AddEditorSet(EditorSet* editors);
	
		// Unions the two into this (leaving the argument unchanged).

	ODMethod void RemoveEditor(ODEditor editor);
	
		// Removes an editor from a set.  Does nothing if the argument editor is not present.
	
	ODMethod void RemoveEditor(const EditorSet& set);
	
		// Removes all editors present in the argument set.

	ODMethod ODBoolean ContainsEditor(ODEditor editor);
	
		// Returns true if the set contains the specified editor.
		// Otherwise, returns false.

	ODMethod ODULong GetEditorCount();
		
	ODMethod EditorSetIterator* CreateIterator();
	
		// Returns an iterator for the set, which can be used to retrieve editors
		// from the set in order.

private:

	OrderedCollection*	fSet;

	Environment*	fEv;

	friend class EditorSetIterator;
};
	
//=====================================================================================
// Class EditorSetIterator
//=====================================================================================

class EditorSetIterator
{
	

	public:
		EditorSetIterator(EditorSet* set);
		virtual ~EditorSetIterator();

		ODVMethod ODEditor	First();
		ODVMethod ODEditor	Next();
		ODVMethod ODBoolean	IsNotComplete();
		
			// These methods return a pointer to a string within the set.
			// The client must not dispose this memory, and must be aware that
			// These methods return nil if the requested item does not exist.
		
	private:
		OrderedCollectionIterator*	fIterator;
};


#endif
