/*
	File:		ConstDef.h

	Contains:	Global internal constants for the Macintosh implementation of
				OpenDoc

	Owned by:	Nick Pilch

	Copyright:	c 1993-94 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		 <3>	 8/19/94	NP		1181622: Ownership fix.
		 <2>	 7/29/94	CG		Changed vers constants to 1.0a8.
		 <1>	 6/21/94	CC		first checked in
		------------------- CC ---- Converted to SOM
		 <7>	 4/18/94	T		a6
		 <6>	 3/28/94	CG		1150376: Changed version to force creation
									of new prefs files.
		 <5>	 3/23/94	CG		#1151393: Consts for use in vers resources.
		 <4>	 3/18/94	CC		Added defines for ISO string versions of
									Apple scrap types.  (1151636)
		 <3>	 3/17/94	CG		#1151392: Moved kOpenDocShellSignature to
									StdDefs.h
		 <2>	 1/18/94	CC		Added kXMPScrapTypePart.
		 <1>	 12/1/93	NP		first checked in

	To Do:
*/

#ifndef _CONSTDEF_
#define _CONSTDEF_

//==============================================================================
//							Default definitions for 'vers' 1
//==============================================================================
#define	kODv1MajorBCD		0x1
#define	kODv1MinorBCD		0x0
#define	kODv1RelStage		alpha

/*
		// Release stage
	development = 0x20,
	alpha = 0x40,
	beta = 0x60,
	final = 0x80,
		// OR    release = 0x80;
*/

#define	kODv1NFRelease		0x8
#define	kODv1Region			0					// always verUS (0)
#define	kODv1ShortString	"1.0a8"
#define	kODv1LongString		"1.0a8, c Apple Computer, Inc. 1993-1994."



//==============================================================================
//							Default definitions for 'vers' 2
//==============================================================================
#define	kODv2MajorBCD			kODv1MajorBCD
#define	kODv2MinorBCD			kODv1MinorBCD
#define	kODv2RelStage			kODv1RelStage
#define	kODv2NFRelease			kODv1NFRelease
#define	kODv2Region				kODv1Region
#define	kODv2ShortString		kODv1ShortString
#define	kODv2LongString			"OpenDoc 1.0a8"
#define	kODShellv2LongString	"OpenDoc Shell 1.0a8"


//==============================================================================
// Constants
//==============================================================================

// Scrap Types
#define kODScrapTypePart 'odcn'

// ISOString equivalents for Apple scrap types
#define		kODApplePart			"Apple:OSType:Scrap:odcn"
#define		kODAppleBITMAP			"Apple:OSType:Scrap:BMPW" /* CF_BITMAP */	 //OLE2
#define		kODAppleMETAFILEPICT   	"Apple:OSType:Scrap:MFPW" /* CF_METAFP */ 	 //OLE2
#define		kODAppleSYLK			"Apple:OSType:Scrap:SYLW" /* CF_SYLK */		 //OLE2
#define		kODAppleDIF				"Apple:OSType:Scrap:DIFW" /* CF_DIF */		 //OLE2
#define		kODAppleTIFF			"Apple:OSType:Scrap:TIFW" /* CF_TIFF */		 //OLE2
#define		kODAppleOEMTEXT			"Apple:OSType:Scrap:OEMW" /* CF_OEMTEXT */	 //OLE2
#define		kODAppleDIB				"Apple:OSType:Scrap:DIBW" /* CF_DIB */		 //OLE2
#define		kODApplePALETTE			"Apple:OSType:Scrap:PALW" /* CF_PALETTE */	 //OLE2
#define		kODApplePENDATA			"Apple:OSType:Scrap:PENW" /* CF_PENDATA */	 //OLE2
#define		kODAppleRIFF			"Apple:OSType:Scrap:RIFW" /* CF_RIFF */		 //OLE2
#define		kODAppleWAVE			"Apple:OSType:Scrap:WAVW" /* CF_WAVE */		 //OLE2
#define		kODAppleTEXT	"Apple:OSType:Scrap:TEXT"
#define		kODApplestyl	"Apple:OSType:Scrap:styl"
#define		kODApplePICT	"Apple:OSType:Scrap:PICT"
#define		kODApplestxt	"Apple:OSType:Scrap:stxt"
#define		kODApplehfs		"Apple:OSType:Scrap:hfs "
#define		kODApplealis	"Apple:OSType:Scrap:alis"
#define		kODApplesect	"Apple:OSType:Scrap:sect"
#define		kODAppleITEM  	"Apple:OSType:Scrap:ITEM" /* Item moniker */		 //OLE2

#endif // _CONSTDEF_
