/*
	File:           AltPoint.h

	Contains:       C++ savvy points and rects (alternate ODPoint, ODRect)

	Written by:     Jens Alfke

	Copyright:      c 1993-94 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		 <1>    10/24/94        jpa             first checked in
		 <2>     6/15/94        jpa             Include ODTypesF.h.
		 <1>     5/23/94        RR              first checked in
		 <1>     2/16/94        JA              first checked in
		----------------------------Moved to TestParts, renamed AltPoint.
		 <2>      2/3/94        JA              Tiger Team Makeover!
		 <1>    11/29/93        JA              first checked in
		----------------------------Moved from Utilities to Imaging project
		 <2>    11/23/93        JA              Added inline Set method.
		 <1>     10/6/93        JA              first checked in

	To Do:
	
	Notes:
	
	These are alternate definitions of the ODPoint and ODRect structs.
	These definitions have the same size and data format and can be used
	interchangeably with the basic definitions; but they're much more C++
	savvy, with constructors, operators, conversions, and utility methods.
	
	To use these classes instead of the defaults, just include "AltPoint.h"
	as the first thing in your source file. It has to be included first so
	it can override the default struct definitions in PlfmType.h.
	
	This API and implementation are **NOT** an official part of the OpenDoc
	API, just handy utilities for C++ programmers.
*/


#ifndef _ALTPOINT_
#define _ALTPOINT_

// Make sure that built-in structs do not get defined by PlfmType.h.
#if !defined(SOM_Module_OpenDoc_GeoTypes_defined)
	#define SOM_Module_OpenDoc_GeoTypes_defined
#else
	#error "Must include AltPoint.h *before* ODTypes.h!"
#endif


#ifndef _ODTYPESF_
#include "ODTypesF.h"           // Must include before ODTypesM.xh
#endif

#ifndef SOM_Module_OpenDoc_Global_Types_defined
#include "ODTypesM.xh"          // For ODCoordinate
#endif

#ifndef __TYPES__
#include <sys\Types.h>
#endif

struct ODExport ODPoint;
struct ODExport ODRect;

//==============================================================================
// ODPoint
//==============================================================================

struct ODExport ODPoint {
	public:
	
	// CONTENTS:
	
	ODCoordinate x, y;
	
	// CONSTRUCTORS:
	
	ODPoint( ) { }
	
	ODPoint( ODCoordinate xx, ODCoordinate yy )
					{x=xx; y=yy;}
	
	ODPoint( const ODPoint& );                              // Copy constructor
	
	// ASSIGNMENT:
	
	ODPoint& operator= ( const ODPoint& );  // Copy from another pt
	
	// MODIFICATION:
	
	inline void     Clear( )
					{x=y=0;}
	inline void     Set( ODCoordinate xx, ODCoordinate yy )
					{x=xx; y=yy;}
	void    Offset( ODCoordinate x, ODCoordinate y );
	void    operator+=( const ODPoint& );
	void    operator-=( const ODPoint& );
	
	// ACCESSORS:

	ODSShort        IntX( )         const;          // Returns X-coord as (16bit) integer
	ODSShort        IntY( )         const;          // Returns Y-coord as (16bit) integer
	
	// COMPARISON:
	
	ODBoolean       operator==( const ODPoint& )    const;
	ODBoolean       operator!=( const ODPoint& )    const;
	
	// MAC TOOLBOX CONVENIENCES:
	
#ifdef _PLATFORM_MACINTOSH_
	ODPoint( Point );                                                       // Construct from QD point
	ODPoint& operator= ( const Point& );            // Copy from a QD Point
	Point   AsQDPoint( )                                    const;  // Convert to integer (QD) point
	void    operator+=( const    Point& );                  // Add/subtract QD point
	void    operator-=( const    Point& );
#endif

#ifdef PLATFORM_WINDOWS
	ODPoint( Point );                                                       // Construct from QD point
	ODPoint& operator= ( const Point& );            // Copy from a QD Point
	void    operator+=( const    Point& );                  // Add/subtract QD point
	void    operator-=( const    Point& );
	Point   AsWinPoint( )                                   const;  // Convert to integer (QD) point
#endif
};


//==============================================================================
// ODRect
//==============================================================================

struct ODExport ODRect {
	public:
	
	// CONTENTS:
	
	ODCoordinate left, top, right, bottom;
		
	// CONSTRUCTORS:
	
	ODRect( )               { }
	ODRect( ODCoordinate l, ODCoordinate t,
				  ODCoordinate r, ODCoordinate b )
			{left=l; top=t; right=r; bottom=b; }
	ODRect( const ODPoint&, const ODPoint& );       // Any 2 opposite pts
	ODRect( const ODPoint &topLeft, ODCoordinate width, ODCoordinate height );
//bgn#if _PLATFORM_MACINTOSH_
	ODRect( const Rect& );
//bgn#endif
	
	// ASSIGNMENT:
	
//bgn#if _PLATFORM_MACINTOSH_
	ODRect& operator= ( const Rect& );
//bgn#endif
	
	// MODIFICATION:
	
	void    Clear( );
	void    Set( ODCoordinate l, ODCoordinate t, ODCoordinate r, ODCoordinate b );
	void    Set( const ODPoint&, ODCoordinate width, ODCoordinate height );
	void    SetInt( short l, short t, short r, short b );
	void    Offset( ODCoordinate x, ODCoordinate y );
	void    Offset( const ODPoint& );
	void    Inset( ODCoordinate x, ODCoordinate y );
	
	void    operator&= ( const ODRect& );   // Intersect with rectangle
	void    operator|= ( const ODRect& );   // Union with rectangle
	void    operator|= ( const ODPoint& );          // Expand to fit point
		
	// ACCESSORS
	
	const ODPoint& TopLeft( )                                                                               const
								{return *(ODPoint*)&left;}
	ODPoint&                TopLeft( )
								{return *(ODPoint*)&left;}
	const ODPoint& BotRight( )                                                                              const
								{return *(ODPoint*)&right;}
	ODPoint&                BotRight( )
								{return *(ODPoint*)&right;}
	ODCoordinate    Width( )                                                                                const
								{return right-left;}
	ODCoordinate    Height( )                                                                               const
								{return bottom-top;}
#if _PLATFORM_MACINTOSH_
	void                    AsQDRect( Rect& )                                                               const;
#endif
	
#ifdef PLATFORM_WINDOWS
	void                    AsWinRect( Rect& )                                                              const;
#endif

	// TESTING

	ODBoolean       operator==( const ODRect& )                                             const;
	ODBoolean       operator!=( const ODRect &r )                                           const
								{return !(*this==r);}
	
	ODBoolean IsEmpty( )                                                                                    const;
	ODBoolean Contains( const ODPoint& )                                                    const;
	ODBoolean Contains( const ODRect& )                                                     const;
	ODBoolean Intersects( const ODRect& )                                           const;
};


#endif //_ALTPOINT_
