/**/
/*											
	cApple Computer, Inc.  2/21/91 			
	      All Rights Reserved.				

*/

#ifndef __AEOBJECTS__
#define __AEOBJECTS__

//bgw #ifndef __MEMORY__
//bgw #include "Memory.h"
//bgw #endif


//bgw #ifndef __OSUTILS__
//bgw #include "OSUtils.h"
//bgw #endif

//bgw #ifndef __EVENTS__
//bgw #include "Events.h"
//bgw #endif

//bgw #ifndef __EPPC__
//bgw #include "EPPC.h"
//bgw #endif

#ifndef __APPLEEVENTS__
#include "Applevnt.h"
#endif

/* Logical operators: look for them in descriptors of type typeLogicalDescriptor
  with keyword keyAELogicalOperator */
#define kAEAND						LONGCONST('A','N','D',' ')
#define kAEOR						LONGCONST('O','R',' ',' ')
#define kAENOT						LONGCONST('N','O','T',' ')

/* Absolute ordinals: look for them in descriptors of type typeAbsoluteOrdinal.
  Possible use is as keyAEKeyData in an object specifier whose keyAEKeyForm
  field is formAbsolutePosition. */
#define kAEFirst					LONGCONST('f','i','r','s')
#define kAELast						LONGCONST('l','a','s','t')
#define kAEMiddle					LONGCONST('m','i','d','d')
#define kAEAny						LONGCONST('a','n','y',' ')
#define kAEAll						LONGCONST('a','l','l',' ')

/*  Relative ordinals: look for them in descriptors of type formRelativePosition. */
#define kAENext						LONGCONST('n','e','x','t')
#define kAEPrevious					LONGCONST('p','r','e','v')

/********** Keywords for getting fields out of object specifier records **********/
#define keyAEDesiredClass			LONGCONST('w','a','n','t')
#define keyAEContainer				LONGCONST('f','r','o','m')
#define keyAEKeyForm				LONGCONST('f','o','r','m')
#define keyAEKeyData	 		 	LONGCONST('s','e','l','d')


/********** Keywords for getting fields out of Range specifier records **********/
#define keyAERangeStart				LONGCONST('s','t','a','r')		/* These are the only two fields in the range desc */
#define keyAERangeStop				LONGCONST('s','t','o','p')
	
/********** Possible values for the keyAEKeyForm field of an object specifier **********/
/* Remember that this set is an open-ended one.  The OSL makes assumptions about some of them,
  but nothing in the grammar says you can't define your own */
#define formAbsolutePosition 		LONGCONST('i','n','d','x')	 	/* e.g., 1st, -2nd ( 2nd from end) */
#define formRelativePosition		LONGCONST('r','e','l','e') 		/* next, previous */
#define formTest					LONGCONST('t','e','s','t') 		/* A logical or a comparison */
#define formRange					LONGCONST('r','a','n','g') 		/* Two arbitrary objects and everything in between */
#define formPropertyID				LONGCONST('p','r','o','p') 		/* Key data is a 4-char property name */
#define formName					LONGCONST('n','a','m','e') 		/* Key data may be of type 'TEXT' */

/************** Various relevant types ****************/
/* Some of these tend to be paired with certain of the forms above.  Where this
  is the case comments indicating the form(s) follow. */
#define typeObjectSpecifier 	 	LONGCONST('o','b','j',' ')		/* keyAEContainer will often be one of these */
#define typeObjectBeingExamined 	LONGCONST('e','x','m','n')		/* Another possible value for keyAEContainer */
#define typeCurrentContainer		LONGCONST('c','c','n','t')		/* Another possible value for keyAEContainer */
#define typeToken					LONGCONST('t','o','k','e')		/* Substituted for 'ccnt' before accessor called */

#define typeRelativeDescriptor 		LONGCONST('r','e','l',' ')		/* formRelativePosition */
#define typeAbsoluteOrdinal 		LONGCONST('a','b','s','o')		/* formAbsolutePosition */
#define typeIndexDescriptor			LONGCONST('i','n','d','e')		/* formAbsolutePosition */
#define typeRangeDescriptor 	 	LONGCONST('r','a','n','g')		/* formRange */
#define typeLogicalDescriptor	 	LONGCONST('l','o','g','i')		/* formTest is this or typeCompDescriptor */
#define typeCompDescriptor			LONGCONST('c','m','p','d')		/* formTest is this or typeLogicalDescriptor */
	
/************** various relevant keywords ****************/
#define keyAECompOperator			LONGCONST('r','e','l','o')		/* Relates two terms: '', '<', etc. */
#define keyAELogicalTerms			LONGCONST('t','e','r','m')		/* An AEList of terms to be related by 'logc' below */
#define keyAELogicalOperator		LONGCONST('l','o','g','c')		/* kAEAND,  kAEOR or kAENOT */
#define keyAEObject1				LONGCONST('o','b','j','1')		/* One of two objects in a term must be object specifier */
#define keyAEObject2				LONGCONST('o','b','j','2')		/* The other object may be a simple descriptor or obj. spec. */


/************ Special Handler selectors for OSL Callbacks ***************/
/* You don't need to use these unless you are not using AESetObjectCallbacks. */
#define keyDisposeTokenProc			LONGCONST('x','t','o','k')
#define keyAECompareProc 		 	LONGCONST('c','m','p','r')
#define keyAECountProc 			 	LONGCONST('c','o','n','t')
#define keyAEMarkTokenProc 		 	LONGCONST('m','k','i','d')
#define keyAEMarkProc 			 	LONGCONST('m','a','r','k')
#define keyAEAdjustMarksProc 	 	LONGCONST('a','d','j','m')
#define keyAEGetErrDescProc 	 	LONGCONST('i','n','d','c')

/************ Error codes ***************/
/* OSL error codes: AEM proper uses up to -1719*/
#define errAEImpossibleRange		-1720 		/* A range like 3rd to 2nd, or 1st to all. */
#define errAEWrongNumberArgs		-1721 		/* Logical op kAENOT used with other than 1 term */

#define errAEAccessorNotFound 		-1723 		/* Accessor proc matching wantClass and containerType
												...or wildcards not found */
#define errAENoSuchLogical			-1725 	 	/* Something other than AND, OR, or NOT */
#define errAEBadTestKey				-1726 		/* Test is neither typeLogicalDescriptor
												...nor typeCompDescriptor */
#define errAENotAnObjSpec			-1727 	 	/* Param to AEResolve not of type 'obj ' */
#define errAENoSuchObject			-1728  		/* e.g.,: specifier asked for the 3rd, but there are only 2.
												...Basically, this indicates a run-time resolution error. */
#define errAENegativeCount			-1729 		/* CountProc returned negative value */
#define errAEEmptyListContainer		-1730 		/* Attempt to pass empty list as container to accessor */
	
/* Possible values for flags parameter to AEResolve.  They're additive */
#define kAEIDoMinimum				0x0000 
#define kAEIDoWhose					0x0001 
#define kAEIDoMarking				0x0004 

/* You only care about the constants that follow if you're doing your own whose
  clause resolution */
#define typeWhoseDescriptor			LONGCONST('w','h','o','s')
#define formWhose					LONGCONST('w','h','o','s')
#define typeWhoseRange				LONGCONST('w','r','n','g')
#define keyAEWhoseRangeStart		LONGCONST('w','s','t','r')
#define keyAEWhoseRangeStop			LONGCONST('w','s','t','p')
#define keyAEIndex					LONGCONST('k','i','d','x')
#define keyAETest					LONGCONST('k','t','s','t')


struct ccntTokenRecord {		/* used for rewriting tokens in place of 'ccnt' descriptors		*/
		DescType tokenClass ;	/* This record is only of interest to those who, when they...	*/
		AEDesc token ;			/* ...get ranges as key data in their accessor procs, choose	*/
	} ;							/* ...to resolve them manually rather than call AEResolve again.	*/
	
typedef struct ccntTokenRecord ccntTokenRecord, *ccntTokenRecPtr ;
#ifdef PLATFORM_MACINTOSH
typedef ccntTokenRecPtr *ccntTokenRecHandle;
#endif
#ifdef PLATFORM_WINDOWS
typedef HANDLE ccntTokenRecHandle;
#endif

typedef AEDesc *DescPtr;
#ifdef PLATFORM_MACINTOSH
typedef DescPtr *DescHandle;
#endif
#ifdef PLATFORM_WINDOWS
typedef	HANDLE DescHandle;
#endif

/* typedefs providing type checking for procedure pointers */

//bgw
typedef OSErr (pascal *OSLAccessorProcPtr)(DescType desiredClass,
		const AEDesc *container, DescType containerClass,DescType form,
		const AEDesc *selectionData, AEDesc *value, long accessorRefcon);

typedef OSLAccessorProcPtr OSLAccessorUPP;
//end bgw

#ifdef PLATFORM_MACINTOSH
typedef pascal OSErr (*accessorProcPtr) ( DescType desiredClass,
		const AEDesc *container, DescType containerClass, DescType form,
		const AEDesc *selectionData, AEDesc *value, long LongInt ) ;

typedef pascal OSErr (*compareProcPtr)( DescType oper, const AEDesc *obj1,
			const AEDesc *obj2, Boolean *result ) ;
typedef pascal OSErr (*countProcPtr)( DescType desiredType, DescType containerClass,
			const AEDesc *container, long *result ) ;
typedef pascal OSErr (*disposeTokenProcPtr)( AEDesc *unneededToken ) ;

typedef pascal OSErr (*getMarkTokenProcPtr)( const AEDesc *dContainerToken, DescType containerClass,
			AEDesc *result ) ;


typedef pascal OSErr (*getErrDescProcPtr)( DescPtr *appDescPtr ) ;

/* Note: app is supposed to dispose of dToken after marking */
typedef pascal OSErr (*markProcPtr)( const AEDesc *dToken, const AEDesc *markToken, long index ) ;
typedef pascal OSErr (*adjustMarksProcPtr)( long newStart, long newStop, const AEDesc *markToken ) ;

#endif //PLATFORM_MACINTOSH

/* PUBLIC PROCEDURES */


OSErr pascal AEObjectInit(void) ;
/* Not done by inline, but by direct linking into code.  It sets up the pack
  such that further calls can be via inline */

#ifdef PLATFORM_MACINTOSH

pascal OSErr AESetObjectCallbacks(
							compareProcPtr		myCompareProc,
							countProcPtr		myCountProc,
							disposeTokenProcPtr myDisposeTokenProc,	
							getMarkTokenProcPtr myGetMarkTokenProc,			/* called when mark (below) is true (all 3)*/
							markProcPtr			myMarkProc,
							adjustMarksProcPtr	myAdjustMarksProc,
							getErrDescProcPtr	myGetErrDescProcPtr )
= { 0x303C, 0x0E35, 0xA816 } ;




pascal OSErr  AEResolve		(	const AEDesc	*objectSpecifier,
								short			callbackFlags,		/* see above for possible values */
					  			AEDesc			*theToken )
= { 0x303C, 0x0536, 0xA816 } ;


pascal OSErr AEInstallObjectAccessor(
								DescType		desiredClass,
							   	DescType		containerType,
							   	accessorProcPtr theAccessor,
							   	long			accessorRefcon,
							   	Boolean			isSysHandler )
= { 0x303C, 0x0937, 0xA816 } ;

pascal OSErr AERemoveObjectAccessor(
								DescType		desiredClass,
								DescType		containerType,
								accessorProcPtr theAccessor,
								Boolean			isSysHandler )
= { 0x303C, 0x0738, 0xA816 } ;

pascal OSErr AEGetObjectAccessor(
								DescType 		desiredClass,
								DescType		containerType,
								accessorProcPtr	*accessor,
								long			*accessorRefcon,
								Boolean			isSysHandler )
= { 0x303C, 0x0939, 0xA816 } ;

pascal OSErr AEDisposeToken( AEDesc *theToken )
= { 0x303C, 0x023A, 0xA816 } ;

pascal OSErr AECallObjectAccessor(	DescType		desiredClass,
									const AEDesc	*containerToken,
									DescType		containerClass,
									DescType		keyForm,
									const AEDesc	*keyData,
									AEDesc			*token )
= { 0x303C, 0x0C3B, 0xA816 } ;




/*
Here are the interfaces your callback procs must be written to:

pascal OSErr MyCompareProc( DescType comparisonOperator, const AEDesc *theObject,
		const AEDesc *descOrObj, Boolean *result ) ;
pascal OSErr MyCountProc( DescType desiredType, DescType containerClass,
			const AEDesc *container, long *result:  ) ;
pascal OSErr MyGetMarkToken( const AEDesc *containerToken, DescType containerClass,
		AEDesc *result ) ;
pascal OSErr MyMark( const AEDesc *theToken, const AEDesc *markToken, long markCount ) ;
pascal OSErr MyAdjustMarks( long newStart, long newStop, const AEDesc *markToken ) ;
pascal OSErr MyMyDisposeToken( AEDesc *unneededToken ) ;
pascal OSErr MyGetErrDesc( DescPtr *appDescPtr ) ;

pascal OSErr MyObjectAccessor( DescType desiredClass, const AEDesc *containerToken,
		DescType containerClass, DescType keyForm, const AEDesc *keyData,
		AEDesc *theToken, long *theRefcon ) ;

You'll probably want to have a number of these last ones.
A proc that finds a line within a document should be installed with 'line' and 'docu'
as the desiredClass and containerClass fields in the call to AEInstallObjectHandler().
*/

#endif	//PLATFORM_MACINTOSH

#endif
