/*
	File:		AEHshTbl.h

	Contains:	Interface to AppleEvent hash table code and XMPAEHashTable
				class.

	Owned by:	Nick Pilch

	Copyright:	c 1993-94 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		 <1>	10/24/94	jpa		first checked in
		 <8>	 8/19/94	NP		1181622: Ownership fix.
		 <7>	 8/11/94	eeh		moved stuff OSL requires to HshTbTyp.h in
									OSL directory.
		 <6>	  6/9/94	RR		Include PlfmDef.h
		 <5>	  6/3/94	NP		Testing. No changes.
		 <4>	 5/27/94	VL		Changed XMPAEHashTable or ODAEHashTable to
									AEHashTable. Added KeyPtr and HEntryPtr.
		 <2>	  5/5/94	CG		Did some XMP->OD renaming.  Didn't rename
									any private stuff yet.
		 <1>	  5/5/94	CG		first checked in

	To Do:
*/

#ifndef _AEHSHTBL_
#define _AEHSHTBL_

#ifndef _ODTYPES_
#include "ODTypes.h"
#endif

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef _LIST_
#include "List.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
	C Interface to some of the routines in HashTabl.A and class wrapper.

	The class simply provides an object-oriented wrapper to the AE hash table
	functions found in HashTable.A. It removes access to the MemHooks parameter. (MemHooks is set to NULL and SysHeap is set to false.)
	It hides the Table parameter since that is a member variable of the class.
*/

//==============================================================================
// Scalar Types
//==============================================================================

typedef void* ODEntryPtr;
typedef void* ODKeyPtr;
typedef	Handle HashTable;


//==============================================================================
// Error Codes
//==============================================================================

const ODSShort kAEErrAlreadyExists	= -1722;
const ODSShort kAEErrNotFound		= -1723;
const ODSShort kAEErrEndOfTable	= -1724;


//==============================================================================
// Classes defined in this interface
//==============================================================================

class AEHashTable;
class AEHashTableIterator;

//==============================================================================
// AEHashTable
//==============================================================================

#ifdef SHIPPING
class AEHashTable
#else
//exported for non-shipping code only! Browser needs it
class ODExport AEHashTable
#endif
{	
	friend class AEHashTableIterator;

  public:

	AEHashTable();
	ODVMethod void Initialize(ODULong numEntries, ODUShort keySize,
								ODUShort valueSize, ODBoolean inSysHeap);
		// kODErrOutOfMemory is thrown if the table cannot be created.

	virtual ~AEHashTable();

	ODVMethod void			ReplaceEntry(ODKeyPtr key, ODEntryPtr value);
		// Replace and/or add an entry. Pass a POINTER to the key as well as a
		//	a POINTER to the value to be added. kODErrOutOfMemory is thrown if
		//	the entry cannot be added.

	ODVMethod void			RemoveEntry(ODKeyPtr key);
		// Pass a POINTER to the key.

	ODVMethod ODBoolean	GetValue(ODKeyPtr key, ODEntryPtr value);
		// Pass a POINTER to the key as well as a POINTER to the value to be
		//	retrieved. kODTrue is returned if the key was found, kODFalse
		//	otherwise.
		
	ODVMethod ODBoolean	Exists(ODKeyPtr key);
		// Check to see if a key exists. This function is no faster than
		//	GetValue and should probably only be used when you do not intend to
		//	fetch the value immediately. kODTrue is returned if the key exists,
		//	kODFalse, otherwise.
	
  protected:

#ifdef PLATFORM_MACINTOSH
	HashTable	fAEHashTable;
	ODUShort 	fValueSize;
	
	HashTable	GetAEHashTable();
#endif
#ifdef PLATFORM_WINDOWS
	LinkedList		m_linklist;
	ODUShort		m_keySize;
	ODUShort		m_valueSize;
#endif	
};

//==============================================================================
// AEHashTableIterator
//
//	This iterator is only meant to be used in the the context of a for loop,
//	e.g.:
//
//	AEHashTableIterator iter;
//	for (iter.First(key, value); iter.IsNotComplete(); iter.Next(key, value))
//	{
//		...
//	}
//
//==============================================================================

#ifdef PLATFORM_WINDOWS
 class  ODAEHashLink : public Link
 {
	  public:
		ODAEHashLink () {m_key = &m_kStorage; m_value = &m_vStorage; };
		~ODAEHashLink () { };
		
		ODULong	m_kStorage;
		ODULong	junk;		//bgw - leave space for bigger keys
		ODULong	junk1;
		ODULong	m_vStorage;
		ODULong	junk2;		//bgw - leave space for bigger values
		ODULong	junk3;
		ODKeyPtr	m_key;
		ODEntryPtr	m_value;
		 
 };
#endif

class AEHashTableIterator
{
  public:
	AEHashTableIterator(AEHashTable* table);
	~AEHashTableIterator();
	
	void			First(ODKeyPtr key, ODEntryPtr value);
	void			Next(ODKeyPtr key, ODEntryPtr value);
	ODBoolean		IsNotComplete();
  private:
	AEHashTable* fTable;
	ODSLong		fIndex;
	ODBoolean		fDone;
	ODBoolean		GetNext(ODKeyPtr key, ODEntryPtr value);
#ifdef PLATFORM_WINDOWS
	LinkedListIterator * m_pLinkListIter;
#endif	
};

#endif // _AEHSHTBL_
