
/*
 *  This file was generated by the SOM Compiler.
 *  Generated using:
 *     SOM incremental update: 10.9
	Last change:  KAS  18 Oct 94    4:06 pm
 */


#ifndef lint
static char *sccsid = "@(#)51 1.1 9/28/93 11:47:35 [10/14/94] (c)IBM Corp. 1992";
#endif

/*
 * This class is adapted from the book
 *   Class Construction in C and C++, Object Oriented Fundamentals
 *   by Roger Sessions, Copyright (c) 1992 Prentice Hall.
 * Reprinted with permission.
 */

#define word_Class_Source
#include "word.ih"
#include <stdlib.h>
#include <string.h>

static int nNews = 0;
static int nDeletes = 0;
#define PARRAY_SIZE		1000
static char *parray[PARRAY_SIZE];


/* ************************************************************ */
/*
 *  Initialize a word with a character string.
 */

SOM_Scope word*  SOMLINK wordInit1(word *somSelf,
		string newWord)
{
    wordData *somThis = wordGetData(somSelf);
    wordMethodDebug("word", "wordInit1");

    if (_storage)
      #ifdef _WIN32
      SOMFree(_storage);
      #else
	free(_storage);
	#endif /*WIN32*/
    _storage = (string) SOMMalloc(strlen(newWord) + 1);
    strcpy(_storage, newWord);
    _length = strlen(newWord);
    parray[nNews] = _storage;
    nNews++;
    return somSelf;
}

/* ************************************************************ */
/*
 *  Initialize a word with a character and
 *  count.  The new word will contain a null
 *  terminated buffer containing count number of
 *  newChars.
 */

SOM_Scope word*  SOMLINK wordInit2(word *somSelf,
		char newChar,
		long count)
{
    wordData *somThis = wordGetData(somSelf);
    int n;

    wordMethodDebug("word", "wordInit2");

    if (_storage)
      #ifdef _WIN32
      SOMFree(_storage);
      #else
	free(_storage);
	#endif /*WIN32*/
    _storage = (string) SOMMalloc(count + 1);
    for (n = 0; n < count; n++) {
	_storage[n] = newChar;
    }
    _storage[n] = '\0';
    _length = strlen(_storage);
    parray[nNews] = _storage;
    nNews++;
    return somSelf;
}

/* ************************************************************ */
/*
 *  Translate a word to an integer, such as "123" to 123.
 */

SOM_Scope long  SOMLINK wordToInt(word *somSelf)
{
    wordData *somThis = wordGetData(somSelf);
    wordMethodDebug("word", "wordToInt");
    return atoi(_storage);
}

/* ************************************************************ */

/*
 * SOM_Scope boolean SOMLINK match(word * somSelf,
 * 			     void *target)
 */

SOM_Scope boolean  SOMLINK match(word *somSelf,
                                 string target)
{
    wordData *somThis = wordGetData(somSelf);
    int targetLength = strlen(target);
    wordMethodDebug("word", "match");
    return (!strncmp(_storage, target, targetLength));
}

/* ************************************************************ */
SOM_Scope void SOMLINK print(word * somSelf,
			      FILE * outputFile)
{
    wordData *somThis = wordGetData(somSelf);
    wordMethodDebug("word", "print");

    fprintf(outputFile, "%s", _storage);
    fflush(outputFile);
}

/* ************************************************************ */
SOM_Scope void SOMLINK somInit(word * somSelf)
{
    wordData *somThis = wordGetData(somSelf);
    wordMethodDebug("word", "somInit");
    parent_somInit(somSelf);
    _storage = 0;
}

/* ************************************************************ */
SOM_Scope void SOMLINK somUninit(word * somSelf)
{
    wordData *somThis = wordGetData(somSelf);
    wordMethodDebug("word", "somUninit");
    if (_storage)
      #ifdef _WIN32
      SOMFree(_storage);
      #else
	free(_storage);
	#endif /*WIN32*/
    parent_somUninit(somSelf);
}

/* ************************************************************ */

/*
 * SOM_Scope void SOMLINK somDumpSelfInt(word * somSelf,
 * 				       int level)
 */

/*
 * The prototype for somDumpSelfInt was replaced by the following prototype:
 */
SOM_Scope void  SOMLINK somDumpSelfInt(word *somSelf,
		long level)
{
    wordData *somThis = wordGetData(somSelf);
    wordMethodDebug("word", "somDumpSelfInt");
    parent_somDumpSelfInt(somSelf, level);
}

void showWordStats()
{
    int n;
    printf("\n");
    printf("   nNews: %d\n", nNews);
    printf("nDeletes: %d\n", nDeletes);
    for (n = 0; n < PARRAY_SIZE; n++) {
	if (parray[n]) {
	    printf("n: %d storage: %s\n", n, parray[n]);
	}
    }
}


/* ************************************************************ */
/*
 *  Replace the contents of a word by another word.
 */

SOM_Scope void  SOMLINK wrdReplace(word *somSelf,
		string newWord)
{
    wordData *somThis = wordGetData(somSelf);
    wordMethodDebug("word", "wrdReplace");

    _length = strlen(newWord);
    if (_storage)
      #ifdef _WIN32
      SOMFree(_storage);
      #else
	free(_storage);
	#endif /*WIN32*/
    _storage = (string) SOMMalloc(_length + 1);
    strcpy(_storage, newWord);
}
