#ifndef lint
static char *sccsid = "@(#)13 1.1 9/28/93 11:44:52 [8/24/94] (c)IBM Corp. 1993";
#endif

#include "animals.h"
#include <stdio.h>
#define BIG_DOG_MAX 4

int main(int argc, char *argv[])
{
    Environment *ev = somGetGlobalEnvironment ();
    string bigDogNames[] = {
        "Lassie", "Guffy", "Waldo", "Pluto", "Elvis", "Spike"
        };
    sequence(Animals_Animal) allCreatures;
    int i;

    /*
     * Create classes. 
     */
    Animals_AnimalNewClass (Animals_Animal_MajorVersion, 
        Animals_Animal_MinorVersion);
    Animals_DogNewClass (Animals_Dog_MajorVersion, Animals_Dog_MinorVersion);
    Animals_LittleDogNewClass (Animals_LittleDog_MajorVersion, 
        Animals_LittleDog_MinorVersion);
    Animals_BigDogNewClass (Animals_BigDog_MajorVersion,
        Animals_BigDog_MinorVersion);

    SOM_TraceLevel = (argc > 1 ? 1 : 0);

    /*
     * Create objects using constructors 
     */
    _newAnimal (_Animals_Animal, ev, "Scary", "Roar!!!");
    _newDog (_Animals_Dog, ev, "Rover", "Grrr", "Retriever", "yellow");
    _newDog (_Animals_LittleDog, ev, "Pierre", "yap yap", "French Poodle",
        "black");
    for (i=0; i<(sizeof(bigDogNames)/sizeof(string)); i++)
        _newDog (_Animals_BigDog, ev, bigDogNames[i], (string) NULL, 
            "German Shepherd", "brown");

    /*
     * Display objects. 
     */
    somPrintf ("=====================\n");
    allCreatures = __get_instances (_Animals_Animal, ev);
   
    for (i=0; i<allCreatures._length; i++) {
        _display (allCreatures._buffer[i], ev);
    }


    somPrintf ("Total animal population is currently %d.\n", 
        allCreatures._length);

    /*
     * Free objects. 
     */
    for (i=0; i<allCreatures._length; i++)
        _somFree (allCreatures._buffer[i]);

    somPrintf ("\n");

    return(0);
}
