/*
 *   COMPONENT_NAME: somx
 *
 *   ORIGINS: 27
 *
 *
 *   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
 *   All Rights Reserved
 *   Licensed Materials - Property of IBM
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */
/*   @(#) 1.8 src/win/somx/somem/c/emdemo/main.c, somx.somem, som2.1 9/21/94 17:01:08 [11/1/94 21:03:00] */

/*
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */

/*
   ==========================================================================
   main.c

   This test program exercises several facilities of Event Manager (EMan).
   It shows how to register interest in timer, socket, client and workproc
   events. It also shows how the callback routines are to be written.
   This program exercises all most all of EMan methods. For exercising socket
   related events, it creates an instance of SOMSockets class and uses it for all
   socket calls. It is important to make EMan applications (that use sockets) use the
   sockets class. Otherwise the application could end up making direct socket   calls
   while EMan could be using a different implementation of sockets. EMan picks
   the appropriate implementation of sockets based on the environment variable
   SOMSOCKETS.
   ==========================================================================
*/

/*  CHANGE HISTORY
        DATE    DEFECT      ID          DESCRIPTION             TAG
        3/1/94  2170    kthadani        Added Worstation Support    K1
*/

/* Definitions and includes.
 --------------------------- */
/* #define ILLUSTRATE_LOOP */

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <sys\types.h>
#include <time.h>
#include <errno.h>
#include <io.h>
#include <fcntl.h>
#include <share.h>

#include <som.h>     

/* EMan includes.
 ---------------- */
#include <eman.h>
#include <eventmsk.h>
#include "emobj.h"

#include "main.h"

BOOL InitAppl(HINSTANCE);

/* Globals.
 ---------- */
static  SOMEEMan           gEManPtr;
static  Environment        *testEnv;
static  EMObject           target;
static  long               regId0, regId1, regId2, regId4, fd;
static  SOMEClientEvent    clientEvent1, clientEvent2;
static  SOMEEMRegisterData data;
static  long               sock, msgsockregId, sockregId, PortNumber;

static  char               portnumbstr[10];

Environment *mainev;

HINSTANCE hinst;
HWND      hwndMain, hwndChild, hwndTimer, hwndWorkProc;
HACCEL    haccel;
short     sHighSock = 0;
int       nCmd;

int       nPops = 0; /* Number of Timer Pops since registration */
int       nWorkProcs = 0; /* Number of calls on WorkProc since registration */

struct msg_struct
{
   HWND hwnd;
   char szMsg[100];
};

#define WM_PROCESS_ARGS WM_USER + 100

void callBack( SOMEEvent  event, void  *targetData );
void ReadMsgAndPrint( SOMEEvent event, void *inputdata);
LRESULT APIENTRY MainWndProc(HWND hwnd, UINT message, UINT wParam,
                               LONG lParam);
#ifdef THREAD_EMAN
void startEman(void);
#endif

/*=========================================================================*/
/*                          Client Functions                               */
/*=========================================================================*/

void ErrorMessage(char *lpszFmt, ...)
{
   char szBuf[256];
   va_list args;

   va_start(args, lpszFmt);
   wvsprintf(szBuf, lpszFmt, args);
   MessageBox(hwndMain,szBuf,"EMAN Sample Error",MB_ICONEXCLAMATION | MB_OK);
}

void InfoMessage(char *title, char *lpszFmt, ...)
{
   char szBuf[256];
   va_list args;

   va_start(args, lpszFmt);
   wvsprintf(szBuf, lpszFmt, args);
   if (title)
      MessageBox(hwndMain,szBuf,title,MB_ICONINFORMATION);
   else {
      /* remove comments to get debug messages sent to debug window
      strcat(szBuf,"\r\n");
      OutputDebugString(szBuf);
      */
   }
}

void CheckEnv(Environment *ev) {
    if (ev->_major != NO_EXCEPTION) {
        ErrorMessage(somExceptionId(ev));
    }
}
/**************************** ACCEPT CONNECTION ****************************/


/*------------------------------  unRegister  -----------------------------*/

void  unRegister( long  id )
{
    Environment *env = somGetGlobalEnvironment();

    _someUnRegister( gEManPtr, env, id );
}


/*--------------------------  ChangeRegistrations  ------------------------*/

void ChangeRegistrations(HWND hwnd, char x)
{
    Environment        *env = somGetGlobalEnvironment();
    FARPROC            proc;
    HMENU              hMenu;

    hMenu = GetMenu(hwnd);

    switch (x) {
    case 'c' : /* make a client event of type 1 occur */
               _someQueueEvent(gEManPtr, env, clientEvent1);
               break;

    case 'C' : /* make a client event of type 2 occur */
               _someQueueEvent(gEManPtr, env, clientEvent2);
               break;

    case 'W' : /* register a work proc with eman */
               _someClearRegData( data, env );
               _someSetRegDataEventMask( data, env, EMWorkProcEvent, NULL );
               ShowWindow (hwndWorkProc,SW_SHOW);
               proc = MakeProcInstance((FARPROC)callBack, hinst);
               regId2 = _someRegisterProc( gEManPtr, env, data, (EMRegProc *)proc, "Work Proc" );
               EnableMenuItem(hMenu, IDM_REGPROC, MF_GRAYED);
               EnableMenuItem(hMenu, IDM_UNREGPROC, MF_ENABLED);
               nWorkProcs = 0;
               break;

    case 'w' : /* Unregister a workproc from eman */
               unRegister(regId2);
               ShowWindow (hwndWorkProc,SW_HIDE);
               EnableMenuItem(hMenu, IDM_REGPROC, MF_ENABLED);
               EnableMenuItem(hMenu, IDM_UNREGPROC, MF_GRAYED);
               break;

    case 't' : /* unregister timer events */
               unRegister(regId1);
               ShowWindow (hwndTimer,SW_HIDE);
               EnableMenuItem(hMenu, IDM_REGTIMER, MF_ENABLED);
               EnableMenuItem(hMenu, IDM_UNREGTIMER, MF_GRAYED);
               EnableMenuItem(hMenu, IDM_UPDTIMER, MF_GRAYED);
               break;

    case 'T' : /* reRegister timer events */
               _someClearRegData( data, env );
               _someSetRegDataEventMask( data, env, EMTimerEvent, NULL );
               _someSetRegDataTimerInterval( data, env, 1000 );
               ShowWindow (hwndTimer,SW_SHOW);
               proc = MakeProcInstance((FARPROC)callBack, hinst);
               regId1 = _someRegisterProc( gEManPtr,
                                           env,
                                           data,
                                           (EMRegProc *)proc,
                                           "Timer Pop" );
               EnableMenuItem(hMenu, IDM_REGTIMER, MF_GRAYED);
               EnableMenuItem(hMenu, IDM_UNREGTIMER, MF_ENABLED);
               EnableMenuItem(hMenu, IDM_UPDTIMER, MF_ENABLED);
               nPops = 0;
               break;

    case 'U' : /* update the timer registration data to change the timer interval value*/
               _someClearRegData( data, env );
               _someSetRegDataEventMask( data, env, EMTimerEvent, NULL );
               _someSetRegDataTimerInterval( data, env, 800 );
               _someChangeRegData(gEManPtr, env, regId1, data);
               EnableMenuItem(hMenu, IDM_UPDTIMER, MF_GRAYED);
               break;

    case 'q' : /* Quit program */
    case 'Q' :
               SendMessage(hwnd,WM_CLOSE,0,0L);
               break;

    default:
               ErrorMessage("Unknown command: %c\r\n", x);
               break;
    }
}

/*-------------------------------  callBack  ------------------------------*/

void callBack( SOMEEvent  event, void  *targetData )
{
     Environment *env = somGetGlobalEnvironment();
     static BOOL fFlipFlop = FALSE ;
     HBRUSH      hBrush ;
     HDC         hdc ;
     PAINTSTRUCT ps ;
     RECT        rc ;
     COLORREF    bkColor , fgColor;
     char        szTimer[15];

    switch( _somevGetEventType( event, env )) {

    case  EMTimerEvent:
        MessageBeep (MB_ICONEXCLAMATION) ;
        InvalidateRect (hwndTimer, NULL, FALSE) ;
        hdc = BeginPaint (hwndTimer, &ps) ;
        GetClientRect (hwndTimer, &rc) ;
        /* flip the background and foreground colors */
        if (fFlipFlop = !fFlipFlop) {
            bkColor = RGB(255,255,255);
            fgColor = RGB(0,0,0);
        } else {
            bkColor = RGB(0,0,0) ;
            fgColor = RGB(255,255,255) ;
        }
        /* fill the window */
        hBrush = CreateSolidBrush (bkColor) ;
        FillRect (hdc, &rc, hBrush) ;
        /* draw the text */
        wsprintf(szTimer, "%s %d", (LPSTR) targetData, ++nPops);
        SetBkColor(hdc, bkColor) ;
        SetTextColor(hdc, fgColor) ;
        DrawText (hdc, szTimer, -1, &rc, DT_SINGLELINE | DT_CENTER | DT_VCENTER);
        EndPaint (hwndTimer, &ps) ;
        DeleteObject (hBrush) ;
        break;

    case  EMSinkEvent:
        InfoMessage(NULL, "callback: Perceived Sink Event event with data: %s\r\n", targetData);
        break;

    case  EMClientEvent:
        InfoMessage("Client Type 2", "Client Event Data: %s", (LPSTR) targetData);
        break;

    case  EMWorkProcEvent:
        InvalidateRect (hwndWorkProc, NULL, FALSE) ;
        hdc = BeginPaint (hwndWorkProc, &ps) ;
        GetClientRect (hwndWorkProc, &rc) ;
        bkColor = RGB(nWorkProcs % 255,0,255);
        fgColor = RGB(0,0,0);
        hBrush = CreateSolidBrush (bkColor) ;
        FillRect (hdc, &rc, hBrush) ;
        /* draw the text */
        wsprintf(szTimer, "%s %d", (LPSTR) targetData,++nWorkProcs);
        SetBkColor(hdc, bkColor) ;
        SetTextColor(hdc, fgColor) ;
        DrawText (hdc, szTimer, -1, &rc, DT_SINGLELINE | DT_CENTER | DT_VCENTER);
        EndPaint (hwndWorkProc, &ps) ;
        DeleteObject (hBrush) ;
        break;

    default: ErrorMessage("Unknown Event type in callback\n");
    }
}


/*---------------------------  MsgToCmd  ----------------------------------*/

char MsgToCmd(WORD msg, LPARAM lParam)
{
   char chCmd;

   switch (msg)
   {
      case IDM_REGPROC:
         chCmd = 'W';
         break;

      case IDM_UNREGPROC:
         chCmd = 'w';
         break;

      case IDM_REGTIMER:
         chCmd = 'T';
         break;

      case IDM_UNREGTIMER:
         chCmd = 't';
         break;

      case IDM_UPDTIMER:
         chCmd = 'U';
         break;

      case IDM_CLIENT1:
         chCmd = 'c';
         break;

      case IDM_CLIENT2:
         chCmd = 'C';
         break;

      case IDM_QUIT:
         chCmd = 'Q';
         break;

      case ID_CMD:
         chCmd = LOBYTE(LOWORD(lParam));
         break;

      default:
         chCmd = -1;
         break;
   }

   return chCmd;
}

/*---------------------------  MainWndProc  -------------------------------*/


LRESULT APIENTRY MainWndProc(HWND hwnd, UINT message, UINT wParam,
                               LONG lParam)
{
   char chCmd;
   char *pTemp, *pBuf;
   short cxClient, cyClient, i;

   switch (message)
   {
      case WM_CREATE:
         haccel = LoadAccelerators(hinst, "MainAccel");
         EnableMenuItem(GetMenu(hwnd), IDM_REGSOCK, MF_GRAYED);
         break;

      case WM_SIZE:
         cxClient = LOWORD (lParam) ;
         cyClient = HIWORD (lParam) ;

         MoveWindow (hwndTimer, 5, 5, cxClient / 5, cyClient / 5, TRUE) ;
         MoveWindow (hwndWorkProc, 10 + (cxClient / 5),
                                   5,
                                   cxClient / 5,
                                   cyClient / 5,
                                   TRUE) ;

      case WM_COMMAND:
         if ((chCmd = MsgToCmd(wParam, lParam)) == -1)
         {
            return(DefWindowProc(hwnd, message, wParam, lParam));
         }
         else
         {
            ChangeRegistrations(hwnd, chCmd);
         }
         break;

      case WM_DESTROY:
         InfoMessage(NULL, "I'm being destroyed (%ld,%d)",(long) hwnd, sHighSock);
         PostQuitMessage(0);
         break;

      default:
         return (DefWindowProc(hwnd, message, wParam, lParam));
   }

   return 0;
}

/*---------------------------  InitAppl  ----------------------------------*/

BOOL InitAppl(HINSTANCE hinstCur)
{
   WNDCLASS wc;

   wc.style = 0;
   wc.lpfnWndProc = MainWndProc;
   wc.cbClsExtra = 0;
   wc.cbWndExtra = 0;
   wc.hInstance = hinstCur;
   wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
   wc.hCursor = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = GetStockObject(WHITE_BRUSH);
   wc.lpszMenuName = "MainMenu";
   wc.lpszClassName = "MainWClass";

   return(RegisterClass(&wc));

}

/*---------------------------  InitEMAN  ----------------------------------*/

BOOL InitEMAN(void)
{
    char        *comm_envvar;
    Environment *testEnv = somGetGlobalEnvironment();
    FARPROC     proc;

    gEManPtr = SOMEEManNew();         /* create an EMan object */
    data = SOMEEMRegisterDataNew( );    /* create a registration data object */
    target = EMObjectNew();    /* create a target object whose method is called back by EMan */

    /* Create a client event of type "ClientType1".
     ---------------------------------------------- */
    clientEvent1 = SOMEClientEventNew();
    _somevSetEventClientType( clientEvent1, testEnv, "ClientType1" );
    _somevSetEventClientData( clientEvent1,
                              testEnv,
                              "This is a test for EMObject: client event type 1");

    /* Register the event with EMan.
     ------------------------------- */
    _someClearRegData( data, testEnv );
    _someSetRegDataEventMask( data, testEnv, EMClientEvent, NULL );
    _someSetRegDataClientType(data, testEnv, "ClientType1");
    regId0 = _someRegisterEv( gEManPtr,
                            testEnv,
                            data,
                            target,
                            mainev,
                            "eventMethod",
                            "Hello Mom" );

    /* Create and register a different type of client event.
     ------------------------------------------------------- */
    clientEvent2 = SOMEClientEventNew();
    _somevSetEventClientType( clientEvent2, testEnv, "ClientType2" );
    _somevSetEventClientData( clientEvent2, testEnv, "This is a test for callBack proc: client event type 2" );
    _someClearRegData( data, testEnv ); /* Notice that the registration data object can be reused */
    _someSetRegDataEventMask( data, testEnv, EMClientEvent, NULL );
    _someSetRegDataClientType( data, testEnv, "ClientType2" );
    regId4 = _someRegisterProc( gEManPtr, testEnv, data, (EMRegProc *)callBack, "Hello Dad" );

    return(TRUE);
}

/*---------------------------  InitInst  ----------------------------------*/

BOOL InitInst(HINSTANCE hinstCur, int nCmdShow)
{
   HWND hwnd;

   hinst = hinstCur;

   hwnd = CreateWindow("MainWClass", "SOM Event Manager sample", WS_OVERLAPPEDWINDOW,
                       CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
                       CW_USEDEFAULT, NULL, NULL, hinstCur, NULL);

   hwndTimer = CreateWindow ("static", NULL, WS_CHILD | WS_DLGFRAME | SS_GRAYRECT,
                             0, 0, 0, 0,
                             hwnd, 0, hinstCur, NULL) ;

   hwndWorkProc = CreateWindow ("static", NULL, WS_CHILD | WS_DLGFRAME | SS_GRAYRECT,
                                0, 0, 0, 0,
                                hwnd, 0, hinstCur, NULL) ;

   if (hwnd == NULL)
   {
      return FALSE;
   }

   hwndMain = hwnd;
   nCmd = nCmdShow;

   return TRUE;
}


/*---------------------------  InitAppl  ----------------------------------*/

BOOL ProcessInput(LPSTR pszArgs)
{
   char *pBuf = NULL;
   BOOL fOk = FALSE;

   if (pszArgs != NULL && *pszArgs != 0)
   {
      pBuf = malloc(strlen(pszArgs) + 1);
      if (pBuf)
      {
         strcpy(pBuf, pszArgs);
         PostMessage(hwndMain, WM_PROCESS_ARGS, 0, (LPARAM)pBuf);
         fOk = TRUE;
      }
   }

   if (!fOk)
   {
      ShowWindow(hwndMain, nCmd);
      UpdateWindow(hwndMain);
   }

   return TRUE;
}

/*=========================================================================*/
/*                              Main Program                               */
/*=========================================================================*/

int WINAPI WinMain(HINSTANCE hinstCur, HINSTANCE hinstPrev, LPSTR lpszCmdLine,
                   int nCmdShow)
{
   short sQSize = 120;
   int iRc = TRUE;

#if defined(ILLUSTRATE_LOOP) || defined(THREAD_EMAN)
   MSG msg;
#if defined(THREAD_EMAN)
   DWORD threadId;
#endif

#endif

  
   testEnv = somGetGlobalEnvironment();

   if (!hinstPrev)
   {
      if (!InitAppl(hinstCur))
      {
         return FALSE;
      }
   }

   mainev = somGetGlobalEnvironment();

   if (!InitEMAN())
   {
      return FALSE;
   }

   while (!SetMessageQueue(sQSize))
   {
      sQSize--;
      if (sQSize < 8)
         return FALSE;
   }

   if (!InitInst(hinstCur, nCmdShow))
   {
      return FALSE;
   }

   if (ProcessInput(lpszCmdLine))
   {

    /*------------------------------------------------------------------------

       Two alternative schemes are possible for a program using Eman.
       The client program can provide its own main loop, polling Eman
       periodically to process events registered with EMan.

       Alternatively, the client can turn control over to EMan's main
       loop, with all client processing handled through the callback
       mechanism and a standard Windows message loop implemented.

       The latter scheme is employed when the program can be designed
       to be completely event-driven.  Both methods are illustrated below.

       Please note that the first scheme will not provide reliable timer
       events as GetMessage only returns when there is a window message to
       be processed.

     -------------------------------------------------------------------------*/

#ifdef ILLUSTRATE_LOOP

      while (GetMessage(&msg, NULL, NULL, NULL))
      {
         if (!TranslateAccelerator(hwndMain, haccel, &msg))
         {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
         }

         _someProcessEvent(gEManPtr, testEnv,
                           EMProcessTimerEvent
                         | EMProcessSinkEvent
                         | EMProcessClientEvent
                         | EMProcessWorkProcEvent );
      }

#elif !defined(THREAD_EMAN)

    /* Let EMan take over loop and process EMAN events between
       processing Windows events.
     --------------------------------------------------------- */
    InfoMessage(NULL,"Starting EMAN loop...");
      _someProcessEvents(gEManPtr, testEnv);
    InfoMessage(NULL,"...Left EMAN loop");

#else
      CreateThread(NULL, 0,
                   (LPTHREAD_START_ROUTINE)startEman,
                   NULL, 0, &threadId);
      while (GetMessage(&msg, NULL, NULL, NULL))
      {
         if (!TranslateAccelerator(hwndMain, haccel, &msg))
         {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
         }
      }

#endif
   }

   _somFree(gEManPtr);

   InfoMessage(NULL,"Quitting... iRc=%d",iRc);
   return(iRc);
}

#ifdef THREAD_EMAN
void startEman(void)
{
        _someProcessEvents(gEManPtr, testEnv);
}
#endif
